/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.response;

import edu.cmu.cs.stage3.alice.core.Direction;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.ReferenceFrame;
import edu.cmu.cs.stage3.alice.core.Transformable;
import edu.cmu.cs.stage3.alice.core.criterion.ElementNameContainsCriterion;
import edu.cmu.cs.stage3.alice.core.response.OrientationAnimation;
import edu.cmu.cs.stage3.math.Matrix33;

public class AbstractBodyPositionAnimation
extends OrientationAnimation {

    public abstract class RuntimeAbstractBodyPositionAnimation
    extends OrientationAnimation.RuntimeOrientationAnimation {
        protected Transformable rightUpper;
        protected Transformable rightLower;
        protected Transformable rightFoot;
        protected Transformable leftUpper;
        protected Transformable leftLower;
        protected Transformable leftFoot;
        protected Transformable rightUpperArm;
        protected Transformable rightLowerArm;
        protected Transformable leftUpperArm;
        protected Transformable leftLowerArm;
        protected Matrix33 rightUpperInitialOrient;
        protected Matrix33 rightLowerInitialOrient;
        protected Matrix33 rightFootInitialOrient;
        protected Matrix33 leftUpperInitialOrient;
        protected Matrix33 leftLowerInitialOrient;
        protected Matrix33 leftFootInitialOrient;
        protected Matrix33 rightUpperFinalOrient;
        protected Matrix33 rightLowerFinalOrient;
        protected Matrix33 rightFootFinalOrient;
        protected Matrix33 leftUpperFinalOrient;
        protected Matrix33 leftLowerFinalOrient;
        protected Matrix33 leftFootFinalOrient;
        protected Matrix33 rightUpperArmInitialOrient;
        protected Matrix33 rightLowerArmInitialOrient;
        protected Matrix33 leftUpperArmInitialOrient;
        protected Matrix33 leftLowerArmInitialOrient;
        protected Matrix33 rightUpperArmFinalOrient;
        protected Matrix33 rightLowerArmFinalOrient;
        protected Matrix33 leftUpperArmFinalOrient;
        protected Matrix33 leftLowerArmFinalOrient;

        public RuntimeAbstractBodyPositionAnimation() {
            super(AbstractBodyPositionAnimation.this);
            this.rightUpper = null;
            this.rightLower = null;
            this.rightFoot = null;
            this.leftUpper = null;
            this.leftLower = null;
            this.leftFoot = null;
            this.rightUpperArm = null;
            this.rightLowerArm = null;
            this.leftUpperArm = null;
            this.leftLowerArm = null;
            this.rightUpperInitialOrient = null;
            this.rightLowerInitialOrient = null;
            this.rightFootInitialOrient = null;
            this.leftUpperInitialOrient = null;
            this.leftLowerInitialOrient = null;
            this.leftFootInitialOrient = null;
            this.rightUpperFinalOrient = null;
            this.rightLowerFinalOrient = null;
            this.rightFootFinalOrient = null;
            this.leftUpperFinalOrient = null;
            this.leftLowerFinalOrient = null;
            this.leftFootFinalOrient = null;
            this.rightUpperArmInitialOrient = null;
            this.rightLowerArmInitialOrient = null;
            this.leftUpperArmInitialOrient = null;
            this.leftLowerArmInitialOrient = null;
            this.rightUpperArmFinalOrient = null;
            this.rightLowerArmFinalOrient = null;
            this.leftUpperArmFinalOrient = null;
            this.leftLowerArmFinalOrient = null;
        }

        protected void adjustHeight() {
            double distanceAboveGround = 0.0;
            if (this.m_subject != null) {
                distanceAboveGround = this.m_subject.getBoundingBox((ReferenceFrame)this.m_subject.getWorld()).getCenterOfBottomFace().y;
                double roundHeight = Math.round(this.m_subject.getBoundingBox((ReferenceFrame)this.m_subject.getWorld()).getCenterOfBottomFace().y);
                int level = (int)Math.round(roundHeight / 256.0);
                this.m_subject.moveRightNow(Direction.DOWN, distanceAboveGround - 256.0 * (double)level, this.m_subject.getWorld());
            }
        }

        public Transformable getTransformableChild(Transformable parent) {
            if (parent == null) {
                return null;
            }
            Element[] legBits = parent.getChildren(Transformable.class);
            if (legBits.length == 1) {
                return (Transformable)legBits[0];
            }
            return null;
        }

        protected void setOrientation(Transformable part, Matrix33 initialOrient, Matrix33 finalOrient, double portion) {
            if (part != null) {
                Matrix33 currentOrient = Matrix33.interpolate(initialOrient, finalOrient, portion);
                part.setOrientationRightNow(currentOrient, (ReferenceFrame)part.getParent());
            }
        }

        public void getInitialOrientations() {
            if (this.rightUpper != null) {
                this.rightUpperInitialOrient = this.rightUpper.getOrientationAsAxes((ReferenceFrame)this.rightUpper.getParent());
            }
            if (this.rightLower != null) {
                this.rightLowerInitialOrient = this.rightLower.getOrientationAsAxes((ReferenceFrame)this.rightLower.getParent());
            }
            if (this.rightFoot != null) {
                this.rightFootInitialOrient = this.rightFoot.getOrientationAsAxes((ReferenceFrame)this.rightFoot.getParent());
            }
            if (this.leftUpper != null) {
                this.leftUpperInitialOrient = this.leftUpper.getOrientationAsAxes((ReferenceFrame)this.leftUpper.getParent());
            }
            if (this.leftLower != null) {
                this.leftLowerInitialOrient = this.leftLower.getOrientationAsAxes((ReferenceFrame)this.leftLower.getParent());
            }
            if (this.leftFoot != null) {
                this.leftFootInitialOrient = this.leftFoot.getOrientationAsAxes((ReferenceFrame)this.leftFoot.getParent());
            }
            if (this.rightUpperArm != null) {
                this.rightUpperArmInitialOrient = this.rightUpperArm.getOrientationAsAxes((ReferenceFrame)this.rightUpperArm.getParent());
            }
            if (this.rightLowerArm != null) {
                this.rightLowerArmInitialOrient = this.rightLowerArm.getOrientationAsAxes((ReferenceFrame)this.rightLowerArm.getParent());
            }
            if (this.leftUpperArm != null) {
                this.leftUpperArmInitialOrient = this.leftUpperArm.getOrientationAsAxes((ReferenceFrame)this.leftUpperArm.getParent());
            }
            if (this.leftLowerArm != null) {
                this.leftLowerArmInitialOrient = this.leftLowerArm.getOrientationAsAxes((ReferenceFrame)this.leftLowerArm.getParent());
            }
        }

        public void findArms() {
            Element[] arms = this.m_subject.search(new ElementNameContainsCriterion("Arm"));
            int i = 0;
            while (i < arms.length) {
                if (arms[i].getKey().indexOf("left") != -1 && arms[i] instanceof Transformable) {
                    this.leftUpperArm = (Transformable)arms[i];
                    this.leftLowerArm = this.getTransformableChild(this.leftUpperArm);
                    if (this.leftLowerArm != null && this.leftLowerArm.name.getStringValue().indexOf("Hand") != -1) {
                        this.leftLowerArm = null;
                    }
                } else if (arms[i].getKey().indexOf("right") != -1 && arms[i] instanceof Transformable) {
                    this.rightUpperArm = (Transformable)arms[i];
                    this.rightLowerArm = this.getTransformableChild(this.rightUpperArm);
                    if (this.rightLowerArm != null && this.rightLowerArm.name.getStringValue().indexOf("Hand") != -1) {
                        this.rightLowerArm = null;
                    }
                }
                ++i;
            }
        }

        public void findLegs() {
            Element[] legs = this.m_subject.search(new ElementNameContainsCriterion("UpperLeg"));
            int i = 0;
            while (i < legs.length) {
                if (legs[i].getKey().indexOf("left") != -1 && legs[i] instanceof Transformable) {
                    this.leftUpper = (Transformable)legs[i];
                    this.leftLower = this.getTransformableChild(this.leftUpper);
                    if (this.leftLower.name.getStringValue().indexOf("Foot") != -1) {
                        this.leftFoot = this.leftLower;
                        this.leftLower = null;
                    }
                    this.leftFoot = this.leftLower != null ? this.getTransformableChild(this.leftLower) : this.getTransformableChild(this.leftUpper);
                } else if (legs[i].getKey().indexOf("right") != -1 && legs[i] instanceof Transformable) {
                    this.rightUpper = (Transformable)legs[i];
                    this.rightLower = this.getTransformableChild(this.rightUpper);
                    if (this.rightLower.name.getStringValue().indexOf("Foot") != -1) {
                        this.rightFoot = this.rightLower;
                        this.rightLower = null;
                    }
                    this.rightFoot = this.rightLower != null ? this.getTransformableChild(this.rightLower) : this.getTransformableChild(this.rightUpper);
                }
                ++i;
            }
        }
    }
}

