/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.question.ask;

import edu.cmu.cs.stage3.alice.core.Clock;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.property.StringProperty;
import edu.cmu.cs.stage3.alice.core.question.NumberQuestion;
import edu.cmu.cs.stage3.swing.DialogManager;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AskUserForNumber
extends NumberQuestion {
    public final StringProperty title = new StringProperty(this, "title", "Question");
    public final StringProperty question = new StringProperty(this, "question", "Enter a Number:");
    private Clock m_clock;

    @Override
    public Object getValue() {
        if (this.m_clock != null) {
            this.m_clock.pause();
        }
        try {
            String string = DialogManager.showInputDialog(this.question.getStringValue(), this.title.getStringValue(), 3);
            if (string != null) {
                if (string.matches("-?\\d+") || string.matches("-?\\d*\\.\\d+")) {
                    Double d = new Double(string);
                    return d;
                }
                Pattern p = Pattern.compile("(-?\\d*\\.\\d+)|(-?\\d+)");
                Matcher m = p.matcher(string);
                if (m.find()) {
                    String t = m.group();
                    Double d = new Double(t);
                    return d;
                }
            }
            Double d = new Double(0.0);
            return d;
        }
        finally {
            if (this.m_clock != null) {
                this.m_clock.resume();
            }
        }
    }

    @Override
    protected void started(World world, double time) {
        super.started(world, time);
        if (world != null) {
            this.m_clock = world.getClock();
        }
    }

    @Override
    protected void stopped(World world, double time) {
        this.m_clock = null;
        super.stopped(world, time);
    }
}

