/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.property;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.ExceptionWrapper;
import edu.cmu.cs.stage3.alice.core.ReferenceGenerator;
import edu.cmu.cs.stage3.alice.core.property.StringProperty;
import edu.cmu.cs.stage3.alice.scripting.Code;
import edu.cmu.cs.stage3.alice.scripting.CompileType;
import edu.cmu.cs.stage3.io.DirectoryTreeLoader;
import edu.cmu.cs.stage3.io.DirectoryTreeStorer;
import edu.cmu.cs.stage3.io.KeepFileDoesNotExistException;
import edu.cmu.cs.stage3.io.KeepFileNotSupportedException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Vector;
import org.w3c.dom.Document;

public class ScriptProperty
extends StringProperty {
    private Code m_code = null;

    public ScriptProperty(Element owner, String name, String defaultValue) {
        super(owner, name, defaultValue);
    }

    @Override
    protected void onSet(Object value) {
        super.onSet(value);
        this.m_code = null;
    }

    public Code getCode(CompileType compileType) {
        String script = this.getStringValue();
        if (script != null && script.length() > 0) {
            if (this.m_code == null) {
                this.m_code = this.getOwner().compile(script, this, compileType);
            }
        } else {
            this.m_code = null;
        }
        return this.m_code;
    }

    private String loadScript(InputStream is) throws IOException {
        String s;
        BufferedReader br = new BufferedReader(new InputStreamReader(new BufferedInputStream(is)));
        StringBuffer sb = new StringBuffer();
        while ((s = br.readLine()) != null) {
            sb.append(s);
            sb.append('\n');
        }
        if (sb.length() > 0) {
            return sb.substring(0, sb.length() - 1);
        }
        return "";
    }

    private void storeScript(OutputStream os) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(os);
        String script = this.getStringValue();
        if (script != null) {
            bos.write(script.getBytes());
        }
        bos.flush();
    }

    @Override
    protected void decodeObject(org.w3c.dom.Element node, DirectoryTreeLoader loader, Vector referencesToBeResolved, double version) throws IOException {
        this.m_associatedFileKey = null;
        String filename = this.getFilename(this.getNodeText(node));
        InputStream is = loader.readFile(filename);
        this.set(this.loadScript(is));
        loader.closeCurrentFile();
        try {
            this.m_associatedFileKey = loader.getKeepKey(filename);
        }
        catch (KeepFileNotSupportedException kfnse) {
            this.m_associatedFileKey = null;
        }
    }

    @Override
    protected void encodeObject(Document document, org.w3c.dom.Element node, DirectoryTreeStorer storer, ReferenceGenerator referenceGenerator) throws IOException {
        Object associatedFileKey;
        String filename = String.valueOf(this.getName()) + ".py";
        try {
            associatedFileKey = storer.getKeepKey(filename);
        }
        catch (KeepFileNotSupportedException kfnse) {
            associatedFileKey = null;
        }
        if (this.m_associatedFileKey == null || !this.m_associatedFileKey.equals(associatedFileKey)) {
            this.m_associatedFileKey = null;
            OutputStream os = storer.createFile(filename, true);
            this.storeScript(os);
            storer.closeCurrentFile();
            try {
                this.m_associatedFileKey = storer.getKeepKey(filename);
            }
            catch (KeepFileNotSupportedException kfnse) {
                this.m_associatedFileKey = null;
            }
        } else if (storer.isKeepFileSupported()) {
            try {
                storer.keepFile(filename);
            }
            catch (KeepFileNotSupportedException kfnse) {
                throw new Error(storer + " returns true for isKeepFileSupported(), but then throws " + kfnse);
            }
            catch (KeepFileDoesNotExistException kfdne) {
                throw new ExceptionWrapper(kfdne, filename);
            }
        }
        node.appendChild(this.createNodeForString(document, "java.io.File[" + filename + "]"));
    }

    @Override
    public void keepAnyAssociatedFiles(DirectoryTreeStorer storer) throws KeepFileNotSupportedException, KeepFileDoesNotExistException {
        super.keepAnyAssociatedFiles(storer);
        String filename = String.valueOf(this.getName()) + ".py";
        storer.keepFile(filename);
    }
}

