/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.property;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.ReferenceGenerator;
import edu.cmu.cs.stage3.alice.core.property.ObjectProperty;
import edu.cmu.cs.stage3.io.DirectoryTreeLoader;
import edu.cmu.cs.stage3.io.DirectoryTreeStorer;
import java.awt.Font;
import java.io.IOException;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class FontProperty
extends ObjectProperty {
    public FontProperty(Element owner, String name, Font defaultValue) {
        super(owner, name, defaultValue, Font.class);
    }

    public Font getFontValue() {
        return (Font)this.getValue();
    }

    @Override
    protected void decodeObject(org.w3c.dom.Element node, DirectoryTreeLoader loader, Vector referencesToBeResolved, double version) throws IOException {
        Node familyNode = node.getElementsByTagName("family").item(0);
        Node nameNode = node.getElementsByTagName("name").item(0);
        Node styleNode = node.getElementsByTagName("style").item(0);
        Node sizeNode = node.getElementsByTagName("size").item(0);
        String family = this.getNodeText(familyNode);
        String name = this.getNodeText(nameNode);
        int style = Integer.parseInt(this.getNodeText(styleNode));
        int size = Integer.parseInt(this.getNodeText(sizeNode));
        this.set(new Font(name, style, size));
    }

    @Override
    protected void encodeObject(Document document, org.w3c.dom.Element node, DirectoryTreeStorer storer, ReferenceGenerator referenceGenerator) throws IOException {
        Font f = this.getFontValue();
        org.w3c.dom.Element familyNode = document.createElement("family");
        familyNode.appendChild(this.createNodeForString(document, f.getFamily()));
        node.appendChild(familyNode);
        org.w3c.dom.Element nameNode = document.createElement("name");
        nameNode.appendChild(this.createNodeForString(document, f.getName()));
        node.appendChild(nameNode);
        org.w3c.dom.Element styleNode = document.createElement("style");
        styleNode.appendChild(this.createNodeForString(document, Integer.toString(f.getStyle())));
        node.appendChild(styleNode);
        org.w3c.dom.Element sizeNode = document.createElement("size");
        sizeNode.appendChild(this.createNodeForString(document, Integer.toString(f.getSize())));
        node.appendChild(sizeNode);
    }
}

