/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.property;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.property.ObjectArrayProperty;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;

public class ElementArrayProperty
extends ObjectArrayProperty {
    public ElementArrayProperty(Element owner, String name, Object[] defaultValue, Class valueClass) {
        super(owner, name, defaultValue, valueClass);
    }

    public Element[] getElementArrayValue() {
        return (Element[])this.getArrayValue();
    }

    private void sortByName(final boolean ignoreCase) {
        Element[] src = this.getElementArrayValue();
        Element[] dst = (Element[])Array.newInstance(this.getComponentType(), src.length);
        System.arraycopy(src, 0, dst, 0, dst.length);
        Arrays.sort(dst, new Comparator(){

            public int compare(Object o1, Object o2) {
                Element e1 = (Element)o1;
                Element e2 = (Element)o2;
                String n1 = e1.name.getStringValue();
                String n2 = e2.name.getStringValue();
                if (n1 != null) {
                    if (n2 != null) {
                        if (ignoreCase) {
                            return n1.compareTo(n2);
                        }
                        return n1.compareToIgnoreCase(n2);
                    }
                    return -1;
                }
                if (n2 != null) {
                    return 1;
                }
                return 0;
            }

            @Override
            public boolean equals(Object obj) {
                return super.equals(obj);
            }
        });
        this.set(dst);
    }

    public void sortByName() {
        this.sortByName(false);
    }

    public void sortByNameIgnoreCase() {
        this.sortByName(true);
    }
}

