/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.navigation;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.property.IntArrayProperty;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class KeyMapping
extends Element
implements KeyListener {
    public static final int NAV_DONOTHING = 0;
    public static final int NAV_MOVEFORWARD = 1;
    public static final int NAV_MOVEBACKWARD = 2;
    public static final int NAV_MOVELEFT = 4;
    public static final int NAV_MOVERIGHT = 8;
    public static final int NAV_MOVEUP = 16;
    public static final int NAV_MOVEDOWN = 32;
    public static final int NAV_TURNLEFT = 64;
    public static final int NAV_TURNRIGHT = 128;
    public static final int NAV_TURNUP = 256;
    public static final int NAV_TURNDOWN = 512;
    public static final int NAV_ROLLLEFT = 1024;
    public static final int NAV_ROLLRIGHT = 2048;
    public static final int NAV_HEADSUP = 65536;
    public static final int NAV_STRAFE_MODIFIER = -1;
    public IntArrayProperty keyFunction = new IntArrayProperty(this, "keyFunction", new int[402]);
    private boolean[] keyState = new boolean[402];
    private boolean strafing;

    public KeyMapping() {
        this.setFunction(38, 1);
        this.setFunction(40, 2);
        this.setFunction(37, 64);
        this.setFunction(39, 128);
    }

    public void setFunction(int key, int function) {
        int[] functions = this.keyFunction.getIntArrayValue();
        functions[key] = function;
        this.keyFunction.set(functions);
    }

    public int getActions() {
        int actions = 0;
        int i = 0;
        while (i < this.keyState.length) {
            if (this.keyState[i]) {
                int val = this.keyFunction.getIntArrayValue()[i];
                if (this.strafing && val == 64) {
                    val = 4;
                }
                if (this.strafing && val == 128) {
                    val = 8;
                }
                if (this.strafing && val == 256) {
                    val = 32;
                }
                if (this.strafing && val == 512) {
                    val = 16;
                }
                actions += val;
            }
            ++i;
        }
        return actions;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.keyFunction.getIntArrayValue()[keyEvent.getKeyCode()] == -1) {
            this.strafing = true;
        } else {
            this.keyState[keyEvent.getKeyCode()] = true;
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (this.keyFunction.getIntArrayValue()[keyEvent.getKeyCode()] == -1) {
            this.strafing = false;
        }
        this.keyState[keyEvent.getKeyCode()] = false;
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    public void cleanState() {
        this.keyState = new boolean[402];
        this.strafing = false;
    }

    public void printInstructions() {
        System.out.println("Keyboard Navigation Controls:");
        System.out.println("-----------------------------");
        int i = 0;
        while (i < this.keyFunction.getIntArrayValue().length) {
            if (this.keyFunction.getIntArrayValue()[i] == 1) {
                System.out.print("Move Forward: ");
            } else if (this.keyFunction.getIntArrayValue()[i] == 2) {
                System.out.print("Move Backward: ");
            } else if (this.keyFunction.getIntArrayValue()[i] == 4) {
                System.out.print("Strafe Left: ");
            } else if (this.keyFunction.getIntArrayValue()[i] == 8) {
                System.out.print("Strafe Right: ");
            } else if (this.keyFunction.getIntArrayValue()[i] == 64) {
                System.out.print("Turn Left: ");
            } else if (this.keyFunction.getIntArrayValue()[i] == 128) {
                System.out.print("Turn Right: ");
            } else if (this.keyFunction.getIntArrayValue()[i] == 256) {
                System.out.print("Tilt Up: ");
            } else if (this.keyFunction.getIntArrayValue()[i] == 512) {
                System.out.print("Tilt Down: ");
            } else if (this.keyFunction.getIntArrayValue()[i] == -1) {
                System.out.print("Strafe Modifier: ");
            }
            if (this.keyFunction.getIntArrayValue()[i] != 0) {
                System.out.println(KeyEvent.getKeyText(i));
            }
            ++i;
        }
    }
}

