/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.geometry;

import edu.cmu.cs.stage3.alice.core.util.Polynomial;
import edu.cmu.cs.stage3.alice.scenegraph.Vertex3d;
import edu.cmu.cs.stage3.math.MathUtilities;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.util.Collections;
import java.util.ListIterator;
import java.util.Vector;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.TexCoord2f;
import javax.vecmath.Tuple2d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class PolygonSegment {
    private Vector points = new Vector();
    private Vector normals = new Vector();
    private Vertex3d[] sideVertices = null;
    private int[] indices = null;

    protected Shape getShape() {
        if (this.points.isEmpty()) {
            return null;
        }
        GeneralPath gp = new GeneralPath();
        gp.moveTo((float)((Point2d)this.points.firstElement()).x, (float)((Point2d)this.points.firstElement()).y);
        ListIterator li = this.points.listIterator(1);
        while (li.hasNext()) {
            Point2d cur = (Point2d)li.next();
            gp.lineTo((float)cur.x, (float)cur.y);
        }
        gp.closePath();
        return gp;
    }

    public boolean contains(double x, double y) {
        return this.getShape().contains(x, y);
    }

    protected void addPoint(Point2d point) {
        this.points.add(point);
        this.normals.setSize(this.normals.size() + 2);
        if (this.points.size() > 1) {
            double dx = ((Point2d)this.points.lastElement()).x - ((Point2d)this.points.elementAt((int)(this.points.size() - 2))).x;
            double dy = ((Point2d)this.points.lastElement()).y - ((Point2d)this.points.elementAt((int)(this.points.size() - 2))).y;
            double len = Math.sqrt(dx * dx + dy * dy);
            Vector3d a = new Vector3d(dx / len, 0.0, dy / len);
            Vector3d b = new Vector3d(0.0, 1.0, 0.0);
            Vector3d c = MathUtilities.crossProduct(a, b);
            this.normals.setElementAt(new Vector3f(-((float)c.x), -((float)c.z), 0.0f), (this.points.size() - 2) * 2);
            this.normals.setElementAt(new Vector3f(-((float)c.x), -((float)c.z), 0.0f), (this.points.size() - 1) * 2 + 1);
        }
    }

    protected void addQuadraticSpline(Point2d cp1, Point2d cp2, Point2d offset, int numSegs) {
        if (this.points.isEmpty()) {
            return;
        }
        this.normals.setSize(this.normals.size() + 2 * numSegs);
        Point2d cp0 = new Point2d(-((Point2d)this.points.lastElement()).x + offset.x, -((Point2d)this.points.lastElement()).y + offset.y);
        Point3d[] newPositions = new Point3d[numSegs + 1];
        Vector3d[] newNormals = new Vector3d[numSegs + 1];
        Polynomial.evaluateBezierQuadratic(cp0, cp1, cp2, 0.0, newPositions, newNormals);
        this.normals.setElementAt(new Vector3f(newNormals[0]), (this.points.size() - 1) * 2);
        int i = 1;
        while (i <= numSegs) {
            this.points.add(new Point2d(offset.x - newPositions[i].x, offset.y - newPositions[i].y));
            this.normals.setElementAt(new Vector3f(newNormals[i]), (this.points.size() - 1) * 2);
            this.normals.setElementAt(new Vector3f(newNormals[i]), (this.points.size() - 1) * 2 + 1);
            ++i;
        }
    }

    protected void close() {
        if (this.points.isEmpty()) {
            return;
        }
        if (this.points.size() > 1 && ((Point2d)this.points.lastElement()).equals((Tuple2d)((Point2d)this.points.firstElement()))) {
            this.points.setSize(this.points.size() - 1);
            this.normals.setSize(this.normals.size() - 2);
        }
        if (this.points.size() >= 3) {
            double dx = ((Point2d)this.points.firstElement()).x - ((Point2d)this.points.lastElement()).x;
            double dy = ((Point2d)this.points.firstElement()).y - ((Point2d)this.points.lastElement()).y;
            double len = Math.sqrt(dx * dx + dy * dy);
            Vector3d a = new Vector3d(dx / len, 0.0, dy / len);
            Vector3d b = new Vector3d(0.0, 1.0, 0.0);
            Vector3d c = MathUtilities.crossProduct(a, b);
            this.normals.setElementAt(new Vector3f(-((float)c.x), -((float)c.z), 0.0f), 1);
            this.normals.setElementAt(new Vector3f(-((float)c.x), -((float)c.z), 0.0f), (this.points.size() - 1) * 2);
        } else {
            this.points.clear();
            this.normals.clear();
        }
    }

    public boolean parsePathIterator(PathIterator pi, Point2d offset, int curvature) {
        double[] coords = new double[6];
        int type = -1;
        while (!pi.isDone()) {
            type = pi.currentSegment(coords);
            switch (type) {
                case 0: {
                    if (!this.points.isEmpty()) {
                        this.close();
                        return false;
                    }
                    this.addPoint(new Point2d(offset.x - coords[0], offset.y - coords[1]));
                    break;
                }
                case 1: {
                    this.addPoint(new Point2d(offset.x - coords[0], offset.y - coords[1]));
                    break;
                }
                case 2: {
                    this.addQuadraticSpline(new Point2d(coords[0], coords[1]), new Point2d(coords[2], coords[3]), offset, curvature);
                    break;
                }
                case 3: {
                    this.addPoint(new Point2d(offset.x - coords[0], offset.y - coords[1]));
                    this.addPoint(new Point2d(offset.x - coords[2], offset.y - coords[3]));
                    this.addPoint(new Point2d(offset.x - coords[4], offset.y - coords[5]));
                    break;
                }
                case 4: {
                    this.close();
                    return true;
                }
            }
            pi.next();
        }
        this.close();
        return true;
    }

    public boolean isNull() {
        return this.points.isEmpty();
    }

    public Vector points() {
        return this.points;
    }

    public void reverse() {
        Collections.reverse(this.points);
        Collections.reverse(this.normals);
    }

    public void genSideStrips(double extz) {
        this.sideVertices = null;
        this.indices = null;
        if (this.points.isEmpty()) {
            return;
        }
        this.sideVertices = new Vertex3d[this.points.size() * 4];
        this.indices = new int[this.points.size() * 6];
        ListIterator li = this.points.listIterator();
        int i = 0;
        while (li.hasNext()) {
            Point2d point = (Point2d)li.next();
            Point3d pos = new Point3d(point.x, point.y, -extz / 2.0);
            this.sideVertices[i * 2] = new Vertex3d(pos, new Vector3d((Vector3f)this.normals.elementAt(i * 2)), null, null, new TexCoord2f());
            this.sideVertices[i * 2 + 1] = new Vertex3d(pos, new Vector3d((Vector3f)this.normals.elementAt(i * 2 + 1)), null, null, new TexCoord2f());
            pos = new Point3d(point.x, point.y, extz / 2.0);
            this.sideVertices[this.points.size() * 2 + i * 2] = new Vertex3d(pos, new Vector3d((Vector3f)this.normals.elementAt(i * 2)), null, null, new TexCoord2f());
            this.sideVertices[this.points.size() * 2 + i * 2 + 1] = new Vertex3d(pos, new Vector3d((Vector3f)this.normals.elementAt(i * 2 + 1)), null, null, new TexCoord2f());
            ++i;
        }
        i = 0;
        while (i < this.points.size() - 1) {
            this.indices[i * 6] = 2 * i;
            this.indices[i * 6 + 1] = 2 * i + 3;
            this.indices[i * 6 + 2] = 2 * i + 3 + this.points.size() * 2;
            this.indices[i * 6 + 3] = 2 * i;
            this.indices[i * 6 + 4] = 2 * i + 3 + this.points.size() * 2;
            this.indices[i * 6 + 5] = 2 * i + this.points.size() * 2;
            ++i;
        }
        this.indices[(this.points.size() - 1) * 6] = 2 * (this.points.size() - 1);
        this.indices[(this.points.size() - 1) * 6 + 1] = 1;
        this.indices[(this.points.size() - 1) * 6 + 2] = 1 + this.points.size() * 2;
        this.indices[(this.points.size() - 1) * 6 + 3] = 2 * (this.points.size() - 1);
        this.indices[(this.points.size() - 1) * 6 + 4] = 1 + this.points.size() * 2;
        this.indices[(this.points.size() - 1) * 6 + 5] = 2 * (this.points.size() - 1) + this.points.size() * 2;
    }

    public Vertex3d[] getSideVertices() {
        return this.sideVertices;
    }

    public int[] getIndices() {
        return this.indices;
    }
}

