/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.geometry;

import edu.cmu.cs.stage3.alice.core.geometry.PolygonSegment;
import edu.cmu.cs.stage3.alice.scenegraph.Vertex3d;
import edu.cmu.cs.stage3.alice.scenegraph.util.Triangle;
import edu.cmu.cs.stage3.alice.scenegraph.util.Triangulator;
import java.awt.geom.PathIterator;
import java.util.ListIterator;
import java.util.Vector;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.TexCoord2f;
import javax.vecmath.Vector3d;

public class Polygon {
    private Vector segments = new Vector();
    private Vertex3d[] triVertices = null;
    private int[] indices = null;

    public boolean parsePathIterator(PathIterator pi, Point2d offset, int curvature) {
        double[] coords = new double[6];
        int type = -1;
        boolean advance = true;
        while (!pi.isDone()) {
            type = pi.currentSegment(coords);
            switch (type) {
                case 0: {
                    if (!this.segments.isEmpty() && !((PolygonSegment)this.segments.firstElement()).contains(offset.x - coords[0], offset.y - coords[1])) {
                        return false;
                    }
                    PolygonSegment ps = new PolygonSegment();
                    advance = ps.parsePathIterator(pi, offset, curvature);
                    if (ps.isNull()) break;
                    this.segments.add(ps);
                }
            }
            if (!advance || pi.isDone()) continue;
            pi.next();
        }
        return true;
    }

    public boolean isNull() {
        return this.segments.isEmpty();
    }

    public void triangulate(double extz) {
        this.triVertices = null;
        this.indices = null;
        if (this.segments.isEmpty()) {
            return;
        }
        Triangulator triangulator = new Triangulator();
        ListIterator li = this.segments.listIterator();
        while (li.hasNext()) {
            triangulator.addContour(((PolygonSegment)li.next()).points());
        }
        triangulator.triangulate();
        this.indices = new int[triangulator.triangles.size() * 3 * 2];
        this.triVertices = new Vertex3d[triangulator.points.size() * 2];
        Vector3d norm1 = new Vector3d(0.0, 0.0, -1.0);
        Vector3d norm2 = new Vector3d(0.0, 0.0, 1.0);
        li = triangulator.points.listIterator();
        int i = 0;
        while (li.hasNext()) {
            Point2d curPoint = (Point2d)li.next();
            this.triVertices[i] = new Vertex3d(new Point3d(curPoint.x, curPoint.y, -extz / 2.0), norm1, null, null, new TexCoord2f());
            this.triVertices[triangulator.points.size() + i] = new Vertex3d(new Point3d(curPoint.x, curPoint.y, extz / 2.0), norm2, null, null, new TexCoord2f());
            ++i;
        }
        li = triangulator.triangles.listIterator();
        i = 0;
        while (li.hasNext()) {
            Triangle curTri = (Triangle)li.next();
            this.indices[i * 3] = triangulator.indexOfPoint(curTri.vertices[2]);
            this.indices[i * 3 + 1] = triangulator.indexOfPoint(curTri.vertices[1]);
            this.indices[i * 3 + 2] = triangulator.indexOfPoint(curTri.vertices[0]);
            this.indices[triangulator.triangles.size() * 3 + i * 3] = triangulator.points.size() + this.indices[i * 3 + 2];
            this.indices[triangulator.triangles.size() * 3 + i * 3 + 1] = triangulator.points.size() + this.indices[i * 3 + 1];
            this.indices[triangulator.triangles.size() * 3 + i * 3 + 2] = triangulator.points.size() + this.indices[i * 3];
            ++i;
        }
        this.genSideStrips(extz);
        li = this.segments.listIterator();
        while (li.hasNext()) {
            PolygonSegment seg = (PolygonSegment)li.next();
            Vertex3d[] newVertices = new Vertex3d[this.triVertices.length + seg.getSideVertices().length];
            System.arraycopy(this.triVertices, 0, newVertices, 0, this.triVertices.length);
            int offset = this.triVertices.length;
            System.arraycopy(seg.getSideVertices(), 0, newVertices, this.triVertices.length, seg.getSideVertices().length);
            this.triVertices = newVertices;
            int[] newIndices = new int[this.indices.length + seg.getIndices().length];
            System.arraycopy(this.indices, 0, newIndices, 0, this.indices.length);
            int j = 0;
            while (j < seg.getIndices().length) {
                newIndices[this.indices.length + j] = seg.getIndices()[j] + offset;
                ++j;
            }
            this.indices = newIndices;
        }
    }

    protected void genSideStrips(double extz) {
        if (this.segments.isEmpty()) {
            return;
        }
        ((PolygonSegment)this.segments.firstElement()).genSideStrips(extz);
        ListIterator li = this.segments.listIterator();
        while (li.hasNext()) {
            ((PolygonSegment)li.next()).genSideStrips(extz);
        }
    }

    public Vertex3d[] getVertices() {
        return this.triVertices;
    }

    public int[] getIndices() {
        return this.indices;
    }
}

