/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.decorator;

import edu.cmu.cs.stage3.alice.core.Camera;
import edu.cmu.cs.stage3.alice.core.Decorator;
import edu.cmu.cs.stage3.alice.core.ReferenceFrame;
import edu.cmu.cs.stage3.alice.scenegraph.IndexedTriangleArray;
import edu.cmu.cs.stage3.alice.scenegraph.LineArray;
import edu.cmu.cs.stage3.alice.scenegraph.Vertex3d;
import edu.cmu.cs.stage3.alice.scenegraph.Visual;

public abstract class ViewVolumeDecorator
extends Decorator {
    private Visual m_sgVisualLines = null;
    private LineArray m_sgLineArray = null;
    private Visual m_sgVisualFaces = null;
    private IndexedTriangleArray m_sgITA = null;

    @Override
    protected ReferenceFrame getReferenceFrame() {
        return this.getCamera();
    }

    protected abstract Camera getCamera();

    @Override
    public void internalRelease(int pass) {
        switch (pass) {
            case 1: {
                if (this.m_sgVisualLines != null) {
                    this.m_sgVisualLines.setFrontFacingAppearance(null);
                    this.m_sgVisualLines.setGeometry(null);
                }
                if (this.m_sgVisualFaces == null) break;
                this.m_sgVisualFaces.setFrontFacingAppearance(null);
                this.m_sgVisualFaces.setGeometry(null);
                break;
            }
            case 2: {
                if (this.m_sgVisualLines != null) {
                    this.m_sgVisualLines.release();
                    this.m_sgVisualLines = null;
                }
                if (this.m_sgLineArray != null) {
                    this.m_sgLineArray.release();
                    this.m_sgLineArray = null;
                }
                if (this.m_sgVisualFaces != null) {
                    this.m_sgVisualFaces.release();
                    this.m_sgVisualFaces = null;
                }
                if (this.m_sgITA == null) break;
                this.m_sgITA.release();
                this.m_sgITA = null;
            }
        }
        super.internalRelease(pass);
    }

    protected abstract double[] getXYNearAndXYFar(double var1, double var3);

    @Override
    protected void update() {
        super.update();
        boolean requiresVerticesToBeUpdated = this.isDirty();
        if (this.m_sgLineArray == null) {
            this.m_sgLineArray = new LineArray();
            requiresVerticesToBeUpdated = true;
        }
        if (this.m_sgITA == null) {
            int[] nArray = new int[72];
            nArray[1] = 1;
            nArray[2] = 2;
            nArray[3] = 2;
            nArray[4] = 3;
            nArray[6] = 5;
            nArray[7] = 6;
            nArray[8] = 2;
            nArray[9] = 2;
            nArray[10] = 1;
            nArray[11] = 5;
            nArray[12] = 6;
            nArray[13] = 7;
            nArray[14] = 3;
            nArray[15] = 3;
            nArray[16] = 2;
            nArray[17] = 6;
            nArray[18] = 7;
            nArray[19] = 4;
            nArray[22] = 3;
            nArray[23] = 7;
            nArray[24] = 4;
            nArray[25] = 5;
            nArray[26] = 1;
            nArray[27] = 1;
            nArray[29] = 4;
            nArray[30] = 7;
            nArray[31] = 6;
            nArray[32] = 5;
            nArray[33] = 5;
            nArray[34] = 4;
            nArray[35] = 7;
            nArray[36] = 3;
            nArray[37] = 2;
            nArray[38] = 1;
            nArray[39] = 1;
            nArray[41] = 3;
            nArray[42] = 1;
            nArray[43] = 2;
            nArray[44] = 6;
            nArray[45] = 6;
            nArray[46] = 5;
            nArray[47] = 1;
            nArray[48] = 2;
            nArray[49] = 3;
            nArray[50] = 7;
            nArray[51] = 7;
            nArray[52] = 6;
            nArray[53] = 2;
            nArray[54] = 3;
            nArray[56] = 4;
            nArray[57] = 4;
            nArray[58] = 7;
            nArray[59] = 3;
            nArray[61] = 1;
            nArray[62] = 5;
            nArray[63] = 5;
            nArray[64] = 4;
            nArray[66] = 4;
            nArray[67] = 5;
            nArray[68] = 6;
            nArray[69] = 6;
            nArray[70] = 7;
            nArray[71] = 4;
            int[] indices = nArray;
            this.m_sgITA = new IndexedTriangleArray();
            this.m_sgITA.setIndices(indices);
            requiresVerticesToBeUpdated = true;
        }
        if (this.m_sgVisualLines == null) {
            this.m_sgVisualLines = new Visual();
            this.m_sgVisualLines.setIsShowing(false);
            this.m_sgVisualLines.setGeometry(this.m_sgLineArray);
            this.m_sgVisualLines.setParent(this.getReferenceFrame().getSceneGraphContainer());
        }
        if (this.m_sgVisualFaces == null) {
            this.m_sgVisualFaces = new Visual();
            this.m_sgVisualFaces.setIsShowing(false);
            this.m_sgVisualFaces.setGeometry(this.m_sgITA);
            this.m_sgVisualFaces.setParent(this.getReferenceFrame().getSceneGraphContainer());
        }
        if (requiresVerticesToBeUpdated) {
            Vertex3d[] vertices = new Vertex3d[24];
            double zNear = this.getCamera().nearClippingPlaneDistance.doubleValue();
            double zFar = this.getCamera().farClippingPlaneDistance.doubleValue();
            double[] array = this.getXYNearAndXYFar(zNear, zFar);
            double xNear = array[0];
            double yNear = array[1];
            double xFar = array[2];
            double yFar = array[3];
            Vertex3d[] vs = new Vertex3d[]{Vertex3d.createXYZIJKUV(xNear, yNear, zNear, 0.0, 1.0, 0.0, 0.0f, 0.0f), Vertex3d.createXYZIJKUV(-xNear, yNear, zNear, 0.0, 1.0, 0.0, 0.0f, 0.0f), Vertex3d.createXYZIJKUV(-xNear, -yNear, zNear, 0.0, 1.0, 0.0, 0.0f, 0.0f), Vertex3d.createXYZIJKUV(xNear, -yNear, zNear, 0.0, 1.0, 0.0, 0.0f, 0.0f), Vertex3d.createXYZIJKUV(xFar, yFar, zFar, 0.0, 1.0, 0.0, 0.0f, 0.0f), Vertex3d.createXYZIJKUV(-xFar, yFar, zFar, 0.0, 1.0, 0.0, 0.0f, 0.0f), Vertex3d.createXYZIJKUV(-xFar, -yFar, zFar, 0.0, 1.0, 0.0, 0.0f, 0.0f), Vertex3d.createXYZIJKUV(xFar, -yFar, zFar, 0.0, 1.0, 0.0, 0.0f, 0.0f)};
            int bottom = 0;
            int top = 8;
            int sides = 16;
            int lcv = 0;
            while (lcv < 4) {
                vertices[bottom++] = vs[lcv];
                vertices[bottom++] = vs[(lcv + 1) % 4];
                vertices[top++] = vs[4 + lcv];
                vertices[top++] = vs[4 + (lcv + 1) % 4];
                vertices[sides++] = vs[lcv];
                vertices[sides++] = vs[lcv + 4];
                ++lcv;
            }
            this.m_sgLineArray.setVertices(vertices);
            this.m_sgITA.setVertices(vs);
        }
        this.setIsDirty(false);
    }

    @Override
    protected void showRightNow() {
        if (this.m_sgVisualLines != null) {
            this.m_sgVisualLines.setIsShowing(true);
        }
        if (this.m_sgVisualFaces != null) {
            this.m_sgVisualFaces.setIsShowing(true);
        }
    }

    @Override
    protected void hideRightNow() {
        if (this.m_sgVisualLines != null) {
            this.m_sgVisualLines.setIsShowing(false);
        }
        if (this.m_sgVisualFaces != null) {
            this.m_sgVisualFaces.setIsShowing(false);
        }
    }
}

