/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.decorator;

import edu.cmu.cs.stage3.alice.core.Camera;
import edu.cmu.cs.stage3.alice.core.camera.SymmetricPerspectiveCamera;
import edu.cmu.cs.stage3.alice.core.decorator.ViewVolumeDecorator;

public class SymmetricPerspectiveViewVolumeDecorator
extends ViewVolumeDecorator {
    private SymmetricPerspectiveCamera m_symmetricPerspectiveCamera = null;

    @Override
    protected Camera getCamera() {
        return this.getSymmetricPerspectiveCamera();
    }

    public SymmetricPerspectiveCamera getSymmetricPerspectiveCamera() {
        return this.m_symmetricPerspectiveCamera;
    }

    public void setSymmetricPerspectiveCamera(SymmetricPerspectiveCamera symmetricPerspectiveCamera) {
        if (symmetricPerspectiveCamera != this.m_symmetricPerspectiveCamera) {
            this.m_symmetricPerspectiveCamera = symmetricPerspectiveCamera;
            this.markDirty();
            this.updateIfShowing();
        }
    }

    @Override
    protected double[] getXYNearAndXYFar(double zNear, double zFar) {
        double angle = this.m_symmetricPerspectiveCamera.verticalViewingAngle.doubleValue(0.5);
        double aspect = 1.3333333333333333;
        double yNear = zNear * Math.tan(angle);
        double yFar = zFar * Math.tan(angle);
        double xNear = aspect * yNear;
        double xFar = aspect * yFar;
        double[] r = new double[]{xNear, yNear, xFar, yFar};
        return r;
    }
}

