/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.decorator;

import edu.cmu.cs.stage3.alice.core.Decorator;
import edu.cmu.cs.stage3.alice.core.ReferenceFrame;
import edu.cmu.cs.stage3.alice.core.Transformable;
import edu.cmu.cs.stage3.alice.scenegraph.Color;
import edu.cmu.cs.stage3.alice.scenegraph.LineArray;
import edu.cmu.cs.stage3.alice.scenegraph.Vertex3d;
import edu.cmu.cs.stage3.math.Box;
import edu.cmu.cs.stage3.math.MathUtilities;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

public class PivotDecorator
extends Decorator {
    private LineArray m_sgLineArray = null;
    private Transformable m_transformable = null;
    private Box m_overrideBoundingBox = null;

    @Override
    protected ReferenceFrame getReferenceFrame() {
        return this.getTransformable();
    }

    public Transformable getTransformable() {
        return this.m_transformable;
    }

    public void setTransformable(Transformable transformable) {
        if (transformable != this.m_transformable) {
            this.m_transformable = transformable;
            this.markDirty();
            this.updateIfShowing();
        }
    }

    public Box getOverrideBoundingBox() {
        return this.m_overrideBoundingBox;
    }

    public void setOverrideBoundingBox(Box overrideBoundingBox) {
        this.m_overrideBoundingBox = overrideBoundingBox;
        this.markDirty();
    }

    @Override
    public void internalRelease(int pass) {
        switch (pass) {
            case 2: {
                if (this.m_sgLineArray == null) break;
                this.m_sgLineArray.release();
                this.m_sgLineArray = null;
            }
        }
        super.internalRelease(pass);
    }

    @Override
    protected void update() {
        super.update();
        Box box = this.m_overrideBoundingBox == null ? this.m_transformable.getBoundingBox() : this.m_overrideBoundingBox;
        if (box == null || box.getMinimum() == null || box.getMaximum() == null) {
            return;
        }
        boolean requiresVerticesToBeUpdated = this.isDirty();
        if (this.m_sgLineArray == null) {
            this.m_sgLineArray = new LineArray();
            this.m_sgVisual.setGeometry(this.m_sgLineArray);
            this.m_sgLineArray.setBonus(this.getTransformable());
            requiresVerticesToBeUpdated = true;
        }
        if (requiresVerticesToBeUpdated) {
            Vector3d min = box.getMinimum();
            Vector3d max = box.getMaximum();
            double distanceAcross = MathUtilities.subtract(max, min).length();
            double delta = distanceAcross * 0.1;
            Color xColor = Color.RED;
            Color yColor = Color.GREEN;
            Color zColor = Color.BLUE;
            Vertex3d[] vertices = new Vertex3d[]{new Vertex3d(new Point3d(0.0, 0.0, 0.0), null, xColor, null, null), new Vertex3d(new Point3d(max.x + delta, 0.0, 0.0), null, xColor, null, null), new Vertex3d(new Point3d(0.0, 0.0, 0.0), null, yColor, null, null), new Vertex3d(new Point3d(0.0, max.y + delta, 0.0), null, yColor, null, null), new Vertex3d(new Point3d(0.0, 0.0, 0.0), null, zColor, null, null), new Vertex3d(new Point3d(0.0, 0.0, max.z + delta), null, zColor, null, null)};
            this.m_sgLineArray.setVertices(vertices);
        }
        this.setIsDirty(false);
    }
}

