/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.decorator;

import edu.cmu.cs.stage3.alice.core.Camera;
import edu.cmu.cs.stage3.alice.core.camera.OrthographicCamera;
import edu.cmu.cs.stage3.alice.core.decorator.ViewVolumeDecorator;

public class OrthographicViewVolumeDecorator
extends ViewVolumeDecorator {
    private OrthographicCamera m_orthographicCamera = null;

    @Override
    protected Camera getCamera() {
        return this.getOrthographicCamera();
    }

    public OrthographicCamera getOrthographicCamera() {
        return this.m_orthographicCamera;
    }

    public void setOrthographicCamera(OrthographicCamera orthographicCamera) {
        if (orthographicCamera != this.m_orthographicCamera) {
            this.m_orthographicCamera = orthographicCamera;
            this.markDirty();
            this.updateIfShowing();
        }
    }

    @Override
    protected double[] getXYNearAndXYFar(double zNear, double zFar) {
        double angle = 0.5;
        double aspect = 1.3333333333333333;
        double yNear = zNear * Math.tan(angle);
        double yFar = zFar * Math.tan(angle);
        double xNear = aspect * yNear;
        double xFar = aspect * yFar;
        double[] r = new double[]{xNear, yNear, xFar, yFar};
        return r;
    }
}

