/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.decorator;

import edu.cmu.cs.stage3.alice.core.Decorator;
import edu.cmu.cs.stage3.alice.core.ReferenceFrame;
import edu.cmu.cs.stage3.alice.scenegraph.Color;
import edu.cmu.cs.stage3.alice.scenegraph.LineArray;
import edu.cmu.cs.stage3.alice.scenegraph.Vertex3d;
import edu.cmu.cs.stage3.math.Box;
import edu.cmu.cs.stage3.math.MathUtilities;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class AxesDecorator
extends Decorator {
    private LineArray m_sgLineArray = null;
    private ReferenceFrame m_referenceFrame = null;
    private double m_scale = 1.0;

    public double getScale() {
        return this.m_scale;
    }

    public void setScale(double scale) {
        this.m_scale = scale;
        this.markDirty();
    }

    @Override
    public ReferenceFrame getReferenceFrame() {
        return this.m_referenceFrame;
    }

    public void setReferenceFrame(ReferenceFrame referenceFrame) {
        if (referenceFrame != this.m_referenceFrame) {
            this.m_referenceFrame = referenceFrame;
            this.markDirty();
            this.updateIfShowing();
        }
    }

    @Override
    public void internalRelease(int pass) {
        switch (pass) {
            case 2: {
                if (this.m_sgLineArray == null) break;
                this.m_sgLineArray.release();
                this.m_sgLineArray = null;
            }
        }
        super.internalRelease(pass);
    }

    @Override
    protected void update() {
        super.update();
        Box box = this.m_referenceFrame.getBoundingBox();
        if (box == null || box.getMinimum() == null || box.getMaximum() == null) {
            return;
        }
        boolean requiresVerticesToBeUpdated = this.isDirty();
        if (this.m_sgLineArray == null) {
            this.m_sgLineArray = new LineArray();
            this.m_sgVisual.setGeometry(this.m_sgLineArray);
            this.m_sgLineArray.setBonus(this.getReferenceFrame());
            requiresVerticesToBeUpdated = true;
        }
        if (requiresVerticesToBeUpdated) {
            Color color = Color.YELLOW;
            Vertex3d[] vertices = new Vertex3d[6];
            Vector3d min = box.getMinimum();
            Vector3d max = box.getMaximum();
            Vector3d center = MathUtilities.add(min, max);
            center.scale(0.5);
            if (this.m_scale != 0.0) {
                Vector3d dmin = MathUtilities.subtract(min, center);
                Vector3d dmax = MathUtilities.subtract(max, center);
                dmin.scale(this.m_scale);
                dmax.scale(this.m_scale);
                min.add((Tuple3d)dmin);
                max.add((Tuple3d)dmax);
            }
            vertices[0] = new Vertex3d(new Point3d(min.x, center.y, center.z), null, Color.RED, null, null);
            vertices[1] = new Vertex3d(new Point3d(max.x, center.y, center.z), null, Color.RED, null, null);
            vertices[2] = new Vertex3d(new Point3d(center.x, min.y, center.z), null, Color.GREEN, null, null);
            vertices[3] = new Vertex3d(new Point3d(center.x, max.y, center.z), null, Color.GREEN, null, null);
            vertices[4] = new Vertex3d(new Point3d(center.x, center.y, min.z), null, Color.BLUE, null, null);
            vertices[5] = new Vertex3d(new Point3d(center.x, center.y, max.z), null, Color.BLUE, null, null);
            this.m_sgLineArray.setVertices(vertices);
        }
        this.setIsDirty(false);
    }
}

