/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.criterion;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.util.Criterion;
import java.lang.reflect.Constructor;

public class ElementNameContainsCriterion
implements Criterion {
    private String m_contains;
    private boolean m_ignoreCase;

    public ElementNameContainsCriterion(String contains) {
        this(contains, true);
    }

    public ElementNameContainsCriterion(String contains, boolean ignoreCase) {
        this.m_contains = contains;
        this.m_ignoreCase = ignoreCase;
    }

    public String getContains() {
        return this.m_contains;
    }

    public boolean getIgnoreCase() {
        return this.m_ignoreCase;
    }

    @Override
    public boolean accept(Object o) {
        if (o instanceof Element) {
            String name = ((Element)o).name.getStringValue();
            if (this.m_contains == null) {
                return name == null;
            }
            if (name == null) {
                return false;
            }
            if (this.m_ignoreCase) {
                return name.toLowerCase().indexOf(this.m_contains.toLowerCase()) != -1;
            }
            return name.indexOf(this.m_contains) != -1;
        }
        return false;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.m_contains + "]";
    }

    protected static ElementNameContainsCriterion valueOf(String s, Class cls) {
        String beginMarker = String.valueOf(cls.getName()) + "[";
        String endMarker = "]";
        int begin = s.indexOf(beginMarker) + beginMarker.length();
        int end = s.lastIndexOf(endMarker);
        try {
            Class[] types = new Class[]{String.class};
            Object[] values = new Object[]{s.substring(begin, end)};
            Constructor constructor = cls.getConstructor(types);
            return (ElementNameContainsCriterion)constructor.newInstance(values);
        }
        catch (Throwable t) {
            throw new RuntimeException();
        }
    }

    public static ElementNameContainsCriterion valueOf(String s) {
        return ElementNameContainsCriterion.valueOf(s, ElementNameContainsCriterion.class);
    }
}

