/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.clock;

import edu.cmu.cs.stage3.alice.core.Clock;
import edu.cmu.cs.stage3.alice.core.World;

public class DefaultClock
implements Clock {
    private World m_world;
    private double m_speed = 1.0;
    private double m_time;
    private long m_whenPrev;
    private int m_pauseCount;

    @Override
    public World getWorld() {
        return this.m_world;
    }

    @Override
    public void setWorld(World world) {
        this.m_world = world;
    }

    public double getSpeed() {
        return this.m_speed;
    }

    public void setSpeed(double speed) {
        this.m_speed = speed;
    }

    @Override
    public void start() {
        this.m_pauseCount = 0;
        this.m_whenPrev = System.currentTimeMillis();
        if (this.m_world != null) {
            this.m_world.start();
        }
    }

    @Override
    public void stop() {
        this.m_pauseCount = 0;
        this.m_whenPrev = -1L;
        if (this.m_world != null) {
            this.m_world.stop();
        }
    }

    @Override
    public void pause() {
        ++this.m_pauseCount;
    }

    @Override
    public void resume() {
        --this.m_pauseCount;
        if (this.m_pauseCount == 0) {
            this.m_whenPrev = System.currentTimeMillis();
        }
    }

    private void updateTime() {
        long whenCurr = System.currentTimeMillis();
        long whenDelta = whenCurr - this.m_whenPrev;
        if (whenDelta > 0L) {
            double dt = (double)whenDelta * 0.001;
            dt *= this.m_speed;
            if (this.m_world != null) {
                dt *= this.m_world.speedMultiplier.doubleValue();
            }
            this.m_time += dt;
        }
        this.m_whenPrev = whenCurr;
    }

    @Override
    public double getTime() {
        return this.m_time;
    }

    @Override
    public double getTimeElapsed() {
        return this.getTime();
    }

    public boolean isPaused() {
        return this.m_pauseCount == 0;
    }

    @Override
    public void schedule() {
        if (this.m_pauseCount == 0 && this.m_world != null) {
            this.updateTime();
            this.m_world.schedule();
        }
    }
}

