/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.bubble;

import edu.cmu.cs.stage3.alice.core.bubble.Bubble;
import edu.cmu.cs.stage3.alice.core.bubble.SubText;
import edu.cmu.cs.stage3.alice.scenegraph.Camera;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.RenderTarget;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.Rectangle2D;

public class TitleBubble
extends Bubble {
    private Rectangle actualViewport = null;

    @Override
    public void calculateOrigin(RenderTarget rt) {
    }

    @Override
    public void calculateBounds(RenderTarget rt) {
        Camera[] sgCameras = rt.getCameras();
        if (sgCameras.length > 0) {
            Camera sgCamera = sgCameras[0];
            this.actualViewport = rt.getActualViewport(sgCamera);
            Font font = this.getFont();
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
            double charCnt = this.actualViewport.getWidth() / (double)fontMetrics.charWidth('W');
            this.setCharactersPerLine((int)charCnt * 2);
        }
        super.calculateBounds(rt);
        Rectangle2D totalBound = this.getTotalBound();
        this.setPixelOffset(new Point((int)this.actualViewport.getX() + (int)(this.actualViewport.getWidth() / 2.0 - totalBound.getWidth() / 2.0), (int)this.actualViewport.getY() + (int)(this.actualViewport.getHeight() / 2.0 - totalBound.getHeight() / 2.0)));
    }

    @Override
    protected void paintBackground(Graphics g) {
        Point origin = this.getOrigin();
        int x = this.actualViewport.x;
        int y = this.actualViewport.y;
        int width = this.actualViewport.width;
        int height = this.actualViewport.height;
        g.setColor(this.getBackgroundColor());
        g.fillRoundRect(x, y, width, height, 5, 5);
    }

    @Override
    protected void paint(Graphics g) {
        if (this.isShowing()) {
            this.paintBackground(g);
            if (this.getText() != null) {
                if (this.getFont() != null) {
                    g.setFont(this.getFont());
                }
                g.setColor(this.getForegroundColor());
                if (this.m_subTexts.size() > 0) {
                    SubText subText0 = (SubText)this.m_subTexts.elementAt(0);
                    int offsetX = this.m_pixelOffset.x;
                    int offsetY = this.m_pixelOffset.y - (int)subText0.getBound().getY();
                    int i = 0;
                    while (i < this.m_subTexts.size()) {
                        SubText subTextI = (SubText)this.m_subTexts.elementAt(i);
                        Rectangle2D boundI = subTextI.getBound();
                        int x = this.actualViewport.x + this.actualViewport.width / 2 - (int)(boundI.getWidth() * 0.85 / 2.0);
                        int y = (int)((double)(this.actualViewport.y + offsetY) + boundI.getY());
                        g.drawString(subTextI.getText(), x, y);
                        ++i;
                    }
                }
            }
        }
    }
}

