/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.bubble;

import edu.cmu.cs.stage3.alice.core.bubble.Bubble;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.geom.Rectangle2D;

public class ThoughtBubble
extends Bubble {
    private void paintOval(Graphics g, int centerX, int centerY, int width, int height) {
        int x = centerX - width / 2;
        int y = centerY - width / 2;
        g.setColor(this.getBackgroundColor());
        g.fillOval(x, y, width, height);
        g.setColor(Color.black);
        g.drawOval(x, y, width, height);
    }

    @Override
    protected void paintBackground(Graphics g) {
        Rectangle2D totalBound = this.getTotalBound();
        Point origin = this.getOrigin();
        Point pixelOffset = this.getPixelOffset();
        if (totalBound != null) {
            int x = (int)(totalBound.getX() + (double)pixelOffset.x - 10.0);
            int y = (int)(totalBound.getY() + (double)pixelOffset.y - 10.0);
            int width = (int)totalBound.getWidth() + 10 + 10;
            int height = (int)totalBound.getHeight() + 10 + 10;
            g.setColor(this.getBackgroundColor());
            g.fillRoundRect(x, y, width, height, 20, 20);
            g.setColor(Color.black);
            g.drawRoundRect(x, y, width, height, 20, 20);
            Point connect = new Point(x + (int)((totalBound.getWidth() + 10.0 + 10.0) * 0.33), y);
            if (origin.y > y) {
                connect.translate(0, height + 6);
            }
            width = 32;
            height = 24;
            this.paintOval(g, connect.x, connect.y, width, height);
            this.paintOval(g, (connect.x + origin.x) / 2, (connect.y + origin.y) / 2, width -= 6, height -= 6);
            this.paintOval(g, origin.x, origin.y, width -= 6, height -= 6);
        }
    }
}

