/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.bubble;

import edu.cmu.cs.stage3.alice.core.bubble.Bubble;
import edu.cmu.cs.stage3.alice.scenegraph.Camera;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.RenderTarget;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.event.RenderTargetEvent;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.event.RenderTargetListener;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.Vector;

public class BubbleManager
implements RenderTargetListener {
    private Bubble[] m_bubbles;
    private RenderTarget m_renderTarget;

    public void setBubbles(Bubble[] bubbles) {
        this.m_bubbles = bubbles;
        if (this.m_renderTarget != null) {
            this.m_renderTarget.markDirty();
        }
    }

    private boolean layoutBubbles(RenderTarget rt) {
        Camera[] sgCameras;
        boolean isPaintRequired = false;
        Vector<Rectangle2D.Double> rects = new Vector<Rectangle2D.Double>();
        int i = 0;
        while (i < this.m_bubbles.length) {
            Bubble bubbleI = this.m_bubbles[i];
            if (bubbleI.isShowing()) {
                Rectangle2D rect;
                bubbleI.calculateBounds(rt);
                bubbleI.calculateOrigin(rt);
                Point pixelOffset = bubbleI.getPixelOffset();
                if (pixelOffset != null && (rect = bubbleI.getTotalBound()) != null) {
                    rects.addElement(new Rectangle2D.Double((double)pixelOffset.x + rect.getX(), (double)pixelOffset.y + rect.getY(), rect.getWidth(), rect.getHeight()));
                }
                isPaintRequired = true;
            }
            ++i;
        }
        if (isPaintRequired && (sgCameras = rt.getCameras()).length > 0) {
            Camera sgCamera = sgCameras[0];
            Rectangle actualViewport = rt.getActualViewport(sgCamera);
            int i2 = 0;
            while (i2 < this.m_bubbles.length) {
                Bubble bubbleI = this.m_bubbles[i2];
                if (bubbleI.isShowing()) {
                    Point pixelOffset = bubbleI.getPixelOffset();
                    Point origin = bubbleI.getOrigin();
                    double half = origin.x > actualViewport.width / 2 ? 0.5 : 0.0;
                    if (pixelOffset == null) {
                        Rectangle2D rect = bubbleI.getTotalBound();
                        double x = origin.x;
                        double y = origin.y - 48;
                        if (rect != null) {
                            y -= rect.getHeight();
                            double VIEWPORT_PAD = 64.0;
                            x = Math.min(Math.max(x, 64.0), (double)actualViewport.width - rect.getWidth() - 64.0);
                            y = Math.min(Math.max(y, 64.0), (double)actualViewport.height - rect.getHeight() - 64.0);
                        }
                        bubbleI.setPixelOffset(new Point((int)x, (int)y));
                    }
                }
                ++i2;
            }
        }
        return isPaintRequired;
    }

    @Override
    public void cleared(RenderTargetEvent ev) {
    }

    @Override
    public void rendered(RenderTargetEvent ev) {
        this.m_renderTarget = ev.getRenderTarget();
        if (this.layoutBubbles(this.m_renderTarget)) {
            Graphics g = this.m_renderTarget.getOffscreenGraphics();
            try {
                int i = 0;
                while (i < this.m_bubbles.length) {
                    Bubble bubbleI = this.m_bubbles[i];
                    bubbleI.paint(g);
                    ++i;
                }
            }
            finally {
                g.dispose();
            }
        }
    }
}

