/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.behavior;

import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.behavior.MultipleRuntimeResponsePolicy;
import edu.cmu.cs.stage3.alice.core.behavior.TriggerBehavior;
import edu.cmu.cs.stage3.alice.core.property.NumberProperty;
import java.io.IOException;
import java.util.Vector;
import javax.media.Buffer;
import javax.media.CaptureDeviceInfo;
import javax.media.CaptureDeviceManager;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.NoDataSourceException;
import javax.media.NoProcessorException;
import javax.media.Processor;
import javax.media.Renderer;
import javax.media.UnsupportedPlugInException;
import javax.media.format.AudioFormat;
import javax.media.protocol.DataSource;

public class SoundLevelBehavior
extends TriggerBehavior
implements ControllerListener,
Renderer {
    public final NumberProperty level = new NumberProperty(this, "level", new Double(0.3));
    private Processor player;
    private DataSource dataSource;
    private ControllerErrorEvent m_errorEvent;
    Format inputFormat;
    Format[] inputFormats = new Format[]{new AudioFormat("LINEAR", -1.0, 16, -1, 0, -1, -1, -1.0, Format.byteArray)};

    public SoundLevelBehavior() {
        this.multipleRuntimeResponsePolicy.set(MultipleRuntimeResponsePolicy.IGNORE_MULTIPLE);
    }

    @Override
    public void started(World world, double time) {
        super.started(world, time);
        AudioFormat format = new AudioFormat("LINEAR", -1.0, 16, 1);
        Vector captureDeviceList = CaptureDeviceManager.getDeviceList((Format)format);
        if (captureDeviceList.size() <= 0) {
            System.err.println("No Audio Capture Devices Detected");
            return;
        }
        CaptureDeviceInfo captureDevice = (CaptureDeviceInfo)captureDeviceList.firstElement();
        MediaLocator inputLocator = captureDevice.getLocator();
        this.dataSource = null;
        try {
            this.dataSource = Manager.createDataSource((MediaLocator)inputLocator);
        }
        catch (NoDataSourceException ndse) {
            ndse.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        if (this.dataSource == null) {
            return;
        }
        this.player = null;
        try {
            this.player = Manager.createProcessor((DataSource)this.dataSource);
        }
        catch (NoProcessorException npe) {
            npe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        if (this.player == null) {
            return;
        }
        this.player.addControllerListener((ControllerListener)this);
        this.m_errorEvent = null;
        this.player.configure();
        while (this.player.getState() == 140 && this.m_errorEvent == null) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        }
        if (this.m_errorEvent != null || this.player.getState() != 180) {
            this.player.removeControllerListener((ControllerListener)this);
            return;
        }
        this.player.setContentDescriptor(null);
        try {
            this.player.getTrackControls()[0].setRenderer((Renderer)this);
        }
        catch (UnsupportedPlugInException upie) {
            upie.printStackTrace();
        }
        this.m_errorEvent = null;
        this.player.realize();
        while (this.player.getState() == 200 && this.m_errorEvent == null) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        }
        this.player.removeControllerListener((ControllerListener)this);
        if (this.m_errorEvent != null || this.player.getState() != 300) {
            return;
        }
        this.player.start();
    }

    @Override
    public void stopped(World world, double time) {
        super.stopped(world, time);
        try {
            this.player.stop();
            this.dataSource.stop();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        this.dataSource.disconnect();
    }

    public void controllerUpdate(ControllerEvent event) {
        if (event instanceof ControllerErrorEvent) {
            this.m_errorEvent = (ControllerErrorEvent)event;
        }
    }

    public Format[] getSupportedInputFormats() {
        return this.inputFormats;
    }

    public Format setInputFormat(Format format) {
        this.inputFormat = format;
        return format;
    }

    public String getName() {
        return "SoundLevelBehavior";
    }

    public void close() {
    }

    public void open() {
    }

    public void reset() {
    }

    public void start() {
    }

    public void stop() {
    }

    public Object[] getControls() {
        return new Object[0];
    }

    public Object getControl(String name) {
        return null;
    }

    public int process(Buffer input) {
        byte[] inData = (byte[])input.getData();
        int inOffset = input.getOffset();
        int dataLength = input.getLength();
        int numSamples = dataLength / 2;
        long start_t = input.getTimeStamp() / 1000000L;
        int i = 0;
        while (i < numSamples / ((AudioFormat)input.getFormat()).getChannels()) {
            int rsample;
            byte tempL = inData[inOffset++];
            byte tempH = inData[inOffset++];
            int lsample = tempH << 8 | tempL & 0xFF;
            if (((AudioFormat)input.getFormat()).getChannels() == 2) {
                tempL = inData[inOffset++];
                tempH = inData[inOffset++];
                rsample = tempH << 8 | tempL & 0xFF;
            } else {
                rsample = lsample;
            }
            if ((double)lsample / 65535.0 >= this.level.doubleValue() || (double)rsample / 65535.0 >= this.level.doubleValue()) {
                this.trigger((double)System.currentTimeMillis() * 0.001);
            }
            ++i;
        }
        return 0;
    }
}

