/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.behavior;

import edu.cmu.cs.stage3.alice.core.Camera;
import edu.cmu.cs.stage3.alice.core.Direction;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.RenderTarget;
import edu.cmu.cs.stage3.alice.core.Transformable;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.behavior.InternalResponseBehavior;
import edu.cmu.cs.stage3.alice.core.navigation.KeyMapping;
import edu.cmu.cs.stage3.alice.core.property.BooleanProperty;
import edu.cmu.cs.stage3.alice.core.property.ElementProperty;
import edu.cmu.cs.stage3.alice.core.property.NumberProperty;
import edu.cmu.cs.stage3.alice.core.property.TransformableProperty;
import javax.vecmath.Vector3d;

public class KeyboardNavigationBehavior
extends InternalResponseBehavior {
    private RenderTarget renderTarget;
    private Vector3d speed = new Vector3d(0.0, 0.0, 0.0);
    private Vector3d turning = new Vector3d(0.0, 0.0, 0.0);
    public NumberProperty maxSpeed = new NumberProperty(this, "maxSpeed", new Double(15.0));
    public NumberProperty maxTurning = new NumberProperty(this, "maxTurning", new Double(0.15));
    public NumberProperty speedAccel = new NumberProperty(this, "speedAccel", new Double(20.0));
    public NumberProperty turningAccel = new NumberProperty(this, "turningAccel", new Double(0.35));
    public BooleanProperty stayOnGround = new BooleanProperty(this, "stayOnGround", Boolean.TRUE);
    public TransformableProperty subject = new TransformableProperty((Element)this, "subject", null);
    public ElementProperty keyMap = new ElementProperty((Element)this, "keyMap", null, KeyMapping.class);

    protected void disable() {
        this.renderTarget.removeKeyListener((KeyMapping)this.keyMap.get());
    }

    protected void enable() {
        this.renderTarget.addKeyListener((KeyMapping)this.keyMap.get());
    }

    @Override
    public void started(World world, double time) {
        super.started(world, time);
        if (this.isEnabled.booleanValue()) {
            RenderTarget[] rts = (RenderTarget[])world.getDescendants(RenderTarget.class);
            if (rts.length > 0) {
                Camera[] cameras;
                this.renderTarget = rts[0];
                if (this.subject.get() == null && (cameras = this.renderTarget.getCameras()).length > 0) {
                    this.subject.set(cameras[0]);
                }
            }
            if (this.keyMap.get() == null) {
                this.keyMap.set(new KeyMapping());
            }
            ((KeyMapping)this.keyMap.get()).cleanState();
            this.enable();
        }
    }

    @Override
    public void stopped(World world, double time) {
        super.stopped(world, time);
        if (this.isEnabled.booleanValue()) {
            this.disable();
        }
    }

    @Override
    public void internalSchedule(double time, double dt) {
        KeyMapping keyMapping = (KeyMapping)this.keyMap.getElementValue();
        int actions = keyMapping.getActions();
        this.speed.z = (actions & 1) != 0 ? (this.speed.z += dt * this.speedAccel.getNumberValue().doubleValue()) : ((actions & 2) != 0 ? (this.speed.z -= dt * this.speedAccel.getNumberValue().doubleValue()) : (Math.abs(this.speed.z) >= dt * this.speedAccel.getNumberValue().doubleValue() ? this.speed.z + (double)(this.speed.z < 0.0 ? 1 : -1) * dt * this.speedAccel.getNumberValue().doubleValue() : 0.0));
        this.speed.x = (actions & 4) != 0 ? (this.speed.x -= dt * this.speedAccel.getNumberValue().doubleValue()) : ((actions & 8) != 0 ? (this.speed.x += dt * this.speedAccel.getNumberValue().doubleValue()) : (Math.abs(this.speed.x) >= dt * this.speedAccel.getNumberValue().doubleValue() ? this.speed.x + (double)(this.speed.x < 0.0 ? 1 : -1) * dt * this.speedAccel.getNumberValue().doubleValue() : 0.0));
        this.speed.y = (actions & 0x10) != 0 ? (this.speed.y += dt * this.speedAccel.getNumberValue().doubleValue()) : ((actions & 0x20) != 0 ? (this.speed.y -= dt * this.speedAccel.getNumberValue().doubleValue()) : (Math.abs(this.speed.y) >= dt * this.speedAccel.getNumberValue().doubleValue() ? this.speed.y + (double)(this.speed.y < 0.0 ? 1 : -1) * dt * this.speedAccel.getNumberValue().doubleValue() : 0.0));
        this.turning.y = (actions & 0x40) != 0 ? (this.turning.y -= dt * this.turningAccel.getNumberValue().doubleValue()) : ((actions & 0x80) != 0 ? (this.turning.y += dt * this.turningAccel.getNumberValue().doubleValue()) : (Math.abs(this.turning.y) >= dt * this.turningAccel.getNumberValue().doubleValue() ? this.turning.y + (double)(this.turning.y < 0.0 ? 1 : -1) * dt * this.turningAccel.getNumberValue().doubleValue() : 0.0));
        this.turning.x = (actions & 0x100) != 0 ? (this.turning.x -= dt * this.turningAccel.getNumberValue().doubleValue()) : ((actions & 0x200) != 0 ? (this.turning.x += dt * this.turningAccel.getNumberValue().doubleValue()) : (Math.abs(this.turning.x) >= dt * this.turningAccel.getNumberValue().doubleValue() ? this.turning.x + (double)(this.turning.x < 0.0 ? 1 : -1) * dt * this.turningAccel.getNumberValue().doubleValue() : 0.0));
        this.turning.z = (actions & 0x400) != 0 ? (this.turning.z += dt * this.turningAccel.getNumberValue().doubleValue()) : ((actions & 0x800) != 0 ? (this.turning.z -= dt * this.turningAccel.getNumberValue().doubleValue()) : (Math.abs(this.turning.z) >= dt * this.turningAccel.getNumberValue().doubleValue() ? this.turning.z + (double)(this.turning.z < 0.0 ? 1 : -1) * dt * this.turningAccel.getNumberValue().doubleValue() : 0.0));
        if (this.speed.x < -this.maxSpeed.getNumberValue().doubleValue()) {
            this.speed.x = -this.maxSpeed.getNumberValue().doubleValue();
        }
        if (this.speed.x > this.maxSpeed.getNumberValue().doubleValue()) {
            this.speed.x = this.maxSpeed.getNumberValue().doubleValue();
        }
        if (this.speed.y < -this.maxSpeed.getNumberValue().doubleValue()) {
            this.speed.y = -this.maxSpeed.getNumberValue().doubleValue();
        }
        if (this.speed.y > this.maxSpeed.getNumberValue().doubleValue()) {
            this.speed.y = this.maxSpeed.getNumberValue().doubleValue();
        }
        if (this.speed.z < -this.maxSpeed.getNumberValue().doubleValue()) {
            this.speed.z = -this.maxSpeed.getNumberValue().doubleValue();
        }
        if (this.speed.z > this.maxSpeed.getNumberValue().doubleValue()) {
            this.speed.z = this.maxSpeed.getNumberValue().doubleValue();
        }
        if (this.turning.x < -this.maxTurning.getNumberValue().doubleValue()) {
            this.turning.x = -this.maxTurning.getNumberValue().doubleValue();
        }
        if (this.turning.x > this.maxTurning.getNumberValue().doubleValue()) {
            this.turning.x = this.maxTurning.getNumberValue().doubleValue();
        }
        if (this.turning.y < -this.maxTurning.getNumberValue().doubleValue()) {
            this.turning.y = -this.maxTurning.getNumberValue().doubleValue();
        }
        if (this.turning.y > this.maxTurning.getNumberValue().doubleValue()) {
            this.turning.y = this.maxTurning.getNumberValue().doubleValue();
        }
        if (this.turning.z < -this.maxTurning.getNumberValue().doubleValue()) {
            this.turning.z = -this.maxTurning.getNumberValue().doubleValue();
        }
        if (this.turning.z > this.maxTurning.getNumberValue().doubleValue()) {
            this.turning.z = this.maxTurning.getNumberValue().doubleValue();
        }
        Vector3d vector = new Vector3d(dt * this.speed.x, dt * this.speed.y, dt * this.speed.z);
        Transformable subjectTransformable = this.subject.getTransformableValue();
        try {
            vector = subjectTransformable.preventPassingThroughOtherObjects(vector, 2.0);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        subjectTransformable.moveRightNow(vector);
        subjectTransformable.turnRightNow(Direction.FORWARD, dt * this.turning.x);
        if (((Boolean)this.stayOnGround.get()).booleanValue()) {
            Transformable t = new Transformable();
            t.setPositionRightNow(subjectTransformable.getPosition(subjectTransformable.getWorld()));
            subjectTransformable.turnRightNow(Direction.RIGHT, dt * this.turning.y, t);
        } else {
            subjectTransformable.turnRightNow(Direction.RIGHT, dt * this.turning.y);
        }
        subjectTransformable.rollRightNow(Direction.LEFT, dt * this.turning.z);
    }
}

