/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.behavior;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.List;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.RenderTarget;
import edu.cmu.cs.stage3.alice.core.Transformable;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.behavior.InternalResponseBehavior;
import edu.cmu.cs.stage3.alice.core.manipulator.RenderTargetModelManipulator;
import edu.cmu.cs.stage3.alice.core.property.ElementArrayProperty;
import edu.cmu.cs.stage3.alice.core.property.ListProperty;
import java.util.Enumeration;
import java.util.Vector;

public class DefaultMouseInteractionBehavior
extends InternalResponseBehavior {
    public final ElementArrayProperty renderTargets = new ElementArrayProperty((Element)this, "renderTargets", null, RenderTarget[].class);
    public final ListProperty objects = new ListProperty((Element)this, "objects", null);
    protected Vector manipulators = new Vector();

    protected void scheduled(double t) {
    }

    protected void objectsValueChanged(List value) {
        Enumeration enum0 = this.manipulators.elements();
        while (enum0.hasMoreElements()) {
            RenderTargetModelManipulator rtmm = (RenderTargetModelManipulator)enum0.nextElement();
            rtmm.clearObjectsOfInterestList();
            if (value == null) continue;
            int i = 0;
            while (i < value.values.getArrayValue().length) {
                rtmm.addObjectOfInterest((Transformable)value.values.getArrayValue()[i]);
                ++i;
            }
        }
    }

    private void setIsEnabled(boolean value) {
        if (this.manipulators != null) {
            Enumeration enum0 = this.manipulators.elements();
            while (enum0.hasMoreElements()) {
                ((RenderTargetModelManipulator)enum0.nextElement()).setEnabled(this.isEnabled.booleanValue());
            }
        }
    }

    @Override
    protected void enabled() {
        this.setIsEnabled(true);
    }

    @Override
    protected void disabled() {
        this.setIsEnabled(false);
    }

    @Override
    protected void propertyChanged(Property property, Object value) {
        if (property == this.objects) {
            this.objectsValueChanged(this.objects.getListValue());
        } else {
            super.propertyChanged(property, value);
        }
    }

    @Override
    protected void started(World world, double time) {
        super.started(world, time);
        this.manipulators.clear();
        RenderTarget[] renderTargetsValue = (RenderTarget[])this.renderTargets.get();
        if (renderTargetsValue == null) {
            renderTargetsValue = (RenderTarget[])world.getDescendants(RenderTarget.class);
        }
        int i = 0;
        while (i < renderTargetsValue.length) {
            RenderTargetModelManipulator rtmm = new RenderTargetModelManipulator(renderTargetsValue[i].getInternal());
            rtmm.setPickAllForOneObjectOfInterestEnabled(false);
            this.manipulators.addElement(rtmm);
            ++i;
        }
        this.objectsValueChanged(this.objects.getListValue());
        this.setIsEnabled(this.isEnabled.booleanValue());
    }

    @Override
    protected void stopped(World world, double time) {
        super.stopped(world, time);
        Enumeration enum0 = this.manipulators.elements();
        while (enum0.hasMoreElements()) {
            ((RenderTargetModelManipulator)enum0.nextElement()).setRenderTarget(null);
        }
        this.manipulators.clear();
    }
}

