/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core.behavior;

import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.ReferenceFrame;
import edu.cmu.cs.stage3.alice.core.Transformable;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.behavior.InternalResponseBehavior;
import edu.cmu.cs.stage3.alice.core.property.BooleanProperty;
import edu.cmu.cs.stage3.alice.core.property.ReferenceFrameProperty;
import edu.cmu.cs.stage3.alice.core.property.TransformableProperty;
import edu.cmu.cs.stage3.alice.core.property.Vector3Property;
import edu.cmu.cs.stage3.alice.scenegraph.event.AbsoluteTransformationEvent;
import edu.cmu.cs.stage3.alice.scenegraph.event.AbsoluteTransformationListener;
import edu.cmu.cs.stage3.lang.Messages;
import javax.vecmath.Vector3d;

public class BillboardBehavior
extends InternalResponseBehavior
implements AbsoluteTransformationListener {
    public final TransformableProperty subject = new TransformableProperty((Element)this, "subject", null);
    public final TransformableProperty target = new TransformableProperty((Element)this, "target", null);
    public final Vector3Property offset = new Vector3Property(this, "offset", null);
    public final Vector3Property upGuide = new Vector3Property(this, "upGuide", null);
    public final ReferenceFrameProperty asSeenBy = new ReferenceFrameProperty((Element)this, "asSeenBy", null);
    public final BooleanProperty onlyAffectYaw = new BooleanProperty(this, "onlyAffectYaw", Boolean.FALSE);
    private Transformable m_subject;
    private Transformable m_target;
    private Vector3d m_offset;
    private Vector3d m_upGuide;
    private ReferenceFrame m_asSeenBy;
    private boolean m_onlyAffectYaw;
    private boolean m_isDirty = false;

    @Override
    protected void propertyChanging(Property property, Object value) {
        if (property == this.target) {
            if (value == this.subject.get()) {
                throw new IllegalArgumentException(Messages.getString("billboard_cannot_point_at_self"));
            }
        } else {
            super.propertyChanging(property, value);
        }
    }

    @Override
    protected void propertyChanged(Property property, Object value) {
        if (property != this.target) {
            super.propertyChanged(property, value);
        }
    }

    @Override
    public void absoluteTransformationChanged(AbsoluteTransformationEvent absoluteTransformationEvent) {
        this.m_isDirty = true;
    }

    @Override
    public void internalSchedule(double time, double dt) {
        if (this.m_isDirty) {
            if (this.m_subject != null && this.m_target != null) {
                this.m_subject.pointAtRightNow(this.m_target, this.m_offset, this.m_upGuide, this.m_asSeenBy, this.m_onlyAffectYaw);
            }
            this.m_isDirty = false;
        }
    }

    @Override
    public void started(World world, double time) {
        super.started(world, time);
        this.m_subject = this.subject.getTransformableValue();
        this.m_target = this.target.getTransformableValue();
        this.m_offset = this.offset.getVector3Value();
        this.m_upGuide = this.upGuide.getVector3Value();
        this.m_asSeenBy = this.asSeenBy.getReferenceFrameValue();
        this.m_onlyAffectYaw = this.onlyAffectYaw.booleanValue();
        if (this.m_subject != null) {
            this.m_subject.addAbsoluteTransformationListener(this);
        }
        if (this.m_target != null) {
            this.m_target.addAbsoluteTransformationListener(this);
        }
        this.m_isDirty = false;
    }

    @Override
    public void stopped(World world, double time) {
        if (this.m_subject != null) {
            this.m_subject.removeAbsoluteTransformationListener(this);
        }
        if (this.m_target != null) {
            this.m_target.removeAbsoluteTransformationListener(this);
        }
        super.stopped(world, time);
    }
}

