/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core;

import edu.cmu.cs.stage3.alice.core.Camera;
import edu.cmu.cs.stage3.alice.core.Dimension;
import edu.cmu.cs.stage3.alice.core.Direction;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Model;
import edu.cmu.cs.stage3.alice.core.Pose;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.ReferenceFrame;
import edu.cmu.cs.stage3.alice.core.RenderTarget;
import edu.cmu.cs.stage3.alice.core.SpatialRelation;
import edu.cmu.cs.stage3.alice.core.decorator.PivotDecorator;
import edu.cmu.cs.stage3.alice.core.property.BooleanProperty;
import edu.cmu.cs.stage3.alice.core.property.ElementArrayProperty;
import edu.cmu.cs.stage3.alice.core.property.Matrix44Property;
import edu.cmu.cs.stage3.alice.core.property.VehicleProperty;
import edu.cmu.cs.stage3.alice.scenegraph.Component;
import edu.cmu.cs.stage3.alice.scenegraph.Container;
import edu.cmu.cs.stage3.alice.scenegraph.Geometry;
import edu.cmu.cs.stage3.alice.scenegraph.IndexedTriangleArray;
import edu.cmu.cs.stage3.alice.scenegraph.Vertex3d;
import edu.cmu.cs.stage3.alice.scenegraph.Visual;
import edu.cmu.cs.stage3.alice.scenegraph.event.AbsoluteTransformationListener;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.PickInfo;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.math.Box;
import edu.cmu.cs.stage3.math.EulerAngles;
import edu.cmu.cs.stage3.math.MathUtilities;
import edu.cmu.cs.stage3.math.Matrix33;
import edu.cmu.cs.stage3.math.Matrix44;
import edu.cmu.cs.stage3.math.Quaternion;
import edu.cmu.cs.stage3.math.Sphere;
import edu.cmu.cs.stage3.math.Vector3;
import edu.cmu.cs.stage3.math.Vector4;
import edu.cmu.cs.stage3.util.HowMuch;
import edu.cmu.cs.stage3.util.VisitListener;
import java.util.Vector;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;

public class Transformable
extends ReferenceFrame {
    public final ElementArrayProperty parts = new ElementArrayProperty((Element)this, "parts", null, Transformable[].class);
    public final ElementArrayProperty poses = new ElementArrayProperty((Element)this, "poses", null, Pose[].class);
    public final Matrix44Property localTransformation = new Matrix44Property(this, "localTransformation", new Matrix44());
    public final VehicleProperty vehicle = new VehicleProperty((Element)this, "vehicle", null);
    public final BooleanProperty isPivotShowing = new BooleanProperty(this, "isPivotShowing", Boolean.FALSE);
    private edu.cmu.cs.stage3.alice.scenegraph.Transformable m_sgTransformable;
    private PivotDecorator m_pivotDecorator = new PivotDecorator();
    private static Transformable s_getAGoodLookDummy = null;

    public Transformable() {
        this.m_sgTransformable = new edu.cmu.cs.stage3.alice.scenegraph.Transformable();
        this.m_sgTransformable.setBonus(this);
        this.m_pivotDecorator.setTransformable(this);
    }

    public Visual[] getAllSceneGraphVisuals(HowMuch howMuch) {
        final Vector v = new Vector();
        this.visit(new VisitListener(){

            @Override
            public void visited(Object o) {
                if (o instanceof Model) {
                    v.addElement(((Model)o).getSceneGraphVisual());
                }
            }
        }, howMuch);
        Object[] sgVisuals = new Visual[v.size()];
        v.copyInto(sgVisuals);
        return sgVisuals;
    }

    public Visual[] getAllSceneGraphVisuals() {
        return this.getAllSceneGraphVisuals(HowMuch.INSTANCE_AND_PARTS);
    }

    @Override
    protected void internalRelease(int pass) {
        switch (pass) {
            case 1: {
                this.m_sgTransformable.setParent(null);
                this.m_pivotDecorator.internalRelease(1);
                break;
            }
            case 2: {
                this.m_sgTransformable.release();
                this.m_sgTransformable = null;
                this.m_pivotDecorator.internalRelease(2);
                this.m_pivotDecorator = null;
            }
        }
        super.internalRelease(pass);
    }

    private Transformable internalGetPartNamed(String nameValue, boolean ignoreCase) {
        int i = 0;
        while (i < this.parts.size()) {
            boolean found;
            Transformable part = (Transformable)this.parts.get(i);
            if (nameValue != null ? (found = ignoreCase ? nameValue.equalsIgnoreCase(part.name.getStringValue()) : nameValue.equals(part.name.getStringValue())) : part.name.getStringValue() == null) {
                return part;
            }
            ++i;
        }
        return null;
    }

    private Transformable internalGetPartKeyed(String key, int fromIndex, boolean ignoreCase) {
        if (key.equals("")) {
            return this;
        }
        int toIndex = key.indexOf(46, fromIndex);
        if (toIndex == -1) {
            String childName = key.substring(fromIndex);
            return this.internalGetPartNamed(childName, ignoreCase);
        }
        String childName = key.substring(fromIndex, toIndex);
        Transformable child = this.internalGetPartNamed(childName, ignoreCase);
        if (child != null) {
            return child.internalGetPartKeyed(key, toIndex + 1, ignoreCase);
        }
        return null;
    }

    public Element getPartKeyed(String key) {
        return this.internalGetPartKeyed(key, 0, false);
    }

    public Element getPartKeyedIgnoreCase(String key) {
        return this.internalGetPartKeyed(key, 0, true);
    }

    @Override
    public void addAbsoluteTransformationListener(AbsoluteTransformationListener absoluteTransformationListener) {
        this.m_sgTransformable.addAbsoluteTransformationListener(absoluteTransformationListener);
    }

    @Override
    public void removeAbsoluteTransformationListener(AbsoluteTransformationListener absoluteTransformationListener) {
        this.m_sgTransformable.removeAbsoluteTransformationListener(absoluteTransformationListener);
    }

    public edu.cmu.cs.stage3.alice.scenegraph.Transformable getSceneGraphTransformable() {
        return this.m_sgTransformable;
    }

    @Override
    public edu.cmu.cs.stage3.alice.scenegraph.ReferenceFrame getSceneGraphReferenceFrame() {
        return this.m_sgTransformable;
    }

    @Override
    public Container getSceneGraphContainer() {
        return this.m_sgTransformable;
    }

    public void syncLocalTransformationPropertyToSceneGraph() {
        Matrix4d m = this.m_sgTransformable.getLocalTransformation();
        this.localTransformation.set(m);
    }

    @Override
    protected void nameValueChanged(String value) {
        super.nameValueChanged(value);
        String s = null;
        if (value != null) {
            s = String.valueOf(value) + ".m_sgTransformable";
        }
        this.m_sgTransformable.setName(s);
    }

    @Override
    protected void propertyChanging(Property property, Object value) {
        if (property == this.vehicle) {
            ReferenceFrame vehicleToBe = (ReferenceFrame)value;
            if (vehicleToBe != null) {
                if (vehicleToBe == this) {
                    throw new RuntimeException(this + " " + Messages.getString("cannot_be_its_own_vehicle_"));
                }
                if (vehicleToBe.getSceneGraphContainer().isDescendantOf(this.getSceneGraphContainer())) {
                    throw new RuntimeException(this + " " + Messages.getString("cannot_have_a_scenegraph_descendant__") + vehicleToBe + Messages.getString("__as_its_vehicle_"));
                }
            }
        } else if (property == this.localTransformation) {
            if (value == null) {
                throw new NullPointerException();
            }
        } else if (property != this.isPivotShowing) {
            super.propertyChanging(property, value);
        }
    }

    @Override
    protected void propertyChanged(Property property, Object value) {
        if (property == this.vehicle) {
            if (value != null) {
                this.m_sgTransformable.setParent(((ReferenceFrame)value).getSceneGraphContainer());
            } else {
                this.m_sgTransformable.setParent(null);
            }
        } else if (property == this.localTransformation) {
            this.m_sgTransformable.setLocalTransformation((Matrix4d)value);
        } else if (property == this.isPivotShowing) {
            this.m_pivotDecorator.setIsShowing((Boolean)value);
        } else {
            super.propertyChanged(property, value);
        }
    }

    public void setVehiclePreservingAbsoluteTransformation(ReferenceFrame vehicleValue) {
        edu.cmu.cs.stage3.alice.scenegraph.Transformable sgTransformable = this.getSceneGraphTransformable();
        Container sgRoot = sgTransformable.getRoot();
        Matrix4d absoluteTransformation = sgTransformable.getAbsoluteTransformation();
        this.vehicle.set(vehicleValue);
        if (sgRoot instanceof edu.cmu.cs.stage3.alice.scenegraph.ReferenceFrame) {
            sgTransformable.setTransformation(absoluteTransformation, (edu.cmu.cs.stage3.alice.scenegraph.ReferenceFrame)sgRoot);
            this.syncLocalTransformationPropertyToSceneGraph();
        }
    }

    public double getSpatialRelationDistance(SpatialRelation spatialRelation, Transformable object, ReferenceFrame asSeenBy) {
        try {
            if (asSeenBy == null) {
                asSeenBy = object;
            }
            Box subjectBB = this.getBoundingBox(asSeenBy);
            Box objectBB = object.getBoundingBox(asSeenBy);
            if (spatialRelation == SpatialRelation.RIGHT_OF) {
                return subjectBB.getMinimum().x - objectBB.getMaximum().x;
            }
            if (spatialRelation == SpatialRelation.LEFT_OF) {
                return objectBB.getMinimum().x - subjectBB.getMaximum().x;
            }
            if (spatialRelation == SpatialRelation.ABOVE) {
                return subjectBB.getMinimum().y - objectBB.getMaximum().y;
            }
            if (spatialRelation == SpatialRelation.BELOW) {
                return objectBB.getMinimum().y - subjectBB.getMaximum().y;
            }
            if (spatialRelation == SpatialRelation.IN_FRONT_OF) {
                return subjectBB.getMinimum().z - objectBB.getMaximum().z;
            }
            if (spatialRelation == SpatialRelation.BEHIND) {
                return objectBB.getMinimum().z - subjectBB.getMaximum().z;
            }
            throw new RuntimeException();
        }
        catch (NullPointerException npe) {
            Transformable.warnln(npe);
            return 0.0;
        }
    }

    public boolean isInSpatialRelationTo(SpatialRelation spatialRelation, Transformable object, ReferenceFrame asSeenBy) {
        return this.getSpatialRelationDistance(spatialRelation, object, asSeenBy) > 0.0;
    }

    public boolean isRightOf(Transformable object, ReferenceFrame asSeenBy) {
        return this.isInSpatialRelationTo(SpatialRelation.RIGHT_OF, object, asSeenBy);
    }

    public boolean isRightOf(Transformable object) {
        return this.isRightOf(object, null);
    }

    public boolean isLeftOf(Transformable object, ReferenceFrame asSeenBy) {
        return this.isInSpatialRelationTo(SpatialRelation.LEFT_OF, object, asSeenBy);
    }

    public boolean isLeftOf(Transformable object) {
        return this.isLeftOf(object, null);
    }

    public boolean isAbove(Transformable object, ReferenceFrame asSeenBy) {
        return this.isInSpatialRelationTo(SpatialRelation.ABOVE, object, asSeenBy);
    }

    public boolean isAbove(Transformable object) {
        return this.isAbove(object, null);
    }

    public boolean isBelow(Transformable object, ReferenceFrame asSeenBy) {
        return this.isInSpatialRelationTo(SpatialRelation.BELOW, object, asSeenBy);
    }

    public boolean isBelow(Transformable object) {
        return this.isBelow(object, null);
    }

    public boolean isInFrontOf(Transformable object, ReferenceFrame asSeenBy) {
        return this.isInSpatialRelationTo(SpatialRelation.IN_FRONT_OF, object, asSeenBy);
    }

    public boolean isInFrontOf(Transformable object) {
        return this.isInFrontOf(object, null);
    }

    public boolean isBehind(Transformable object, ReferenceFrame asSeenBy) {
        return this.isInSpatialRelationTo(SpatialRelation.BEHIND, object, asSeenBy);
    }

    public boolean isBehind(Transformable object) {
        return this.isBehind(object, null);
    }

    public double getVolume() {
        Sphere sphere = this.getBoundingSphere();
        if (sphere != null) {
            double r = sphere.getRadius();
            return r * r;
        }
        return 0.0;
    }

    public Matrix44 getLocalTransformation() {
        Matrix4d localTransformation = this.m_sgTransformable.getLocalTransformation();
        if (localTransformation != null) {
            return new Matrix44(localTransformation);
        }
        return null;
    }

    @Override
    public Matrix44 getTransformation(Vector3d offset, ReferenceFrame asSeenBy) {
        ReferenceFrame vehicleValue = (ReferenceFrame)this.vehicle.getValue();
        if (asSeenBy == null) {
            asSeenBy = vehicleValue;
        }
        if (asSeenBy == vehicleValue && offset == null) {
            return this.getLocalTransformation();
        }
        return super.getTransformation(offset, asSeenBy);
    }

    protected double getViewingAngleForGetAGoodLookAt() {
        return 0.7853981633974483;
    }

    public Matrix4d calculateGoodLookAt(ReferenceFrame target, ReferenceFrame asSeenBy, HowMuch howMuch) {
        if (s_getAGoodLookDummy == null) {
            s_getAGoodLookDummy = new Transformable();
            Transformable.s_getAGoodLookDummy.name.set("s_getAGoodLookDummy");
        }
        if (target instanceof Transformable) {
            Transformable.s_getAGoodLookDummy.vehicle.set(((Transformable)target).vehicle.get());
        } else {
            Transformable.s_getAGoodLookDummy.vehicle.set(target);
        }
        Sphere bs = target.getBoundingSphere();
        Vector3d center = bs.getCenter();
        double radius = bs.getRadius();
        if (center == null || Double.isNaN(center.x) || Double.isNaN(center.y) || Double.isNaN(center.z)) {
            center = target.getPosition();
        }
        if (radius == 0.0 || Double.isNaN(radius)) {
            radius = 1.0;
        }
        double theta = this.getViewingAngleForGetAGoodLookAt();
        double dist = radius / Math.sin(theta / 2.0);
        double offset = dist / Math.sqrt(3.0);
        s_getAGoodLookDummy.setPositionRightNow(center.x - offset, center.y + offset, center.z + offset, target);
        s_getAGoodLookDummy.pointAtRightNow(target, center, null, asSeenBy);
        Matrix44 m = s_getAGoodLookDummy.getTransformation(asSeenBy);
        Transformable.s_getAGoodLookDummy.vehicle.set(null);
        return m;
    }

    public Matrix4d calculateGoodLookAt(ReferenceFrame target, ReferenceFrame asSeenBy) {
        return this.calculateGoodLookAt(target, asSeenBy, HowMuch.INSTANCE_AND_PARTS);
    }

    public Matrix4d calculateGoodLookAt(ReferenceFrame target) {
        return this.calculateGoodLookAt(target, null);
    }

    public void getAGoodLookAtRightNow(ReferenceFrame target, ReferenceFrame asSeenBy, HowMuch howMuch) {
        this.setTransformationRightNow(this.calculateGoodLookAt(target, asSeenBy, howMuch), asSeenBy);
    }

    public void getAGoodLookAtRightNow(ReferenceFrame target, ReferenceFrame asSeenBy) {
        this.getAGoodLookAtRightNow(target, asSeenBy, HowMuch.INSTANCE_AND_PARTS);
    }

    public void getAGoodLookAtRightNow(ReferenceFrame target) {
        this.getAGoodLookAtRightNow(target, null);
    }

    public Matrix44 calculateTransformation(Matrix4d m, ReferenceFrame asSeenBy) {
        ReferenceFrame vehicleValue = (ReferenceFrame)this.vehicle.getValue();
        if (asSeenBy == null) {
            asSeenBy = vehicleValue;
        }
        if (asSeenBy == vehicleValue) {
            return new Matrix44(m);
        }
        Matrix4d asSeenByAbsolute = asSeenBy.getSceneGraphReferenceFrame().getAbsoluteTransformation();
        Matrix4d vehicleInverseAbsolute = vehicleValue.getSceneGraphReferenceFrame().getInverseAbsoluteTransformation();
        return Matrix44.multiply(m, Matrix44.multiply(asSeenByAbsolute, vehicleInverseAbsolute));
    }

    public static Matrix33 calculateOrientation(Vector3d forward, Vector3d upGuide) {
        return edu.cmu.cs.stage3.alice.scenegraph.Transformable.calculateOrientation(forward, upGuide);
    }

    public Matrix33 calculateStandUp(ReferenceFrame asSeenBy) {
        edu.cmu.cs.stage3.alice.scenegraph.ReferenceFrame sgAsSeenBy = asSeenBy != null ? asSeenBy.getSceneGraphReferenceFrame() : null;
        return this.m_sgTransformable.calculateStandUp(sgAsSeenBy);
    }

    public Matrix33 calculatePointAt(ReferenceFrame target, Vector3d offset, Vector3d upGuide, ReferenceFrame asSeenBy, boolean onlyAffectYaw) {
        edu.cmu.cs.stage3.alice.scenegraph.ReferenceFrame sgAsSeenBy = asSeenBy != null ? asSeenBy.getSceneGraphReferenceFrame() : null;
        return this.m_sgTransformable.calculatePointAt(target.getSceneGraphReferenceFrame(), offset, upGuide, sgAsSeenBy, onlyAffectYaw);
    }

    public Matrix33 calculatePointAt(ReferenceFrame target, Vector3d offset, Vector3d upGuide, ReferenceFrame asSeenBy) {
        return this.calculatePointAt(target, offset, upGuide, asSeenBy, false);
    }

    public static Vector3 calculateResizeScale(Dimension dimension, double amount, boolean likeRubber) {
        double squash = likeRubber ? 1.0 / Math.sqrt(amount) : 1.0;
        Vector3 scale = Vector3.multiply(dimension.getScaleAxis(), amount);
        if (scale.x == 0.0) {
            scale.x = squash;
        }
        if (scale.y == 0.0) {
            scale.y = squash;
        }
        if (scale.z == 0.0) {
            scale.z = squash;
        }
        return scale;
    }

    public void setAbsoluteTransformationRightNow(Matrix4d m) {
        this.m_sgTransformable.setAbsoluteTransformation(m);
        this.syncLocalTransformationPropertyToSceneGraph();
    }

    public void setLocalTransformationRightNow(Matrix4d m) {
        this.m_sgTransformable.setLocalTransformation(m);
        this.syncLocalTransformationPropertyToSceneGraph();
    }

    public void setTransformationRightNow(Matrix4d m, ReferenceFrame asSeenBy) {
        this.m_sgTransformable.setLocalTransformation(this.calculateTransformation(m, asSeenBy));
        this.syncLocalTransformationPropertyToSceneGraph();
    }

    public void setPositionRightNow(Vector3d position, ReferenceFrame asSeenBy) {
        edu.cmu.cs.stage3.alice.scenegraph.ReferenceFrame sgAsSeenBy = asSeenBy != null ? asSeenBy.getSceneGraphReferenceFrame() : null;
        this.m_sgTransformable.setPosition(position, sgAsSeenBy);
        this.syncLocalTransformationPropertyToSceneGraph();
    }

    public void placeOnRightNow(ReferenceFrame landmark, Vector3d offset, ReferenceFrame asSeenBy) {
        if (asSeenBy == null) {
            asSeenBy = ReferenceFrame.ABSOLUTE;
        }
        Vector3d a = this.getBoundingBox(asSeenBy).getCenterOfBottomFace();
        Vector3d b = landmark.getBoundingBox(asSeenBy).getCenterOfTopFace();
        Vector3d v = MathUtilities.subtract(b, a);
        if (offset != null) {
            v.add((Tuple3d)offset);
        }
        this.moveRightNow(v, asSeenBy);
    }

    public void placeOnRightNow(ReferenceFrame landmark, double[] offset, ReferenceFrame asSeenBy) {
        this.placeOnRightNow(landmark, new Vector3d(offset), asSeenBy);
    }

    public void placeOnRightNow(ReferenceFrame landmark, double x, double y, double z, ReferenceFrame asSeenBy) {
        this.placeOnRightNow(landmark, new Vector3d(x, y, z), asSeenBy);
    }

    public void placeOnRightNow(ReferenceFrame landmark, Vector3d offset) {
        this.placeOnRightNow(landmark, offset, null);
    }

    public void placeOnRightNow(ReferenceFrame landmark, double[] offset) {
        this.placeOnRightNow(landmark, new Vector3d(offset));
    }

    public void placeOnRightNow(ReferenceFrame landmark, double x, double y, double z) {
        this.placeOnRightNow(landmark, new Vector3d(x, y, z));
    }

    public void placeOnRightNow(ReferenceFrame landmark) {
        this.placeOnRightNow(landmark, (Vector3d)null);
    }

    public void setOrientationRightNow(Matrix3d axes, ReferenceFrame asSeenBy) {
        edu.cmu.cs.stage3.alice.scenegraph.ReferenceFrame sgAsSeenBy = asSeenBy != null ? asSeenBy.getSceneGraphReferenceFrame() : null;
        this.m_sgTransformable.setAxes(axes, sgAsSeenBy);
        this.syncLocalTransformationPropertyToSceneGraph();
    }

    public void setOrientationRightNow(Quaternion quaternion, ReferenceFrame asSeenBy) {
        this.setOrientationRightNow(quaternion.getMatrix33(), asSeenBy);
        this.syncLocalTransformationPropertyToSceneGraph();
    }

    public void setOrientationRightNow(EulerAngles eulerAngles, ReferenceFrame asSeenBy) {
        this.setOrientationRightNow(EulerAngles.revolutionsToRadians(eulerAngles).getMatrix33(), asSeenBy);
        this.syncLocalTransformationPropertyToSceneGraph();
    }

    public void setOrientationRightNow(Vector3d[] orientation, ReferenceFrame asSeenBy) {
        this.setOrientationRightNow(orientation[0], orientation[1], asSeenBy);
    }

    public void setOrientationRightNow(Vector3d forward, Vector3d upGuide, ReferenceFrame asSeenBy) {
        this.setOrientationRightNow(Transformable.calculateOrientation(forward, upGuide), asSeenBy);
        this.syncLocalTransformationPropertyToSceneGraph();
    }

    public void pointAtRightNow(ReferenceFrame target, Vector3d offset, Vector3d upGuide, ReferenceFrame asSeenBy, boolean onlyAffectYaw) {
        this.setOrientationRightNow(this.calculatePointAt(target, offset, upGuide, asSeenBy, onlyAffectYaw), asSeenBy);
        this.syncLocalTransformationPropertyToSceneGraph();
    }

    public void scaleSpaceRightNow(Vector3d axis, ReferenceFrame asSeenBy) {
        if (asSeenBy == null) {
            asSeenBy = this;
        }
        Matrix44 m = new Matrix44(this.getTransformation(asSeenBy));
        m.scale(axis);
        this.setTransformationRightNow(m, asSeenBy);
        this.syncLocalTransformationPropertyToSceneGraph();
    }

    protected void scalePositionsOfPosesRightNow(Transformable t, Vector3d scale, ReferenceFrame asSeenBy) {
        int i = 0;
        while (i < this.poses.size()) {
            Pose poseI = (Pose)this.poses.get(i);
            poseI.scalePositionRightNow(t, this, scale, asSeenBy);
            ++i;
        }
        Element parent = this.getParent();
        if (parent instanceof Transformable) {
            ((Transformable)parent).scalePositionsOfPosesRightNow(t, scale, asSeenBy);
        }
    }

    protected void scalePositionRightNow(Vector3d scale, ReferenceFrame asSeenBy) {
        Matrix44 m = this.getLocalTransformation();
        m.m30 *= scale.x;
        m.m31 *= scale.y;
        m.m32 *= scale.z;
        this.setLocalTransformationRightNow(m);
        this.scalePositionsOfPosesRightNow(this, scale, asSeenBy);
    }

    public void resizeRightNow(Vector3d scale, ReferenceFrame asSeenBy, HowMuch howMuch) {
        int i = 0;
        while (i < this.m_sgTransformable.getChildCount()) {
            Model model;
            Component sgComponent = this.m_sgTransformable.getChildAt(i);
            Object bonus = sgComponent.getBonus();
            if (sgComponent instanceof edu.cmu.cs.stage3.alice.scenegraph.Transformable) {
                Transformable transformable;
                if (bonus instanceof Transformable && (transformable = (Transformable)bonus) != null) {
                    transformable.scalePositionRightNow(scale, asSeenBy);
                    if (!(!howMuch.getDescend() || transformable.isFirstClass.booleanValue() && howMuch.getRespectDescendant())) {
                        transformable.resizeRightNow(scale, asSeenBy);
                    }
                }
            } else if (sgComponent instanceof Visual && bonus instanceof Model && (model = (Model)bonus) != null && sgComponent == model.getSceneGraphVisual()) {
                model.scaleVisualRightNow(scale, asSeenBy);
            }
            ++i;
        }
    }

    public void setSizeRightNow(Vector3d size, ReferenceFrame asSeenBy) {
        Vector3 prevSize = this.getSize();
        Vector3d deltaSize = new Vector3d(1.0, 1.0, 1.0);
        if (size.x != prevSize.x && prevSize.x != 0.0) {
            deltaSize.x = size.x / prevSize.x;
        }
        if (size.y != prevSize.y && prevSize.y != 0.0) {
            deltaSize.y = size.y / prevSize.y;
        }
        if (size.z != prevSize.z && prevSize.z != 0.0) {
            deltaSize.z = size.z / prevSize.z;
        }
        if (MathUtilities.contains((Tuple3d)deltaSize, Double.NaN) || MathUtilities.contains((Tuple3d)deltaSize, Double.POSITIVE_INFINITY) || MathUtilities.contains((Tuple3d)deltaSize, Double.NEGATIVE_INFINITY)) {
            throw new IllegalArgumentException(String.valueOf(Messages.getString("size__")) + size + Messages.getString("__previous_size__") + prevSize);
        }
        this.resizeRightNow(deltaSize, asSeenBy);
    }

    public void setScaledSpaceRightNow(Vector3d scale, ReferenceFrame asSeenBy) {
        Vector3 prevScale = this.getScaledSpace(asSeenBy);
        Vector3 deltaScale = Vector3.divide(scale, prevScale);
        this.scaleSpaceRightNow(deltaScale, asSeenBy);
    }

    public void moveRightNow(Vector3d vector, ReferenceFrame asSeenBy, boolean isScaledBySize) {
        edu.cmu.cs.stage3.alice.scenegraph.ReferenceFrame sgAsSeenBy = asSeenBy != null ? asSeenBy.getSceneGraphReferenceFrame() : null;
        if (isScaledBySize) {
            vector = Vector3.multiply(vector, this.getSize());
        }
        this.m_sgTransformable.translate(vector, sgAsSeenBy);
        this.syncLocalTransformationPropertyToSceneGraph();
    }

    public void rotateRightNow(Vector3d axis, double amount, ReferenceFrame asSeenBy) {
        edu.cmu.cs.stage3.alice.scenegraph.ReferenceFrame sgAsSeenBy = asSeenBy != null ? asSeenBy.getSceneGraphReferenceFrame() : null;
        this.m_sgTransformable.rotate(axis, amount / 0.15915494309189535, sgAsSeenBy);
        this.syncLocalTransformationPropertyToSceneGraph();
    }

    public void turnRightNow(Direction direction, double amount, ReferenceFrame asSeenBy) {
        this.rotateRightNow(direction.getTurnAxis(), amount, asSeenBy);
    }

    public void rollRightNow(Direction direction, double amount, ReferenceFrame asSeenBy) {
        this.rotateRightNow(direction.getRollAxis(), amount, asSeenBy);
    }

    public void standUpRightNow(ReferenceFrame asSeenBy) {
        this.setOrientationRightNow(this.calculateStandUp(asSeenBy), asSeenBy);
    }

    public void setPointOfViewRightNow(Matrix4d m, ReferenceFrame asSeenBy) {
        this.setTransformationRightNow(m, asSeenBy);
    }

    public void setPointOfViewRightNow(Matrix4d m) {
        this.setPointOfViewRightNow(m, null);
    }

    public void setPointOfViewRightNow(ReferenceFrame asSeenBy) {
        this.setPointOfViewRightNow(MathUtilities.createIdentityMatrix4d(), asSeenBy);
    }

    public void setPositionRightNow(Vector3d position) {
        this.setPositionRightNow(position, null);
    }

    public void setPositionRightNow(double[] xyz) {
        this.setPositionRightNow(new Vector3d(xyz), null);
    }

    public void setPositionRightNow(double x, double y, double z, ReferenceFrame asSeenBy) {
        this.setPositionRightNow(new Vector3d(x, y, z), asSeenBy);
    }

    public void setPositionRightNow(double x, double y, double z) {
        this.setPositionRightNow(x, y, z, null);
    }

    public void setPositionRightNow(ReferenceFrame asSeenBy) {
        this.setPositionRightNow(Vector3.ZERO, asSeenBy);
    }

    public void setOrientationRightNow(Matrix3d axes) {
        this.setOrientationRightNow(axes, null);
    }

    public void setOrientationRightNow(ReferenceFrame asSeenBy) {
        this.setOrientationRightNow(MathUtilities.getIdentityMatrix3d(), asSeenBy);
    }

    public void setOrientationRightNow(Quaternion quaternion) {
        this.setOrientationRightNow(quaternion, null);
    }

    public void setOrientationRightNow(Vector3d[] orientation) {
        this.setOrientationRightNow(orientation, null);
    }

    public void setOrientationRightNow(Vector3d forward, Vector3d upGuide) {
        this.setOrientationRightNow(forward, upGuide, null);
    }

    public void setOrientationRightNow(Vector3d forward) {
        this.setOrientationRightNow(forward, null);
    }

    public void setOrientationRightNow(double[][] orientation, ReferenceFrame asSeenBy) {
        this.setOrientationRightNow(orientation[0], orientation[1], asSeenBy);
    }

    public void setOrientationRightNow(double[][] orientation) {
        this.setOrientationRightNow(orientation, null);
    }

    public void setOrientationRightNow(double[] forwardXYZ, double[] upGuideXYZ, ReferenceFrame asSeenBy) {
        this.setOrientationRightNow(new Vector3d(forwardXYZ), new Vector3d(upGuideXYZ), asSeenBy);
    }

    public void setOrientationRightNow(double[] forwardXYZ, double[] upGuideXYZ) {
        this.setOrientationRightNow(forwardXYZ, upGuideXYZ, null);
    }

    public void setOrientationRightNow(double[] forwardXYZ) {
        this.setOrientationRightNow(forwardXYZ, null);
    }

    public void setOrientationRightNow(double forwardX, double forwardY, double forwardZ, double upGuideX, double upGuideY, double upGuideZ) {
        this.setOrientationRightNow(new Vector3d(forwardX, forwardY, forwardZ), new Vector3d(upGuideX, upGuideY, upGuideZ));
    }

    public void setOrientationRightNow(double forwardX, double forwardY, double forwardZ) {
        this.setOrientationRightNow(new Vector3d(forwardX, forwardY, forwardZ), null);
    }

    public void setOrientationRightNow(EulerAngles eulerAngles) {
        this.setOrientationRightNow(eulerAngles, null);
    }

    public void pointAtRightNow(ReferenceFrame target, Vector3d offset, Vector3d upGuide, ReferenceFrame asSeenBy) {
        this.pointAtRightNow(target, offset, upGuide, asSeenBy, false);
    }

    public void pointAtRightNow(ReferenceFrame target, Vector3d offset, Vector3d upGuide) {
        this.pointAtRightNow(target, offset, upGuide, null);
    }

    public void pointAtRightNow(ReferenceFrame target, Vector3d offset) {
        this.pointAtRightNow(target, offset, null);
    }

    public void pointAtRightNow(ReferenceFrame target) {
        Vector3d offset = null;
        this.pointAtRightNow(target, offset);
    }

    public void pointAtRightNow(ReferenceFrame target, double[] offsetXYZ, double[] upGuideXYZ, ReferenceFrame asSeenBy) {
        this.pointAtRightNow(target, new Vector3d(offsetXYZ), new Vector3d(upGuideXYZ), asSeenBy);
    }

    public void pointAtRightNow(ReferenceFrame target, double[] offsetXYZ, double[] upGuideXYZ) {
        this.pointAtRightNow(target, offsetXYZ, upGuideXYZ, null);
    }

    public void pointAtRightNow(ReferenceFrame target, double[] offsetXYZ) {
        this.pointAtRightNow(target, offsetXYZ, null);
    }

    public void resizeRightNow(Vector3d scale, ReferenceFrame asSeenBy) {
        this.resizeRightNow(scale, asSeenBy, HowMuch.INSTANCE_AND_PARTS);
    }

    public void resizeRightNow(Vector3d scale) {
        this.resizeRightNow(scale, null);
    }

    public void resizeRightNow(Dimension dimension, double amount, boolean likeRubber, ReferenceFrame asSeenBy, HowMuch howMuch) {
        this.resizeRightNow(Transformable.calculateResizeScale(dimension, amount, likeRubber), asSeenBy, howMuch);
    }

    public void resizeRightNow(Dimension dimension, double amount, boolean likeRubber, ReferenceFrame asSeenBy) {
        this.resizeRightNow(dimension, amount, likeRubber, asSeenBy, HowMuch.INSTANCE_AND_PARTS);
    }

    public void resizeRightNow(Dimension dimension, double amount, boolean likeRubber) {
        this.resizeRightNow(dimension, amount, likeRubber, null);
    }

    public void resizeRightNow(Dimension dimension, double amount) {
        this.resizeRightNow(dimension, amount, false);
    }

    public void resizeRightNow(double x, double y, double z, ReferenceFrame asSeenBy) {
        this.resizeRightNow(new Vector3d(x, y, z), asSeenBy);
    }

    public void resizeRightNow(double x, double y, double z) {
        this.resizeRightNow(x, y, z, null);
    }

    public void resizeRightNow(double s) {
        this.resizeRightNow(s, s, s);
    }

    public void setSizeRightNow(Vector3d xyz) {
        this.setSizeRightNow(xyz, null);
    }

    public void setSizeRightNow(double x, double y, double z, ReferenceFrame asSeenBy) {
        this.setSizeRightNow(new Vector3d(x, y, z), asSeenBy);
    }

    public void setSizeRightNow(double x, double y, double z) {
        this.setSizeRightNow(x, y, z, null);
    }

    public void setSizeRightNow(double[] xyz, ReferenceFrame asSeenBy) {
        this.setSizeRightNow(xyz[0], xyz[1], xyz[2], asSeenBy);
    }

    public void setScaledSpaceRightNow(Vector3d xyz) {
        this.setScaledSpaceRightNow(xyz, null);
    }

    public void setScaledSpaceRightNow(double x, double y, double z, ReferenceFrame asSeenBy) {
        this.setScaledSpaceRightNow(new Vector3d(x, y, z), asSeenBy);
    }

    public void setScaledSpaceRightNow(double x, double y, double z) {
        this.setScaledSpaceRightNow(x, y, z, null);
    }

    public void setSizeRightNow(double[] xyz) {
        this.setSizeRightNow(xyz[0], xyz[1], xyz[2]);
    }

    public void moveRightNow(Direction direction, double amount, ReferenceFrame asSeenBy, boolean isScaledBySize) {
        this.moveRightNow(Vector3.multiply(direction.getMoveAxis(), amount), asSeenBy, isScaledBySize);
    }

    public void moveRightNow(Direction direction, double amount, ReferenceFrame asSeenBy) {
        this.moveRightNow(direction, amount, asSeenBy, false);
    }

    public void moveRightNow(Direction direction, double amount) {
        this.moveRightNow(direction, amount, null);
    }

    public void moveRightNow(Vector3d vector, ReferenceFrame asSeenBy) {
        this.moveRightNow(vector, asSeenBy, false);
    }

    public void moveRightNow(double[] xyz, ReferenceFrame asSeenBy) {
        this.moveRightNow(new Vector3d(xyz), asSeenBy);
    }

    public void moveRightNow(Vector3d vector) {
        this.moveRightNow(vector, null);
    }

    public void moveRightNow(double[] xyz) {
        this.moveRightNow(xyz, null);
    }

    public void moveRightNow(double x, double y, double z, ReferenceFrame asSeenBy) {
        this.moveRightNow(new Vector3d(x, y, z), asSeenBy);
    }

    public void moveRightNow(double x, double y, double z) {
        this.moveRightNow(x, y, z, null);
    }

    public void rotateRightNow(Vector3d axis, double amount) {
        this.rotateRightNow(axis, amount, null);
    }

    public void turnRightNow(Direction direction, double amount) {
        this.turnRightNow(direction, amount, null);
    }

    public void rollRightNow(Direction direction, double amount) {
        this.rollRightNow(direction, amount, null);
    }

    public void standUpRightNow() {
        this.standUpRightNow(null);
    }

    protected PickInfo pick(Vector3d vector, double planeMinX, double planeMinY, double planeMaxX, double planeMaxY, double nearClippingPlaneDistance, double farClippingPlaneDistance, boolean isSubElementRequired, boolean isOnlyFrontMostRequired) {
        RenderTarget renderTarget = (RenderTarget)this.getWorld().getDescendants(RenderTarget.class)[0];
        return renderTarget.getRenderer().pick(((Camera)this).getSceneGraphCamera(), vector, planeMinX, planeMinY, planeMaxX, planeMaxY, nearClippingPlaneDistance, farClippingPlaneDistance, isSubElementRequired, isOnlyFrontMostRequired);
    }

    public Vector3d preventPassingThroughOtherObjects(Vector3d vector, double cushion) {
        if (vector.z > 0.0 && this instanceof Camera) {
            Vector3d localPos;
            Camera camera = (Camera)this;
            java.awt.Dimension size = camera.renderTarget.getRenderTargetValue().getAWTComponent().getSize();
            PickInfo pickInfo = camera.pick(size.width / 2, size.height / 2);
            cushion += camera.nearClippingPlaneDistance.doubleValue();
            if (pickInfo.getCount() > 0 && (localPos = pickInfo.getLocalPositionAt(0)) != null) {
                Model model = (Model)pickInfo.getVisualAt(0).getBonus();
                Vector3d pos = model.transformTo(localPos, (ReferenceFrame)this);
                if (pos.z < vector.z + cushion) {
                    int subElement = pickInfo.getSubElementAt(0);
                    IndexedTriangleArray sgITA = (IndexedTriangleArray)model.geometry.getGeometryValue().getSceneGraphGeometry();
                    int index = sgITA.getIndices()[subElement * 3];
                    Vertex3d vertex = sgITA.getVertices()[index];
                    Vector4d transformedNormal = model.transformTo(new Vector4((Tuple3d)vertex.normal, 0.0), (ReferenceFrame)this);
                    Vector3d normal = new Vector3d(transformedNormal.x, transformedNormal.y, transformedNormal.z);
                    Vector3d up = new Vector3d();
                    Vector3d slide = new Vector3d();
                    up.y = 1.0;
                    normal.normalize();
                    slide.cross(normal, up);
                    slide.scale(vector.length() * 0.25);
                    if (normal.x < 0.0) {
                        slide.x = -slide.x;
                        slide.z = -slide.z;
                    }
                    vector = slide;
                }
            }
        }
        return vector;
    }

    public void setPivot(ReferenceFrame pivot) {
        this.m_sgTransformable.setPivot(pivot.getSceneGraphReferenceFrame());
        this.syncLocalTransformationPropertyToSceneGraph();
        int i = 0;
        while (i < this.m_sgTransformable.getChildCount()) {
            Geometry sgGeometry;
            Component sgChild = this.m_sgTransformable.getChildAt(i);
            if (sgChild instanceof edu.cmu.cs.stage3.alice.scenegraph.Transformable) {
                if (sgChild.getBonus() instanceof Transformable) {
                    ((Transformable)sgChild.getBonus()).syncLocalTransformationPropertyToSceneGraph();
                }
            } else if (sgChild instanceof Visual && (sgGeometry = ((Visual)sgChild).getGeometry()) instanceof IndexedTriangleArray) {
                Transformable.HACK_syncPropertyToSceneGraph("vertices", (IndexedTriangleArray)sgGeometry);
            }
            ++i;
        }
        this.m_pivotDecorator.markDirty();
    }
}

