/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core;

import edu.cmu.cs.stage3.alice.core.event.ScheduleEvent;
import edu.cmu.cs.stage3.alice.core.event.ScheduleListener;
import java.util.Vector;

public class Scheduler
implements Runnable {
    private static long s_startTime = System.currentTimeMillis();
    private Vector m_scheduleListeners = new Vector();
    private ScheduleListener[] m_scheduleListenerArray = null;
    private double m_falseDT = Double.NaN;
    private double m_prevTime = Double.NaN;
    private double m_time = Double.NaN;
    private ScheduleEvent m_scheduleEvent = new ScheduleEvent(this, 0.0);

    public void addScheduleListener(ScheduleListener scheduleListener) {
        if (!this.m_scheduleListeners.contains(scheduleListener)) {
            this.m_scheduleListeners.addElement(scheduleListener);
            this.m_scheduleListenerArray = null;
        }
    }

    public void removeScheduleListener(ScheduleListener scheduleListener) {
        this.m_scheduleListeners.removeElement(scheduleListener);
        this.m_scheduleListenerArray = null;
    }

    public ScheduleListener[] getScheduleListeners() {
        if (this.m_scheduleListenerArray == null) {
            this.m_scheduleListenerArray = new ScheduleListener[this.m_scheduleListeners.size()];
            this.m_scheduleListeners.copyInto(this.m_scheduleListenerArray);
        }
        return this.m_scheduleListenerArray;
    }

    public double getFalseDT() {
        return this.m_falseDT;
    }

    public void setFalseDT(double falseDT) {
        this.m_falseDT = falseDT;
    }

    public double getTime() {
        return this.m_time;
    }

    public double getDT() {
        if (Double.isNaN(this.m_time) || Double.isNaN(this.m_prevTime)) {
            return 0.0;
        }
        return this.m_time - this.m_prevTime;
    }

    protected void schedule(ScheduleListener scheduleListener, ScheduleEvent scheduleEvent) {
        scheduleListener.scheduled(scheduleEvent);
    }

    private void updateTime() {
        this.m_time = (double)(System.currentTimeMillis() - s_startTime) * 0.001;
        if (!Double.isNaN(this.m_falseDT) && !Double.isNaN(this.m_prevTime)) {
            this.m_time = this.m_prevTime + this.m_falseDT;
        }
    }

    public void HACK_updateTime() {
        this.updateTime();
        this.m_prevTime = this.m_time;
    }

    @Override
    public synchronized void run() {
        this.updateTime();
        this.m_scheduleEvent.setTime(this.m_time);
        ScheduleListener[] sls = this.getScheduleListeners();
        int i = 0;
        while (i < sls.length) {
            try {
                this.schedule(sls[i], this.m_scheduleEvent);
            }
            catch (RuntimeException re) {
                this.removeScheduleListener(sls[i]);
                throw re;
            }
            ++i;
        }
        this.m_prevTime = this.m_time;
    }
}

