/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core;

import edu.cmu.cs.stage3.alice.core.Behavior;
import edu.cmu.cs.stage3.alice.core.Code;
import edu.cmu.cs.stage3.alice.core.ExceptionWrapper;
import edu.cmu.cs.stage3.alice.core.Sandbox;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.property.NumberProperty;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Stack;

public abstract class Response
extends Code {
    public final NumberProperty duration = new NumberProperty(this, "duration", this.getDefaultDuration());

    protected Number getDefaultDuration() {
        return new Double(1.0);
    }

    protected Class getRuntimeResponseClass() {
        Class<?> cls = this.getClass();
        Class<?>[] declaredClasses = cls.getDeclaredClasses();
        int i = 0;
        while (i < declaredClasses.length) {
            if (RuntimeResponse.class.isAssignableFrom(declaredClasses[i])) {
                return declaredClasses[i];
            }
            ++i;
        }
        return null;
    }

    public RuntimeResponse manufactureRuntimeResponse() {
        Constructor<?>[] constructors;
        Class runtimeResponseClass = this.getRuntimeResponseClass();
        if (runtimeResponseClass != null && (constructors = runtimeResponseClass.getConstructors()).length > 0) {
            try {
                Object[] initargs = new Object[]{this};
                RuntimeResponse runtimeResponse = (RuntimeResponse)constructors[0].newInstance(initargs);
                return runtimeResponse;
            }
            catch (IllegalAccessException iae) {
                throw new ExceptionWrapper(iae, null);
            }
            catch (InstantiationException ie) {
                throw new ExceptionWrapper(ie, null);
            }
            catch (InvocationTargetException ite) {
                throw new ExceptionWrapper(ite, null);
            }
        }
        return null;
    }

    public abstract class RuntimeResponse {
        private boolean HACK_m_isMarkedForRemoval = false;
        private boolean m_isActive = false;
        private double m_t0 = Double.NaN;
        private double m_tPrev = Double.NaN;
        private double m_duration = Double.NaN;
        private double m_dt = Double.NaN;

        public void HACK_markForRemoval() {
            this.HACK_m_isMarkedForRemoval = true;
        }

        public boolean HACK_isMarkedForRemoval() {
            return this.HACK_m_isMarkedForRemoval;
        }

        public boolean isActive() {
            return this.m_isActive;
        }

        protected double getDuration() {
            return this.m_duration;
        }

        protected void setDuration(double duration) {
            this.m_duration = duration;
        }

        protected double getTimeElapsed(double t) {
            return t - this.m_t0;
        }

        protected double getDT() {
            return this.m_dt;
        }

        public double getTimeRemaining(double t) {
            return this.m_duration - this.getTimeElapsed(t);
        }

        public void prologue(double t) {
            this.m_t0 = t;
            this.m_tPrev = t;
            this.m_dt = 0.0;
            this.m_duration = Response.this.duration.doubleValue(Double.NaN);
            this.m_isActive = true;
        }

        public void update(double t) {
            this.m_dt = t - this.m_tPrev;
            this.m_tPrev = t;
        }

        public void epilogue(double t) {
            this.m_isActive = false;
        }

        public void stop(double t) {
            if (this.isActive()) {
                this.epilogue(t);
            }
        }

        public void finish() {
            this.m_t0 = Double.NEGATIVE_INFINITY;
        }

        protected Behavior getCurrentBehavior() {
            Sandbox sandbox;
            World world = Response.this.getWorld();
            if (world != null && (sandbox = world.getCurrentSandbox()) != null) {
                return sandbox.getCurrentBehavior();
            }
            return null;
        }

        protected Stack getCurrentStack() {
            Behavior behavior = this.getCurrentBehavior();
            if (behavior != null) {
                return behavior.getCurrentStack();
            }
            return null;
        }
    }
}

