/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core;

import edu.cmu.cs.stage3.alice.core.Camera;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.camera.OrthographicCamera;
import edu.cmu.cs.stage3.alice.core.camera.PerspectiveCamera;
import edu.cmu.cs.stage3.alice.core.camera.SymmetricPerspectiveCamera;
import edu.cmu.cs.stage3.alice.core.property.ObjectProperty;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.OnscreenRenderTarget;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.PickInfo;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.RenderTargetFactory;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.Renderer;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.event.RenderTargetListener;
import edu.cmu.cs.stage3.math.Vector3;
import edu.cmu.cs.stage3.math.Vector4;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Matrix4d;

public class RenderTarget
extends Element {
    public final ObjectProperty requiredCapabilities = new ObjectProperty(this, "requiredCapabilities", null, Long.class);
    private OnscreenRenderTarget m_onscreenRenderTarget = null;
    private Component m_awtComponent;
    private Vector m_cameras = new Vector();
    private Camera[] m_cameraArray = null;
    private RenderTargetFactory m_renderTargetFactory;
    private static Dictionary s_componentMap = new Hashtable();
    private static Dictionary s_eventMap = new Hashtable();

    public RenderTarget() {
        this.requiredCapabilities.deprecate();
    }

    @Override
    protected void finalize() throws Throwable {
        if (this.m_awtComponent != null) {
            s_componentMap.remove(this.m_awtComponent);
        }
        super.finalize();
    }

    @Override
    protected void internalRelease(int pass) {
        switch (pass) {
            case 1: {
                Enumeration enum0 = this.m_cameras.elements();
                while (enum0.hasMoreElements()) {
                    Camera camera = (Camera)enum0.nextElement();
                    if (this.m_onscreenRenderTarget == null) continue;
                    this.m_onscreenRenderTarget.removeCamera(camera.getSceneGraphCamera());
                }
                break;
            }
            case 2: {
                if (this.m_onscreenRenderTarget == null) break;
                if (this.m_renderTargetFactory != null) {
                    this.m_renderTargetFactory.releaseOnscreenRenderTarget(this.m_onscreenRenderTarget);
                }
                this.m_onscreenRenderTarget = null;
            }
        }
        super.internalRelease(pass);
    }

    public PickInfo pick(int x, int y, boolean isSubElementRequired, boolean isOnlyFrontMostRequired) {
        if (this.m_onscreenRenderTarget != null) {
            return this.m_onscreenRenderTarget.pick(x, y, isSubElementRequired, isOnlyFrontMostRequired);
        }
        throw new NullPointerException("internal m_onscreenRenderTarget is null");
    }

    public static PickInfo pick(MouseEvent mouseEvent) {
        RenderTarget renderTarget;
        PickInfo pickInfo = (PickInfo)s_eventMap.get(mouseEvent);
        if (pickInfo == null && (pickInfo = (renderTarget = (RenderTarget)s_componentMap.get(mouseEvent.getComponent())).pick(mouseEvent.getX(), mouseEvent.getY(), false, true)) != null) {
            s_eventMap.put(mouseEvent, pickInfo);
        }
        return pickInfo;
    }

    public void commit(RenderTargetFactory renderTargetFactory) {
        this.m_renderTargetFactory = renderTargetFactory;
        this.m_onscreenRenderTarget = renderTargetFactory.createOnscreenRenderTarget();
        this.m_awtComponent = this.m_onscreenRenderTarget.getAWTComponent();
        s_componentMap.put(this.m_awtComponent, this);
        Enumeration enum0 = this.m_cameras.elements();
        while (enum0.hasMoreElements()) {
            Camera camera = (Camera)enum0.nextElement();
            this.m_onscreenRenderTarget.addCamera(camera.getSceneGraphCamera());
            this.m_onscreenRenderTarget.setIsLetterboxedAsOpposedToDistorted(camera.getSceneGraphCamera(), camera.isLetterboxedAsOpposedToDistorted.booleanValue());
        }
    }

    public Renderer getRenderer() {
        return this.m_onscreenRenderTarget.getRenderer();
    }

    public OnscreenRenderTarget getInternal() {
        return this.m_onscreenRenderTarget;
    }

    public void addCamera(Camera camera) {
        if (!this.m_cameras.contains(camera)) {
            this.m_cameras.addElement(camera);
            this.m_cameraArray = null;
            if (this.m_onscreenRenderTarget != null) {
                this.m_onscreenRenderTarget.addCamera(camera.getSceneGraphCamera());
            }
        }
    }

    public void removeCamera(Camera camera) {
        this.m_cameras.removeElement(camera);
        this.m_cameraArray = null;
        if (this.m_onscreenRenderTarget != null) {
            this.m_onscreenRenderTarget.removeCamera(camera.getSceneGraphCamera());
        }
    }

    public Camera[] getCameras() {
        if (this.m_cameraArray == null) {
            this.m_cameraArray = new Camera[this.m_cameras.size()];
            this.m_cameras.copyInto(this.m_cameraArray);
        }
        return this.m_cameraArray;
    }

    public double[] getActualPlane(OrthographicCamera orthographicCamera) {
        if (this.m_onscreenRenderTarget != null) {
            return this.m_onscreenRenderTarget.getActualPlane(orthographicCamera.getSceneGraphOrthographicCamera());
        }
        return null;
    }

    public double[] getActualPlane(PerspectiveCamera perspectiveCamera) {
        if (this.m_onscreenRenderTarget != null) {
            return this.m_onscreenRenderTarget.getActualPlane(perspectiveCamera.getSceneGraphPerspectiveCamera());
        }
        return null;
    }

    public double getActualHorizontalViewingAngle(SymmetricPerspectiveCamera symmetricPerspectiveCamera) {
        if (this.m_onscreenRenderTarget != null) {
            return this.m_onscreenRenderTarget.getActualVerticalViewingAngle(symmetricPerspectiveCamera.getSceneGraphSymmetricPerspectiveCamera());
        }
        return Double.NaN;
    }

    public double getActualVerticalViewingAngle(SymmetricPerspectiveCamera symmetricPerspectiveCamera) {
        if (this.m_onscreenRenderTarget != null) {
            return this.m_onscreenRenderTarget.getActualVerticalViewingAngle(symmetricPerspectiveCamera.getSceneGraphSymmetricPerspectiveCamera());
        }
        return Double.NaN;
    }

    public Matrix4d getProjectionMatrix(Camera camera) {
        if (this.m_onscreenRenderTarget != null) {
            return this.m_onscreenRenderTarget.getProjectionMatrix(camera.getSceneGraphCamera());
        }
        return null;
    }

    public Rectangle getActualViewport(Camera camera) {
        if (this.m_onscreenRenderTarget != null) {
            return this.m_onscreenRenderTarget.getActualViewport(camera.getSceneGraphCamera());
        }
        return null;
    }

    public Rectangle getViewport(Camera camera) {
        if (this.m_onscreenRenderTarget != null) {
            return this.m_onscreenRenderTarget.getViewport(camera.getSceneGraphCamera());
        }
        return null;
    }

    public void setViewport(Camera camera, Rectangle rectangle) {
        if (this.m_onscreenRenderTarget != null) {
            this.m_onscreenRenderTarget.setViewport(camera.getSceneGraphCamera(), rectangle);
        }
    }

    public Vector4 project(Vector3 point, Camera camera) {
        if (this.m_onscreenRenderTarget != null) {
            Matrix4d projection = this.m_onscreenRenderTarget.getProjectionMatrix(camera.getSceneGraphCamera());
            Vector4 xyzw = new Vector4(point.x, point.y, point.z, 1.0);
            return Vector4.multiply(xyzw, projection);
        }
        return null;
    }

    public Component getAWTComponent() {
        return this.m_awtComponent;
    }

    public Image getOffscreenImage() {
        if (this.m_onscreenRenderTarget != null) {
            return this.m_onscreenRenderTarget.getOffscreenImage();
        }
        return null;
    }

    public Graphics getOffscreenGraphics() {
        if (this.m_onscreenRenderTarget != null) {
            return this.m_onscreenRenderTarget.getOffscreenGraphics();
        }
        return null;
    }

    public void addRenderTargetListener(RenderTargetListener renderTargetListener) {
        if (this.m_onscreenRenderTarget == null) {
            throw new NullPointerException("internal m_onscreenRenderTarget is null");
        }
        this.m_onscreenRenderTarget.addRenderTargetListener(renderTargetListener);
    }

    public void removeRenderTargetListener(RenderTargetListener renderTargetListener) {
        if (this.m_onscreenRenderTarget == null) {
            throw new NullPointerException("internal m_onscreenRenderTarget is null");
        }
        this.m_onscreenRenderTarget.removeRenderTargetListener(renderTargetListener);
    }

    public RenderTargetListener[] getRenderTargetListeners() {
        if (this.m_onscreenRenderTarget != null) {
            return this.m_onscreenRenderTarget.getRenderTargetListeners();
        }
        throw new NullPointerException("internal m_onscreenRenderTarget is null");
    }

    public void addKeyListener(KeyListener keyListener) {
        if (this.m_awtComponent == null) {
            throw new NullPointerException("internal m_awtComponent is null");
        }
        this.m_awtComponent.addKeyListener(keyListener);
    }

    public void removeKeyListener(KeyListener keyListener) {
        if (this.m_awtComponent == null) {
            throw new NullPointerException("internal m_awtComponent is null");
        }
        this.m_awtComponent.removeKeyListener(keyListener);
    }

    public void addMouseListener(MouseListener mouseListener) {
        if (this.m_awtComponent == null) {
            throw new NullPointerException("internal m_awtComponent is null");
        }
        this.m_awtComponent.addMouseListener(mouseListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        if (this.m_awtComponent == null) {
            throw new NullPointerException("internal m_awtComponent is null");
        }
        this.m_awtComponent.removeMouseListener(mouseListener);
    }

    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        if (this.m_awtComponent == null) {
            throw new NullPointerException("internal m_awtComponent is null");
        }
        this.m_awtComponent.addMouseMotionListener(mouseMotionListener);
    }

    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        if (this.m_awtComponent == null) {
            throw new NullPointerException("internal m_awtComponent is null");
        }
        this.m_awtComponent.removeMouseMotionListener(mouseMotionListener);
    }

    @Override
    protected void started(World world, double time) {
        super.started(world, time);
        this.m_onscreenRenderTarget.addRenderTargetListener(world.getBubbleManager());
        Component awtComponent = this.m_onscreenRenderTarget.getAWTComponent();
        if (awtComponent != null) {
            awtComponent.requestFocus();
        }
    }

    @Override
    protected void stopped(World world, double time) {
        super.stopped(world, time);
        this.m_onscreenRenderTarget.removeRenderTargetListener(world.getBubbleManager());
    }
}

