/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core;

import edu.cmu.cs.stage3.alice.core.Camera;
import edu.cmu.cs.stage3.alice.core.Dimension;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.RenderTarget;
import edu.cmu.cs.stage3.alice.core.Sandbox;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.decorator.BoundingBoxDecorator;
import edu.cmu.cs.stage3.alice.core.decorator.BoundingSphereDecorator;
import edu.cmu.cs.stage3.alice.core.geometry.IndexedTriangleArray;
import edu.cmu.cs.stage3.alice.core.property.BooleanProperty;
import edu.cmu.cs.stage3.alice.scenegraph.Container;
import edu.cmu.cs.stage3.alice.scenegraph.event.AbsoluteTransformationListener;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.math.Box;
import edu.cmu.cs.stage3.math.EulerAngles;
import edu.cmu.cs.stage3.math.Matrix33;
import edu.cmu.cs.stage3.math.Matrix44;
import edu.cmu.cs.stage3.math.Quaternion;
import edu.cmu.cs.stage3.math.Sphere;
import edu.cmu.cs.stage3.math.Vector3;
import edu.cmu.cs.stage3.util.HowMuch;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;

public abstract class ReferenceFrame
extends Sandbox {
    public static final ReferenceFrame ABSOLUTE = new World();
    public final BooleanProperty eventsStopAscending = new BooleanProperty(this, "eventsStopAscending", null);
    public final BooleanProperty isBoundingBoxShowing = new BooleanProperty(this, "isBoundingBoxShowing", Boolean.FALSE);
    public final BooleanProperty isBoundingSphereShowing = new BooleanProperty(this, "isBoundingSphereShowing", Boolean.FALSE);
    private BoundingBoxDecorator m_boundingBoxDecorator = new BoundingBoxDecorator();
    private BoundingSphereDecorator m_boundingSphereDecorator = new BoundingSphereDecorator();

    public abstract edu.cmu.cs.stage3.alice.scenegraph.ReferenceFrame getSceneGraphReferenceFrame();

    public abstract Container getSceneGraphContainer();

    public abstract void addAbsoluteTransformationListener(AbsoluteTransformationListener var1);

    public abstract void removeAbsoluteTransformationListener(AbsoluteTransformationListener var1);

    public ReferenceFrame() {
        this.m_boundingBoxDecorator.setReferenceFrame(this);
        this.m_boundingSphereDecorator.setReferenceFrame(this);
    }

    @Override
    protected void internalRelease(int pass) {
        switch (pass) {
            case 1: {
                this.m_boundingBoxDecorator.internalRelease(1);
                this.m_boundingSphereDecorator.internalRelease(1);
                break;
            }
            case 2: {
                this.m_boundingBoxDecorator.internalRelease(2);
                this.m_boundingBoxDecorator = null;
                this.m_boundingSphereDecorator.internalRelease(2);
                this.m_boundingSphereDecorator = null;
            }
        }
        super.internalRelease(pass);
    }

    public boolean doEventsStopAscending() {
        return this.eventsStopAscending.booleanValue(this.isFirstClass.booleanValue());
    }

    private void isBoundingBoxShowingValueChanged(Boolean value) {
        this.m_boundingBoxDecorator.setIsShowing(value);
    }

    private void isBoundingSphereShowingValueChanged(Boolean value) {
        this.m_boundingSphereDecorator.setIsShowing(value);
    }

    @Override
    protected void propertyChanged(Property property, Object value) {
        if (property == this.isBoundingBoxShowing) {
            this.isBoundingBoxShowingValueChanged((Boolean)value);
        } else if (property == this.isBoundingSphereShowing) {
            this.isBoundingSphereShowingValueChanged((Boolean)value);
        } else {
            super.propertyChanged(property, value);
        }
    }

    public Matrix44 getAbsoluteTransformation() {
        return new Matrix44(this.getSceneGraphReferenceFrame().getAbsoluteTransformation());
    }

    public Matrix44 getTransformation(Vector3d offset, ReferenceFrame asSeenBy) {
        if (asSeenBy == this && offset == null) {
            return new Matrix44();
        }
        edu.cmu.cs.stage3.alice.scenegraph.ReferenceFrame sgAsSeenBy = asSeenBy != null ? asSeenBy.getSceneGraphReferenceFrame() : null;
        return this.getSceneGraphReferenceFrame().getTransformation(offset, sgAsSeenBy);
    }

    public Matrix44 getTransformation(ReferenceFrame asSeenBy) {
        return this.getTransformation(null, asSeenBy);
    }

    public Vector3 getPosition(Vector3d offset, ReferenceFrame asSeenBy) {
        return this.getTransformation(offset, asSeenBy).getPosition();
    }

    public Vector3 getPosition(ReferenceFrame asSeenBy) {
        return this.getPosition(null, asSeenBy);
    }

    public Matrix33 getOrientationAsAxes(ReferenceFrame asSeenBy) {
        return this.getTransformation(asSeenBy).getAxes();
    }

    public Vector3[] getOrientationAsForwardAndUpGuide(ReferenceFrame asSeenBy) {
        Matrix33 axes = this.getOrientationAsAxes(asSeenBy);
        Vector3[] orientation = new Vector3[]{axes.getRow(2), axes.getRow(1)};
        return orientation;
    }

    public Quaternion getOrientationAsQuaternion(ReferenceFrame asSeenBy) {
        return this.getOrientationAsAxes(asSeenBy).getQuaternion();
    }

    public EulerAngles getOrientationAsEulerAngles(ReferenceFrame asSeenBy) {
        return EulerAngles.radiansToRevolutions(this.getOrientationAsAxes(asSeenBy).getEulerAngles());
    }

    public Vector3 getScaledSpace(ReferenceFrame asSeenBy) {
        return this.getOrientationAsAxes(asSeenBy).getScaledSpace();
    }

    public double getDistanceTo(ReferenceFrame other) {
        return Math.sqrt(this.getDistanceSquaredTo(other));
    }

    public double getDistanceSquaredTo(ReferenceFrame other) {
        Vector3 pos = this.getPosition(other);
        return pos.getLengthSquared();
    }

    public Vector4d transformTo(Vector4d xyzw, ReferenceFrame to) {
        return this.getSceneGraphReferenceFrame().transformTo(xyzw, to.getSceneGraphReferenceFrame());
    }

    public Vector3d transformTo(Vector3d xyz, ReferenceFrame to) {
        return this.getSceneGraphReferenceFrame().transformTo(xyz, to.getSceneGraphReferenceFrame());
    }

    public Vector3d transformToViewport(Vector3 xyz, Camera camera) {
        Vector3d xyzInCamera = this.transformTo(xyz, (ReferenceFrame)camera);
        RenderTarget renderTarget = camera.renderTarget.getRenderTargetValue();
        return renderTarget.getInternal().transformFromCameraToViewport(xyzInCamera, camera.getSceneGraphCamera());
    }

    public Matrix44 getTransformation() {
        return this.getTransformation(null);
    }

    public Matrix44 getPointOfView(ReferenceFrame asSeenBy) {
        return this.getTransformation(asSeenBy);
    }

    public Matrix44 getPointOfView() {
        return this.getPointOfView(null);
    }

    public Vector3 getPosition() {
        return this.getPosition(null);
    }

    public Matrix33 getOrientationAsAxes() {
        return this.getOrientationAsAxes(null);
    }

    public Vector3[] getOrientationAsForwardAndUpGuide() {
        return this.getOrientationAsForwardAndUpGuide(null);
    }

    public Quaternion getOrientationAsQuaternion() {
        return this.getOrientationAsQuaternion(null);
    }

    public EulerAngles getOrientationAsEulerAngles() {
        return this.getOrientationAsEulerAngles(null);
    }

    public Vector3 getScaledSpace() {
        return this.getScaledSpace(null);
    }

    public Vector3d transformTo(double[] xyz, ReferenceFrame to) {
        return this.transformTo(new Vector3(xyz), to);
    }

    public Vector3d transformTo(double x, double y, double z, ReferenceFrame to) {
        return this.transformTo(new Vector3(x, y, z), to);
    }

    public Vector3d transformToViewport(double[] xyz, Camera camera) {
        return this.transformToViewport(new Vector3(xyz), camera);
    }

    public Vector3d transformToViewport(double x, double y, double z, Camera camera) {
        return this.transformToViewport(new Vector3(x, y, z), camera);
    }

    protected void updateBoundingSphere(Sphere sphere, ReferenceFrame asSeenBy, HowMuch howMuch, boolean ignoreHidden) {
        if (howMuch.getDescend()) {
            int i = 0;
            while (i < this.getChildCount()) {
                Element child = this.getChildAt(i);
                if (!(!(child instanceof ReferenceFrame) || howMuch.getRespectDescendant() && child.isFirstClass.booleanValue())) {
                    ((ReferenceFrame)child).updateBoundingSphere(sphere, asSeenBy, howMuch, ignoreHidden);
                }
                ++i;
            }
        }
    }

    protected void updateBoundingBox(Box box, ReferenceFrame asSeenBy, HowMuch howMuch, boolean ignoreHidden) {
        if (howMuch.getDescend()) {
            int i = 0;
            while (i < this.getChildCount()) {
                Element child = this.getChildAt(i);
                if (!(!(child instanceof ReferenceFrame) || howMuch.getRespectDescendant() && child.isFirstClass.booleanValue())) {
                    ((ReferenceFrame)child).updateBoundingBox(box, asSeenBy, howMuch, ignoreHidden);
                }
                ++i;
            }
        }
    }

    public Sphere getBoundingSphere(ReferenceFrame asSeenBy, HowMuch howMuch, boolean ignoreHidden) {
        if (asSeenBy == null) {
            asSeenBy = this;
        }
        Sphere sphere = new Sphere(null, Double.NaN);
        this.updateBoundingSphere(sphere, asSeenBy, howMuch, ignoreHidden);
        return sphere;
    }

    public Box getBoundingBox(ReferenceFrame asSeenBy, HowMuch howMuch, boolean ignoreHidden) {
        if (asSeenBy == null) {
            asSeenBy = this;
        }
        Box box = new Box(null, null);
        this.updateBoundingBox(box, asSeenBy, howMuch, ignoreHidden);
        return box;
    }

    public Vector3 getSize(ReferenceFrame asSeenBy, HowMuch howMuch, boolean ignoreHidden) {
        Box box = this.getBoundingBox(asSeenBy, howMuch, ignoreHidden);
        if (box != null) {
            return new Vector3(box.getWidth(), box.getHeight(), box.getDepth());
        }
        return new Vector3(0.0, 0.0, 0.0);
    }

    public double getSizeAlongDimension(Dimension dimension, ReferenceFrame asSeenBy, HowMuch howMuch, boolean ignoreHidden) {
        Box box = this.getBoundingBox(asSeenBy, howMuch, ignoreHidden);
        if (box != null) {
            if (dimension == Dimension.LEFT_TO_RIGHT) {
                return box.getWidth();
            }
            if (dimension == Dimension.TOP_TO_BOTTOM) {
                return box.getHeight();
            }
            if (dimension == Dimension.FRONT_TO_BACK) {
                return box.getDepth();
            }
            throw new IllegalArgumentException(dimension + " " + Messages.getString("is_expected_to_be_in__LEFT_TO_RIGHT__TOP_TO_BOTTOM__FRONT_TO_BACK__"));
        }
        return 0.0;
    }

    public double getWidth(ReferenceFrame asSeenBy, HowMuch howMuch, boolean ignoreHidden) {
        return this.getSizeAlongDimension(Dimension.LEFT_TO_RIGHT, asSeenBy, howMuch, ignoreHidden);
    }

    public double getHeight(ReferenceFrame asSeenBy, HowMuch howMuch, boolean ignoreHidden) {
        return this.getSizeAlongDimension(Dimension.TOP_TO_BOTTOM, asSeenBy, howMuch, ignoreHidden);
    }

    public double getDepth(ReferenceFrame asSeenBy, HowMuch howMuch, boolean ignoreHidden) {
        return this.getSizeAlongDimension(Dimension.FRONT_TO_BACK, asSeenBy, howMuch, ignoreHidden);
    }

    public Sphere getBoundingSphere(ReferenceFrame asSeenBy, HowMuch howMuch) {
        return this.getBoundingSphere(asSeenBy, howMuch, false);
    }

    public Sphere getBoundingSphere(ReferenceFrame asSeenBy) {
        return this.getBoundingSphere(asSeenBy, HowMuch.INSTANCE_AND_PARTS);
    }

    public Sphere getBoundingSphere() {
        return this.getBoundingSphere(null);
    }

    public Box getBoundingBox(ReferenceFrame asSeenBy, HowMuch howMuch) {
        return this.getBoundingBox(asSeenBy, howMuch, false);
    }

    public Box getBoundingBox(ReferenceFrame asSeenBy) {
        return this.getBoundingBox(asSeenBy, HowMuch.INSTANCE_AND_PARTS);
    }

    public Box getBoundingBox() {
        return this.getBoundingBox(null);
    }

    public Vector3 getSize(ReferenceFrame asSeenBy, HowMuch howMuch) {
        return this.getSize(asSeenBy, howMuch, false);
    }

    public Vector3 getSize(ReferenceFrame asSeenBy) {
        return this.getSize(asSeenBy, HowMuch.INSTANCE_AND_PARTS);
    }

    public Vector3 getSize() {
        return this.getSize(null);
    }

    public double getSizeAlongDimension(Dimension dimension, ReferenceFrame asSeenBy, HowMuch howMuch) {
        return this.getSizeAlongDimension(dimension, asSeenBy, howMuch, false);
    }

    public double getSizeAlongDimension(Dimension dimension, ReferenceFrame asSeenBy) {
        return this.getSizeAlongDimension(dimension, asSeenBy, HowMuch.INSTANCE_AND_PARTS);
    }

    public double getSizeAlongDimension(Dimension dimension) {
        return this.getSizeAlongDimension(dimension, null);
    }

    public double getWidth(ReferenceFrame asSeenBy, HowMuch howMuch) {
        return this.getWidth(asSeenBy, howMuch, false);
    }

    public double getWidth(ReferenceFrame asSeenBy) {
        return this.getWidth(asSeenBy, HowMuch.INSTANCE_AND_PARTS);
    }

    public double getWidth() {
        return this.getWidth(null);
    }

    public double getHeight(ReferenceFrame asSeenBy, HowMuch howMuch) {
        return this.getHeight(asSeenBy, howMuch, false);
    }

    public double getHeight(ReferenceFrame asSeenBy) {
        return this.getHeight(asSeenBy, HowMuch.INSTANCE_AND_PARTS);
    }

    public double getHeight() {
        return this.getHeight(null);
    }

    public double getDepth(ReferenceFrame asSeenBy, HowMuch howMuch) {
        return this.getDepth(asSeenBy, howMuch, false);
    }

    public double getDepth(ReferenceFrame asSeenBy) {
        return this.getDepth(asSeenBy, HowMuch.INSTANCE_AND_PARTS);
    }

    public double getDepth() {
        return this.getDepth(null);
    }

    protected static void HACK_syncPropertyToSceneGraph(String propertyName, edu.cmu.cs.stage3.alice.scenegraph.IndexedTriangleArray sgITA) {
        IndexedTriangleArray ita = (IndexedTriangleArray)sgITA.getBonus();
        if (propertyName.equals("vertices")) {
            ita.vertices.set(sgITA.getVertices());
        } else if (propertyName.equals("indices")) {
            ita.indices.set(sgITA.getIndices());
        }
    }
}

