/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core;

import edu.cmu.cs.stage3.alice.core.Behavior;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.ExceptionWrapper;
import edu.cmu.cs.stage3.alice.core.Expression;
import edu.cmu.cs.stage3.alice.core.IllegalArrayPropertyValueException;
import edu.cmu.cs.stage3.alice.core.IllegalPropertyValueException;
import edu.cmu.cs.stage3.alice.core.List;
import edu.cmu.cs.stage3.alice.core.Question;
import edu.cmu.cs.stage3.alice.core.ReferenceGenerator;
import edu.cmu.cs.stage3.alice.core.Sandbox;
import edu.cmu.cs.stage3.alice.core.Variable;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.criterion.ElementKeyedCriterion;
import edu.cmu.cs.stage3.alice.core.criterion.ExternalReferenceKeyedCriterion;
import edu.cmu.cs.stage3.alice.core.criterion.InternalReferenceKeyedCriterion;
import edu.cmu.cs.stage3.alice.core.event.PropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.PropertyListener;
import edu.cmu.cs.stage3.alice.core.reference.PropertyReference;
import edu.cmu.cs.stage3.io.DirectoryTreeLoader;
import edu.cmu.cs.stage3.io.DirectoryTreeStorer;
import edu.cmu.cs.stage3.io.KeepFileDoesNotExistException;
import edu.cmu.cs.stage3.io.KeepFileNotSupportedException;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.math.Matrix44;
import edu.cmu.cs.stage3.util.Criterion;
import edu.cmu.cs.stage3.util.HowMuch;
import edu.cmu.cs.stage3.xml.NodeUtilities;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Vector;
import javax.vecmath.Matrix4d;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class Property {
    private static boolean HACK_s_isListeningEnabled = true;
    private boolean m_isAcceptingOfHowMuch = false;
    private Element m_owner;
    private String m_name;
    private Object m_defaultValue;
    private Class m_valueClass;
    private Object m_value;
    private Vector m_propertyListeners = new Vector();
    private PropertyListener[] m_propertyListenerArray = null;
    private boolean m_isDeprecated = false;
    protected Object m_associatedFileKey = null;
    private static Dictionary s_ownerClassMap = new Hashtable();
    private static Behavior m_currentBehavior = null;

    public static void HACK_enableListening() {
        HACK_s_isListeningEnabled = true;
    }

    public static void HACK_disableListening() {
        HACK_s_isListeningEnabled = false;
    }

    public boolean isAcceptingOfHowMuch() {
        return this.m_isAcceptingOfHowMuch;
    }

    public void setIsAcceptingOfHowMuch(boolean isAcceptingOfHowMuch) {
        this.m_isAcceptingOfHowMuch = isAcceptingOfHowMuch;
    }

    protected Property(Element owner, String name, Object defaultValue, Class valueClass) {
        this.m_owner = owner;
        this.m_name = name;
        this.m_defaultValue = defaultValue;
        this.m_valueClass = valueClass;
        this.m_isAcceptingOfHowMuch = false;
        this.m_value = this.m_defaultValue;
        this.m_owner.propertyCreated(this);
    }

    public static String[] getPropertyNames(Class ownerClass, Class valueClass) {
        Object[] propertyNameArray;
        Hashtable<Class, Object[]> valueClassMap = (Hashtable<Class, Object[]>)s_ownerClassMap.get(ownerClass);
        if (valueClassMap == null) {
            valueClassMap = new Hashtable<Class, Object[]>();
            s_ownerClassMap.put(ownerClass, valueClassMap);
        }
        if ((propertyNameArray = (String[])((Dictionary)valueClassMap).get(valueClass)) == null) {
            Vector<String> propertyNames = new Vector<String>();
            Field[] fields = ownerClass.getFields();
            int i = 0;
            while (i < fields.length) {
                if (Property.class.isAssignableFrom(fields[i].getType())) {
                    String propertyName = fields[i].getName();
                    Class cls = Element.getValueClassForPropertyNamed(ownerClass, propertyName);
                    if (cls != null) {
                        if (valueClass.isAssignableFrom(cls)) {
                            propertyNames.addElement(propertyName);
                        }
                    } else {
                        System.err.println(ownerClass + " " + propertyName);
                    }
                }
                ++i;
            }
            propertyNameArray = new String[propertyNames.size()];
            propertyNames.copyInto(propertyNameArray);
            ((Dictionary)valueClassMap).put(valueClass, propertyNameArray);
        }
        return propertyNameArray;
    }

    public static String[] getPropertyNames(Class ownerClass) {
        return Property.getPropertyNames(ownerClass, Object.class);
    }

    public boolean isAlsoKnownAs(Class cls, String name) {
        if (cls.isAssignableFrom(this.m_owner.getClass())) {
            try {
                Field field = cls.getField(name);
                Object o = field.get(this.m_owner);
                return o == this;
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return false;
    }

    public Element getOwner() {
        return this.m_owner;
    }

    public Element getElement() {
        return this.getOwner();
    }

    public Class getValueClass() {
        return this.m_valueClass;
    }

    protected void setValueClass(Class valueClass) {
        this.m_valueClass = valueClass;
    }

    public Object getDefaultValue() {
        return this.m_defaultValue;
    }

    public String getName() {
        return this.m_name;
    }

    public void addPropertyListener(PropertyListener propertyListener) {
        if (!this.m_propertyListeners.contains(propertyListener)) {
            this.m_propertyListeners.addElement(propertyListener);
            this.m_propertyListenerArray = null;
        }
    }

    public void removePropertyListener(PropertyListener propertyListener) {
        this.m_propertyListeners.removeElement(propertyListener);
        this.m_propertyListenerArray = null;
    }

    public PropertyListener[] getPropertyListeners() {
        if (this.m_propertyListenerArray == null) {
            this.m_propertyListenerArray = new PropertyListener[this.m_propertyListeners.size()];
            this.m_propertyListeners.copyInto(this.m_propertyListenerArray);
        }
        return this.m_propertyListenerArray;
    }

    public Class getDeclaredClass() {
        if (this.m_owner != null) {
            for (Class<?> cls = this.m_owner.getClass(); cls != null; cls = cls.getSuperclass()) {
                try {
                    Field field = cls.getDeclaredField(this.m_name);
                    if (field.get(this.m_owner) == this) {
                        return cls;
                    }
                    throw new RuntimeException(this.m_owner + " " + Messages.getString("has_field_named_") + this.m_name + " " + Messages.getString("that_is_not_") + this);
                }
                catch (NoSuchFieldException nsfe) {
                    continue;
                }
                catch (IllegalAccessException iae) {
                    throw new ExceptionWrapper(iae, null);
                }
            }
            return null;
        }
        return null;
    }

    public Object get() {
        if (this.m_value instanceof Cloneable) {
            if (this.m_value.getClass().isArray()) {
                return this.m_value;
            }
            try {
                Class[] parameterTypes = new Class[]{};
                Object[] parameterValues = new Object[]{};
                Method method = this.m_value.getClass().getMethod("clone", parameterTypes);
                if (method.isAccessible()) {
                    return method.invoke(this.m_value, parameterValues);
                }
                return this.m_value;
            }
            catch (NoSuchMethodException nsme) {
                Element.warnln(String.valueOf(Messages.getString("property_get_failure_to_clone__")) + this + " " + nsme);
                return this.m_value;
            }
            catch (IllegalAccessException iae) {
                Element.warnln(String.valueOf(Messages.getString("property_get_failure_to_clone__")) + this + " " + iae);
                return this.m_value;
            }
            catch (InvocationTargetException ite) {
                Element.warnln(String.valueOf(Messages.getString("property_get_failure_to_clone__")) + this + " " + ite);
                return this.m_value;
            }
        }
        return this.m_value;
    }

    private boolean isValueInADifferentWorld(Object value) {
        World world = this.getElement().getWorld();
        if (world != null && value instanceof Element) {
            Element element = (Element)value;
            return world != this.getElement().getWorld();
        }
        return false;
    }

    public void checkForBadReferences(Object value) {
        if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            int i = 0;
            while (i < array.length) {
                if (this.isValueInADifferentWorld(array[i])) {
                    throw new IllegalArrayPropertyValueException(this, i, value, Messages.getString("value_must_be_in_world"));
                }
                ++i;
            }
        } else if (this.isValueInADifferentWorld(value)) {
            throw new IllegalPropertyValueException(this, value, Messages.getString("value_must_be_in_world"));
        }
    }

    protected void checkValueType(Object value) {
        if (value != null) {
            Class valueClass = this.getValueClass();
            if (value instanceof Expression) {
                Expression expression = (Expression)value;
                if (!(valueClass.isAssignableFrom(Expression.class) || valueClass.isAssignableFrom(Variable.class) || valueClass.isAssignableFrom(Question.class) || Question.class.isAssignableFrom(valueClass) || expression.getValueClass() == null)) {
                    valueClass.isAssignableFrom(expression.getValueClass());
                }
            } else if (!valueClass.isAssignableFrom(value.getClass())) {
                throw new IllegalPropertyValueException(this, value, String.valueOf(Messages.getString("Cannot_set_property_")) + this.getName() + " " + Messages.getString("on_") + this.getOwner() + ".  " + valueClass + " " + Messages.getString("is_not_assignable_from_") + value.getClass());
            }
        }
    }

    protected boolean getValueOfExpression() {
        Class valueClass = this.getValueClass();
        if (valueClass.equals(List.class) || valueClass.equals(Object.class)) {
            return true;
        }
        if (valueClass.isAssignableFrom(Expression.class)) {
            return false;
        }
        if (valueClass.isAssignableFrom(Variable.class)) {
            return false;
        }
        return !valueClass.isAssignableFrom(Question.class);
    }

    protected Object evaluateIfNecessary(Object o) {
        if (o instanceof Expression) {
            Variable runtimeVariable;
            Sandbox sandbox;
            World world;
            Element owner;
            Expression expression = (Expression)o;
            if (m_currentBehavior == null && !this.isDeprecated() && expression instanceof Variable && (owner = this.getOwner()) != null && (world = owner.getWorld()) != null && (sandbox = world.getCurrentSandbox()) != null && (m_currentBehavior = sandbox.getCurrentBehavior()) != null && (runtimeVariable = m_currentBehavior.stackLookup((Variable)expression)) != null) {
                expression = runtimeVariable;
            }
            Object value = this.getValueOfExpression() ? expression.getValue() : expression;
            m_currentBehavior = null;
            return value;
        }
        return o;
    }

    public Object getValue() {
        return this.evaluateIfNecessary(this.m_value);
    }

    private void onChanging(PropertyEvent propertyEvent) {
        this.m_owner.propertyChanging(propertyEvent);
        if (HACK_s_isListeningEnabled) {
            PropertyListener[] propertyListeners = this.getPropertyListeners();
            int i = 0;
            while (i < propertyListeners.length) {
                propertyListeners[i].propertyChanging(propertyEvent);
                ++i;
            }
        }
    }

    private void onChanged(PropertyEvent propertyEvent) {
        this.getElement().markKeepKeyDirty();
        this.m_owner.propertyChanged(propertyEvent);
        if (HACK_s_isListeningEnabled) {
            PropertyListener[] propertyListeners = this.getPropertyListeners();
            int i = 0;
            while (i < propertyListeners.length) {
                propertyListeners[i].propertyChanged(propertyEvent);
                ++i;
            }
        }
    }

    protected void onSet(Object value) {
        Class valueClass = this.getValueClass();
        PropertyEvent propertyEvent = new PropertyEvent(this, value);
        this.onChanging(propertyEvent);
        if (this.m_value instanceof Variable[] && value instanceof Variable) {
            Variable[] temp = (Variable[])this.m_value;
            int i = 0;
            while (i < temp.length) {
                if (temp[i] == null) {
                    temp[i] = (Variable)value;
                    break;
                }
                ++i;
            }
            this.m_value = temp;
        } else {
            this.m_value = value;
        }
        this.onChanged(propertyEvent);
        this.m_associatedFileKey = null;
    }

    public void set(Object value) throws IllegalArgumentException {
        if (this.m_value == null ? value == null : this.m_value.equals(value)) {
            return;
        }
        if (!Element.s_isLoading) {
            this.checkValueType(value);
            this.checkForBadReferences(value);
        }
        this.onSet(value);
    }

    private static void setHowMuch(Element owner, String propertyName, Object value, HowMuch howMuch) {
        Property property = owner.getPropertyNamed(propertyName);
        if (property != null) {
            property.set(value);
        }
        if (howMuch.getDescend()) {
            int i = 0;
            while (i < owner.getChildCount()) {
                Element child = owner.getChildAt(i);
                if (!child.isFirstClass.booleanValue() || !howMuch.getRespectDescendant()) {
                    Property.setHowMuch(child, propertyName, value, howMuch);
                }
                ++i;
            }
        }
    }

    public void set(Object value, HowMuch howMuch) throws IllegalArgumentException {
        if (this.m_owner instanceof Element) {
            Property.setHowMuch(this.m_owner, this.m_name, value, howMuch);
        }
    }

    protected Object getValueOf(Class type, String text) {
        if (type.equals(Double.class)) {
            if (text.equals("Infinity")) {
                return new Double(Double.POSITIVE_INFINITY);
            }
            if (text.equals("NaN")) {
                return new Double(Double.NaN);
            }
            return Double.valueOf(text);
        }
        if (type.equals(String.class)) {
            return text;
        }
        try {
            if (type.equals(Matrix4d.class)) {
                String[] t = text.split(",|\n");
                Matrix44 m = new Matrix44();
                m.m00 = Double.valueOf(t[0]);
                m.m01 = Double.valueOf(t[1]);
                m.m02 = Double.valueOf(t[2]);
                m.m03 = Double.valueOf(t[3]);
                m.m10 = Double.valueOf(t[4]);
                m.m11 = Double.valueOf(t[5]);
                m.m12 = Double.valueOf(t[6]);
                m.m13 = Double.valueOf(t[7]);
                m.m20 = Double.valueOf(t[8]);
                m.m21 = Double.valueOf(t[9]);
                m.m22 = Double.valueOf(t[10]);
                m.m23 = Double.valueOf(t[11]);
                m.m30 = Double.valueOf(t[12]);
                m.m31 = Double.valueOf(t[13]);
                m.m32 = Double.valueOf(t[14]);
                m.m33 = Double.valueOf(t[15]);
                return m;
            }
            Class[] parameterTypes = new Class[]{String.class};
            Method valueOfMethod = type.getMethod("valueOf", parameterTypes);
            int modifiers = valueOfMethod.getModifiers();
            if (Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers)) {
                Object[] parameters = new Object[]{text};
                return valueOfMethod.invoke(null, parameters);
            }
            throw new RuntimeException(Messages.getString("valueOf_method_not_public_static_"));
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException("NoSuchMethodException:" + type);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException("IllegalAccessException: " + type);
        }
        catch (InvocationTargetException ite) {
            throw new RuntimeException("java.lang.reflect.InvocationTargetException: " + type + " " + text);
        }
    }

    protected String getNodeText(Node node) {
        return NodeUtilities.getNodeText(node);
    }

    protected Node createNodeForString(Document document, String s) {
        char[] cdataCharacters = new char[]{' ', '\t', '\n', '\"', '\'', '>', '<', '&'};
        int i = 0;
        while (i < cdataCharacters.length) {
            if (s.indexOf(cdataCharacters[i]) != -1) {
                return document.createCDATASection(s);
            }
            ++i;
        }
        return document.createTextNode(s);
    }

    protected String getFilename(String text) {
        String[] markers = new String[]{"java.io.File[", "]"};
        int begin = text.indexOf(markers[0]) + markers[0].length();
        int end = text.lastIndexOf(markers[1]);
        return text.substring(begin, end);
    }

    protected void decodeReference(org.w3c.dom.Element node, Vector referencesToBeResolved, double version, String typeName) {
        try {
            Class<ElementKeyedCriterion> type = Class.forName(typeName);
            String text = this.getNodeText(node);
            if (text.equals(".")) {
                text = "";
            }
            Criterion criterion = type.isAssignableFrom(InternalReferenceKeyedCriterion.class) ? new InternalReferenceKeyedCriterion(text) : (type.isAssignableFrom(ExternalReferenceKeyedCriterion.class) ? new ExternalReferenceKeyedCriterion(text) : (Criterion)this.getValueOf(type, text));
            referencesToBeResolved.addElement(new PropertyReference(this, criterion));
        }
        catch (ClassNotFoundException cnfe) {
            throw new RuntimeException(typeName);
        }
    }

    protected void decodeObject(org.w3c.dom.Element node, DirectoryTreeLoader loader, Vector referencesToBeResolved, double version) throws IOException {
        String typeName = node.getAttribute("class");
        if (typeName.length() > 0) {
            String text = this.getNodeText(node);
            try {
                Class<?> type = Class.forName(typeName);
                Object t = this.getValueOf(type, text);
                this.set(t);
            }
            catch (ClassNotFoundException cnfe) {
                throw new RuntimeException(typeName);
            }
        } else {
            System.err.println(this);
            throw new RuntimeException();
        }
    }

    public final void decode(org.w3c.dom.Element node, DirectoryTreeLoader loader, Vector referencesToBeResolved, double version) throws IOException {
        if (node.hasChildNodes()) {
            String criterionClassname = node.getAttribute("criterionClass");
            if (criterionClassname.length() > 0) {
                this.decodeReference(node, referencesToBeResolved, version, criterionClassname);
            } else {
                this.decodeObject(node, loader, referencesToBeResolved, version);
            }
        } else {
            this.set(null);
        }
    }

    protected void encodeReference(Document document, org.w3c.dom.Element node, ReferenceGenerator referenceGenerator, Element owner) {
        Criterion criterion = referenceGenerator.generateReference(owner);
        if (criterion != null) {
            node.setAttribute("criterionClass", criterion.getClass().getName());
            String s = criterion instanceof InternalReferenceKeyedCriterion ? ((InternalReferenceKeyedCriterion)criterion).getKey() : (criterion instanceof ExternalReferenceKeyedCriterion ? ((ExternalReferenceKeyedCriterion)criterion).getKey() : criterion.toString());
            if (s.length() == 0) {
                s = ".";
            }
            node.appendChild(this.createNodeForString(document, s));
        }
    }

    protected void encodeObject(Document document, org.w3c.dom.Element node, DirectoryTreeStorer storer, ReferenceGenerator referenceGenerator) throws IOException {
        Object o = this.get();
        node.setAttribute("class", o.getClass().getName());
        node.appendChild(this.createNodeForString(document, o.toString()));
    }

    public final void encode(Document document, org.w3c.dom.Element node, DirectoryTreeStorer storer, ReferenceGenerator referenceGenerator) throws IOException {
        Object o = this.get();
        if (o != null) {
            if (o instanceof Element) {
                this.encodeReference(document, node, referenceGenerator, (Element)o);
            } else {
                this.encodeObject(document, node, storer, referenceGenerator);
            }
        }
    }

    public void keepAnyAssociatedFiles(DirectoryTreeStorer storer) throws KeepFileNotSupportedException, KeepFileDoesNotExistException {
    }

    public boolean isDeprecated() {
        return this.m_isDeprecated;
    }

    public void deprecate() {
        this.m_isDeprecated = true;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[name=" + this.m_name + ",owner=" + this.m_owner + "]";
    }
}

