/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core;

import edu.cmu.cs.stage3.alice.core.Affector;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Geometry;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.ReferenceFrame;
import edu.cmu.cs.stage3.alice.core.TextureMap;
import edu.cmu.cs.stage3.alice.core.Transformable;
import edu.cmu.cs.stage3.alice.core.Visualization;
import edu.cmu.cs.stage3.alice.core.property.BooleanProperty;
import edu.cmu.cs.stage3.alice.core.property.ColorProperty;
import edu.cmu.cs.stage3.alice.core.property.ElementArrayProperty;
import edu.cmu.cs.stage3.alice.core.property.FillingStyleProperty;
import edu.cmu.cs.stage3.alice.core.property.GeometryProperty;
import edu.cmu.cs.stage3.alice.core.property.Matrix33Property;
import edu.cmu.cs.stage3.alice.core.property.NumberProperty;
import edu.cmu.cs.stage3.alice.core.property.ShadingStyleProperty;
import edu.cmu.cs.stage3.alice.core.property.TextureMapProperty;
import edu.cmu.cs.stage3.alice.core.property.VisualizationProperty;
import edu.cmu.cs.stage3.alice.scenegraph.Appearance;
import edu.cmu.cs.stage3.alice.scenegraph.Color;
import edu.cmu.cs.stage3.alice.scenegraph.FillingStyle;
import edu.cmu.cs.stage3.alice.scenegraph.ShadingStyle;
import edu.cmu.cs.stage3.alice.scenegraph.Visual;
import edu.cmu.cs.stage3.math.Box;
import edu.cmu.cs.stage3.math.MathUtilities;
import edu.cmu.cs.stage3.math.Matrix33;
import edu.cmu.cs.stage3.math.Matrix44;
import edu.cmu.cs.stage3.math.Sphere;
import edu.cmu.cs.stage3.util.HowMuch;
import java.util.Dictionary;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;

public class Model
extends Transformable {
    public final ColorProperty color = new ColorProperty(this, "color", Color.WHITE);
    public final ColorProperty ambientColor = new ColorProperty(this, "ambientColor", null);
    public final NumberProperty opacity = new NumberProperty(this, "opacity", new Double(1.0));
    public final FillingStyleProperty fillingStyle = new FillingStyleProperty(this, "fillingStyle", FillingStyle.SOLID);
    public final ShadingStyleProperty shadingStyle = new ShadingStyleProperty(this, "shadingStyle", ShadingStyle.SMOOTH);
    public final ColorProperty specularHighlightColor = new ColorProperty(this, "specularHighlightColor", Color.BLACK);
    public final NumberProperty specularHighlightExponent = new NumberProperty(this, "specularHighlightExponent", new Double(0.0));
    public final ColorProperty emissiveColor = new ColorProperty(this, "emissiveColor", Color.BLACK);
    public final TextureMapProperty diffuseColorMap = new TextureMapProperty((Element)this, "diffuseColorMap", null);
    public final TextureMapProperty opacityMap = new TextureMapProperty((Element)this, "opacityMap", null);
    public final TextureMapProperty emissiveColorMap = new TextureMapProperty((Element)this, "emissiveColorMap", null);
    public final TextureMapProperty specularHighlightColorMap = new TextureMapProperty((Element)this, "specularHighlightColorMap", null);
    public final TextureMapProperty bumpMap = new TextureMapProperty((Element)this, "bumpMap", null);
    public final TextureMapProperty detailMap = new TextureMapProperty((Element)this, "detailMap", null);
    public final TextureMapProperty interactionMap = new TextureMapProperty((Element)this, "interactionMap", null);
    public final Matrix33Property visualScale = new Matrix33Property(this, "visualScale", Matrix33.IDENTITY);
    public final BooleanProperty isShowing = new BooleanProperty(this, "isShowing", Boolean.TRUE);
    public final ElementArrayProperty disabledAffectors = new ElementArrayProperty((Element)this, "disabledAffectors", null, Affector[].class);
    public final GeometryProperty geometry = new GeometryProperty((Element)this, "geometry", null);
    public final VisualizationProperty visualization = new VisualizationProperty((Element)this, "visualization", null);
    private Visual m_sgVisual;
    private Appearance m_sgAppearance = new Appearance();

    @Override
    protected void internalRelease(int pass) {
        switch (pass) {
            case 1: {
                this.m_sgAppearance.setDiffuseColorMap(null);
                this.m_sgAppearance.setOpacityMap(null);
                this.m_sgAppearance.setEmissiveColorMap(null);
                this.m_sgAppearance.setSpecularHighlightColorMap(null);
                this.m_sgAppearance.setBumpMap(null);
                this.m_sgAppearance.setDetailMap(null);
                this.m_sgVisual.setFrontFacingAppearance(null);
                this.m_sgVisual.setGeometry(null);
                this.m_sgVisual.setParent(null);
                break;
            }
            case 2: {
                this.m_sgVisual.release();
                this.m_sgVisual = null;
                this.m_sgAppearance.release();
                this.m_sgAppearance = null;
            }
        }
        super.internalRelease(pass);
    }

    public Visual getSceneGraphVisual() {
        return this.m_sgVisual;
    }

    public Appearance getSceneGraphAppearance() {
        return this.m_sgAppearance;
    }

    public Model() {
        this.m_sgAppearance.setBonus(this);
        this.m_sgVisual = new Visual();
        this.m_sgVisual.setParent(this.getSceneGraphTransformable());
        this.m_sgVisual.setFrontFacingAppearance(this.m_sgAppearance);
        this.m_sgVisual.setBonus(this);
        this.color.set(this.m_sgAppearance.getDiffuseColor());
        this.ambientColor.set(this.m_sgAppearance.getAmbientColor());
        this.opacity.set(new Double(this.m_sgAppearance.getOpacity()));
        this.fillingStyle.set(this.m_sgAppearance.getFillingStyle());
        this.shadingStyle.set(this.m_sgAppearance.getShadingStyle());
        this.specularHighlightColor.set(this.m_sgAppearance.getSpecularHighlightColor());
        this.specularHighlightExponent.set(new Double(this.m_sgAppearance.getSpecularHighlightExponent()));
        this.emissiveColor.set(this.m_sgAppearance.getEmissiveColor());
        this.visualScale.set(this.m_sgVisual.getScale());
        this.isShowing.set(new Boolean(this.m_sgVisual.getIsShowing()));
    }

    @Override
    protected void nameValueChanged(String value) {
        super.nameValueChanged(value);
        if (value != null) {
            this.m_sgVisual.setName(String.valueOf(value) + ".m_sgVisual");
            this.m_sgAppearance.setName(String.valueOf(value) + ".m_sgAppearance");
        } else {
            this.m_sgVisual.setName(null);
            this.m_sgAppearance.setName(null);
        }
    }

    private static edu.cmu.cs.stage3.alice.scenegraph.TextureMap getSceneGraphTextureMap(TextureMap textureMap) {
        if (textureMap != null) {
            return textureMap.getSceneGraphTextureMap();
        }
        return null;
    }

    private static edu.cmu.cs.stage3.alice.scenegraph.Geometry getSceneGraphGeometry(Geometry geometry) {
        if (geometry != null) {
            return geometry.getSceneGraphGeometry();
        }
        return null;
    }

    @Override
    public void propertyCreated(Property property) {
        if (property.getName().equals("color")) {
            property.setIsAcceptingOfHowMuch(true);
        } else if (property.getName().equals("ambientColor")) {
            property.setIsAcceptingOfHowMuch(true);
        } else if (property.getName().equals("opacity")) {
            property.setIsAcceptingOfHowMuch(true);
        } else if (property.getName().equals("fillingStyle")) {
            property.setIsAcceptingOfHowMuch(true);
        } else if (property.getName().equals("shadingStyle")) {
            property.setIsAcceptingOfHowMuch(true);
        } else if (property.getName().equals("specularHighlightColor")) {
            property.setIsAcceptingOfHowMuch(true);
        } else if (property.getName().equals("specularHighlightExponent")) {
            property.setIsAcceptingOfHowMuch(true);
        } else if (property.getName().equals("emissiveColor")) {
            property.setIsAcceptingOfHowMuch(true);
        } else if (property.getName().equals("diffuseColorMap")) {
            property.setIsAcceptingOfHowMuch(true);
        } else if (property.getName().equals("opacityMap")) {
            property.setIsAcceptingOfHowMuch(true);
        } else if (property.getName().equals("emissiveColorMap")) {
            property.setIsAcceptingOfHowMuch(true);
        } else if (property.getName().equals("specularHighlightColorMap")) {
            property.setIsAcceptingOfHowMuch(true);
        } else if (property.getName().equals("bumpMap")) {
            property.setIsAcceptingOfHowMuch(true);
        } else if (property.getName().equals("detailMap")) {
            property.setIsAcceptingOfHowMuch(true);
        } else if (property.getName().equals("interactionMap")) {
            property.setIsAcceptingOfHowMuch(true);
        } else if (property.getName().equals("visualScale")) {
            property.setIsAcceptingOfHowMuch(true);
        } else if (property.getName().equals("isShowing")) {
            property.setIsAcceptingOfHowMuch(true);
        } else if (property.getName().equals("disabledAffectors")) {
            property.setIsAcceptingOfHowMuch(true);
        } else if (property.getName().equals("geometry")) {
            property.setIsAcceptingOfHowMuch(true);
        } else {
            super.propertyCreated(property);
        }
    }

    @Override
    protected void propertyChanging(Property property, Object value) {
        if (property == this.visualization) {
            Visualization prev = this.visualization.getVisualizationValue();
            if (prev != null) {
                prev.unhook(this);
            }
        } else {
            super.propertyChanging(property, value);
        }
    }

    @Override
    protected void propertyChanged(Property property, Object value) {
        if (property == this.color) {
            this.m_sgAppearance.setDiffuseColor((Color)value);
        } else if (property == this.ambientColor) {
            this.m_sgAppearance.setAmbientColor((Color)value);
        } else if (property == this.opacity) {
            this.m_sgAppearance.setOpacity(((Number)value).doubleValue());
        } else if (property == this.fillingStyle) {
            this.m_sgAppearance.setFillingStyle((FillingStyle)value);
        } else if (property == this.shadingStyle) {
            this.m_sgAppearance.setShadingStyle((ShadingStyle)value);
        } else if (property == this.specularHighlightColor) {
            this.m_sgAppearance.setSpecularHighlightColor((Color)value);
        } else if (property == this.specularHighlightExponent) {
            this.m_sgAppearance.setSpecularHighlightExponent(((Number)value).doubleValue());
        } else if (property == this.emissiveColor) {
            this.m_sgAppearance.setEmissiveColor((Color)value);
        } else if (property == this.diffuseColorMap) {
            this.m_sgAppearance.setDiffuseColorMap(Model.getSceneGraphTextureMap((TextureMap)value));
        } else if (property == this.opacityMap) {
            this.m_sgAppearance.setOpacityMap(Model.getSceneGraphTextureMap((TextureMap)value));
        } else if (property == this.emissiveColorMap) {
            this.m_sgAppearance.setEmissiveColorMap(Model.getSceneGraphTextureMap((TextureMap)value));
        } else if (property == this.specularHighlightColorMap) {
            this.m_sgAppearance.setSpecularHighlightColorMap(Model.getSceneGraphTextureMap((TextureMap)value));
        } else if (property == this.bumpMap) {
            this.m_sgAppearance.setBumpMap(Model.getSceneGraphTextureMap((TextureMap)value));
        } else if (property == this.detailMap) {
            this.m_sgAppearance.setDetailMap(Model.getSceneGraphTextureMap((TextureMap)value));
        } else if (property != this.interactionMap) {
            if (property == this.visualScale) {
                this.m_sgVisual.setScale((Matrix3d)value);
            } else if (property == this.isShowing) {
                this.m_sgVisual.setIsShowing((Boolean)value);
            } else if (property == this.disabledAffectors) {
                if (value != null) {
                    Affector[] affectors = (Affector[])value;
                    edu.cmu.cs.stage3.alice.scenegraph.Affector[] sgAffectors = new edu.cmu.cs.stage3.alice.scenegraph.Affector[affectors.length];
                    int i = 0;
                    while (i < sgAffectors.length) {
                        sgAffectors[i] = affectors[i].getSceneGraphAffector();
                        ++i;
                    }
                    this.m_sgVisual.setDisabledAffectors(sgAffectors);
                } else {
                    this.m_sgVisual.setDisabledAffectors(null);
                }
            } else if (property == this.geometry) {
                this.m_sgVisual.setGeometry(Model.getSceneGraphGeometry((Geometry)value));
            } else {
                super.propertyChanged(property, value);
            }
        }
    }

    protected void scaleVisualRightNow(Vector3d scale, ReferenceFrame asSeenBy) {
        Matrix4d scaleMatrix = new Matrix4d(scale.x, 0.0, 0.0, 0.0, 0.0, scale.y, 0.0, 0.0, 0.0, 0.0, scale.z, 0.0, 0.0, 0.0, 0.0, 1.0);
        Matrix44 m = this.calculateTransformation(scaleMatrix, asSeenBy);
        Matrix3d visScale = this.visualScale.getMatrix3dValue();
        this.visualScale.set(MathUtilities.multiply(visScale, m.getAxes()));
    }

    @Override
    protected void updateBoundingSphere(Sphere sphere, ReferenceFrame asSeenBy, HowMuch howMuch, boolean ignoreHidden) {
        Sphere localSphere;
        super.updateBoundingSphere(sphere, asSeenBy, howMuch, ignoreHidden);
        if ((!ignoreHidden || this.isShowing.booleanValue()) && (localSphere = this.m_sgVisual.getBoundingSphere()) != null) {
            localSphere.transform(this.getTransformation(asSeenBy));
            sphere.union(localSphere);
        }
    }

    @Override
    protected void updateBoundingBox(Box box, ReferenceFrame asSeenBy, HowMuch howMuch, boolean ignoreHidden) {
        Box localBox;
        super.updateBoundingBox(box, asSeenBy, howMuch, ignoreHidden);
        if ((!ignoreHidden || this.isShowing.booleanValue()) && (localBox = this.m_sgVisual.getBoundingBox()) != null) {
            localBox.transform(this.getTransformation(asSeenBy));
            box.union(localBox);
        }
    }

    @Override
    protected void HACK_copyOverTextureMapReferences(Element dst, Dictionary srcTextureMapToDstTextureMapMap) {
        super.HACK_copyOverTextureMapReferences(dst, srcTextureMapToDstTextureMapMap);
        if (dst instanceof Model) {
            TextureMap tm = this.diffuseColorMap.getTextureMapValue();
            if (tm != null) {
                tm = (TextureMap)srcTextureMapToDstTextureMapMap.get(tm);
            }
            ((Model)dst).diffuseColorMap.set(tm);
        }
    }

    public static double getDistanceBetween(Model a, Model b) {
        Visual[] aSGVisuals = a.getAllSceneGraphVisuals();
        Visual[] bSGVisuals = b.getAllSceneGraphVisuals();
        Sphere[] aSpheres = new Sphere[aSGVisuals.length];
        Sphere[] bSpheres = new Sphere[bSGVisuals.length];
        int i = 0;
        while (i < aSGVisuals.length) {
            aSpheres[i] = aSGVisuals[i].getBoundingSphere();
            if (aSpheres[i] != null) {
                aSpheres[i].transform(aSGVisuals[i].getAbsoluteTransformation());
            }
            ++i;
        }
        i = 0;
        while (i < bSGVisuals.length) {
            bSpheres[i] = bSGVisuals[i].getBoundingSphere();
            if (bSpheres[i] != null) {
                bSpheres[i].transform(bSGVisuals[i].getAbsoluteTransformation());
            }
            ++i;
        }
        double dMin = Double.MAX_VALUE;
        int i2 = 0;
        while (i2 < aSpheres.length) {
            if (aSpheres[i2] != null && aSpheres[i2].getCenter() != null && aSpheres[i2].getRadius() > 0.0) {
                int j = 0;
                while (j < bSpheres.length) {
                    if (bSpheres[j] != null && bSpheres[j].getCenter() != null && bSpheres[j].getRadius() > 0.0) {
                        double d = MathUtilities.subtract(aSpheres[i2].getCenter(), bSpheres[j].getCenter()).lengthSquared();
                        d = Math.sqrt(d);
                        d -= aSpheres[i2].getRadius();
                        dMin = Math.min(dMin, d -= bSpheres[j].getRadius());
                    }
                    ++j;
                }
            }
            ++i2;
        }
        return dMin;
    }
}

