/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core;

import edu.cmu.cs.stage3.alice.authoringtool.AikMin;
import edu.cmu.cs.stage3.alice.core.CopyFactory;
import edu.cmu.cs.stage3.alice.core.ExceptionWrapper;
import edu.cmu.cs.stage3.alice.core.Expression;
import edu.cmu.cs.stage3.alice.core.Group;
import edu.cmu.cs.stage3.alice.core.IllegalNameValueException;
import edu.cmu.cs.stage3.alice.core.Pose;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.ReferenceGenerator;
import edu.cmu.cs.stage3.alice.core.Sandbox;
import edu.cmu.cs.stage3.alice.core.TextureMap;
import edu.cmu.cs.stage3.alice.core.UnresolvablePropertyReferencesException;
import edu.cmu.cs.stage3.alice.core.UnresolvableReferenceException;
import edu.cmu.cs.stage3.alice.core.World;
import edu.cmu.cs.stage3.alice.core.behavior.KeyboardNavigationBehavior;
import edu.cmu.cs.stage3.alice.core.behavior.MouseLookingBehavior;
import edu.cmu.cs.stage3.alice.core.event.ChildrenEvent;
import edu.cmu.cs.stage3.alice.core.event.ChildrenListener;
import edu.cmu.cs.stage3.alice.core.event.PropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.PropertyListener;
import edu.cmu.cs.stage3.alice.core.geometry.IndexedTriangleArray;
import edu.cmu.cs.stage3.alice.core.navigation.KeyMapping;
import edu.cmu.cs.stage3.alice.core.property.BooleanProperty;
import edu.cmu.cs.stage3.alice.core.property.DictionaryProperty;
import edu.cmu.cs.stage3.alice.core.property.ObjectArrayProperty;
import edu.cmu.cs.stage3.alice.core.property.StringProperty;
import edu.cmu.cs.stage3.alice.core.property.VertexArrayProperty;
import edu.cmu.cs.stage3.alice.core.reference.DefaultReferenceGenerator;
import edu.cmu.cs.stage3.alice.core.reference.DefaultReferenceResolver;
import edu.cmu.cs.stage3.alice.core.reference.ObjectArrayPropertyReference;
import edu.cmu.cs.stage3.alice.core.reference.PropertyReference;
import edu.cmu.cs.stage3.alice.core.response.CallToUserDefinedResponse;
import edu.cmu.cs.stage3.alice.core.response.DoInOrder;
import edu.cmu.cs.stage3.alice.core.response.DoTogether;
import edu.cmu.cs.stage3.alice.core.response.ForEach;
import edu.cmu.cs.stage3.alice.core.response.ForEachInOrder;
import edu.cmu.cs.stage3.alice.core.response.ForEachTogether;
import edu.cmu.cs.stage3.alice.core.response.ForwardVectorAnimation;
import edu.cmu.cs.stage3.alice.core.response.IfElseInOrder;
import edu.cmu.cs.stage3.alice.core.response.LoopNInOrder;
import edu.cmu.cs.stage3.alice.core.response.PoseAnimation;
import edu.cmu.cs.stage3.alice.core.response.ScriptDefinedResponse;
import edu.cmu.cs.stage3.alice.core.response.WhileLoopInOrder;
import edu.cmu.cs.stage3.alice.scripting.Code;
import edu.cmu.cs.stage3.alice.scripting.CompileType;
import edu.cmu.cs.stage3.io.DirectoryTreeLoader;
import edu.cmu.cs.stage3.io.DirectoryTreeStorer;
import edu.cmu.cs.stage3.io.FileSystemTreeLoader;
import edu.cmu.cs.stage3.io.FileSystemTreeStorer;
import edu.cmu.cs.stage3.io.KeepFileDoesNotExistException;
import edu.cmu.cs.stage3.io.KeepFileNotSupportedException;
import edu.cmu.cs.stage3.io.ZipFileTreeLoader;
import edu.cmu.cs.stage3.io.ZipFileTreeStorer;
import edu.cmu.cs.stage3.io.ZipTreeLoader;
import edu.cmu.cs.stage3.io.ZipTreeStorer;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.progress.ProgressCancelException;
import edu.cmu.cs.stage3.progress.ProgressObserver;
import edu.cmu.cs.stage3.util.Criterion;
import edu.cmu.cs.stage3.util.HowMuch;
import edu.cmu.cs.stage3.util.VisitListener;
import edu.cmu.cs.stage3.util.criterion.InstanceOfCriterion;
import edu.cmu.cs.stage3.xml.Encoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class Element {
    private static Hashtable s_classnameMap = new Hashtable();
    public static final double VERSION = 2.001;
    public static final char SEPARATOR = '.';
    private static final String XML_FILENAME = "elementData.xml";
    private static int s_loadProgress;
    public final StringProperty name = new StringProperty(this, "name", null);
    public final BooleanProperty isFirstClass = new BooleanProperty(this, "isFirstClass", Boolean.FALSE);
    public final DictionaryProperty data = new DictionaryProperty(this, "data", null);
    private Element m_parent = null;
    private Vector m_children = new Vector();
    private Element[] m_childArray = null;
    private Vector m_childrenListeners = new Vector();
    private ChildrenListener[] m_childrenListenerArray = null;
    private Object m_xmlFileKeepKey = null;
    public static boolean s_isLoading;
    private Property[] m_propertyArray = null;
    private boolean m_isReleased = false;
    private boolean m_updateParentsChildren = true;
    private static final char[] ILLEGAL_NAME_CHARACTERS;
    private static Hashtable s_classToElementCache;

    static {
        s_classnameMap.put("edu.cmu.cs.stage3.alice.core.response.ConditionalLoopSequentialResponse", WhileLoopInOrder.class);
        s_classnameMap.put("edu.cmu.cs.stage3.alice.core.response.ConditionalSequentialResponse", IfElseInOrder.class);
        s_classnameMap.put("edu.cmu.cs.stage3.alice.core.response.CountLoopSequentialResponse", LoopNInOrder.class);
        s_classnameMap.put("edu.cmu.cs.stage3.alice.core.response.ForEachInListSequentialResponse", ForEach.class);
        s_classnameMap.put("edu.cmu.cs.stage3.alice.core.response.OrientationAnimation", ForwardVectorAnimation.class);
        s_classnameMap.put("edu.cmu.cs.stage3.alice.core.response.ParallelForEachInListSequentialResponse", ForEachTogether.class);
        s_classnameMap.put("edu.cmu.cs.stage3.alice.core.response.ParallelResponse", DoTogether.class);
        s_classnameMap.put("edu.cmu.cs.stage3.alice.core.response.ProxyForScriptDefinedResponse", ScriptDefinedResponse.class);
        s_classnameMap.put("edu.cmu.cs.stage3.alice.core.response.SequentialForEachInListSequentialResponse", ForEachInOrder.class);
        s_classnameMap.put("edu.cmu.cs.stage3.alice.core.response.SequentialResponse", DoInOrder.class);
        s_classnameMap.put("edu.cmu.cs.stage3.bb2.navigation.KeyboardNavigationBehavior", KeyboardNavigationBehavior.class);
        s_classnameMap.put("edu.cmu.cs.stage3.bb2.navigation.MouseNavigationBehavior", MouseLookingBehavior.class);
        s_classnameMap.put("edu.cmu.cs.stage3.pratt.pose.Pose", Pose.class);
        s_classnameMap.put("edu.cmu.cs.stage3.pratt.pose.PoseAnimation", PoseAnimation.class);
        s_classnameMap.put("edu.cmu.cs.stage3.alice.core.response.MetaResponse", CallToUserDefinedResponse.class);
        s_classnameMap.put("edu.cmu.cs.stage3.bb2.navigation.KeyMapping", KeyMapping.class);
        s_loadProgress = 0;
        s_isLoading = false;
        ILLEGAL_NAME_CHARACTERS = new char[]{'\t', '\n', '\\', '/', ':', '*', '?', '\"', '<', '>', '|', '.'};
        s_classToElementCache = new Hashtable();
    }

    public void markKeepKeyDirty() {
        if (!s_isLoading) {
            this.m_xmlFileKeepKey = null;
        }
    }

    public Code compile(String script, Object source, CompileType compileType) {
        return this.getWorld().compile(script, source, compileType);
    }

    public Object eval(Code code) {
        return this.getWorld().eval(code);
    }

    public void exec(Code code) {
        this.getWorld().exec(code);
    }

    private static boolean isPropertyField(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isPublic(modifiers) && Property.class.isAssignableFrom(field.getType());
    }

    private static boolean isIllegal(char c) {
        int i = 0;
        while (i < ILLEGAL_NAME_CHARACTERS.length) {
            if (c == ILLEGAL_NAME_CHARACTERS[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean is8Bit(char c) {
        char n = c;
        return (n & 0xFF) == n;
    }

    public static String generateValidName(String invalidName) {
        char[] bytes = invalidName.trim().toCharArray();
        StringBuffer sb = new StringBuffer(bytes.length);
        int i = 0;
        while (i < bytes.length) {
            char c = bytes[i];
            if (Element.is8Bit(c)) {
                if (Element.isIllegal(c)) {
                    c = '_';
                }
            } else {
                c = '_';
            }
            sb.append(c);
            ++i;
        }
        if (sb.length() == 0) {
            sb.append('_');
        }
        return sb.toString();
    }

    public static boolean isPotentialNameValid(String nameValue) {
        return AikMin.isValidName(nameValue);
    }

    private void checkForInvalidName(String nameValue) {
        if (nameValue != null) {
            String trimmedNameValue = nameValue.trim();
            if (trimmedNameValue.length() != nameValue.length()) {
                throw new IllegalNameValueException(nameValue, Messages.getString("We_re_sorry__but_names_in_Alice_may_not_have_spaces_at_the_beginning_or_end_"));
            }
            if (nameValue.length() == 0) {
                throw new IllegalNameValueException(nameValue, Messages.getString("We_re_sorry__but_names_in_Alice_may_not_be_empty_"));
            }
            char[] illegalCharacters = new char[]{'\t', '\n', '\\', '/', ':', '*', '?', '\"', '<', '>', '|', '.'};
            int i = 0;
            while (i < illegalCharacters.length) {
                if (nameValue.indexOf(illegalCharacters[i]) != -1) {
                    throw new IllegalNameValueException(nameValue, String.valueOf(Messages.getString("We_re_sorry__but_names_in_Alice_may_only_contain_letters_and_numbers___The_character__")) + illegalCharacters[i] + Messages.getString("__can_not_be_used_in_a_name_"));
                }
                ++i;
            }
            if (!AikMin.isValidName(nameValue)) {
                throw new IllegalNameValueException(nameValue, String.valueOf(Messages.getString("We_re_sorry__but_names_in_Alice_may_only_contain_letters_and_numbers___The_character__")) + "??" + Messages.getString("__can_not_be_used_in_a_name_"));
            }
        }
    }

    private void checkForNameCollision(Element parentValue, String nameValue) {
        Element siblingToBe;
        if (parentValue != null && nameValue != null && (siblingToBe = parentValue.getChildNamedIgnoreCase(nameValue)) != null && siblingToBe != this) {
            throw new IllegalNameValueException(nameValue, String.valueOf(Messages.getString("Unfortunately__something_else_in_this_world_is_already_named__")) + nameValue + Messages.getString("___so_you_can_t_use_that_name_here_"));
        }
    }

    public void HACK_nameChanged() {
        this.markKeepKeyDirty();
        Element[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].HACK_nameChanged();
            ++i;
        }
    }

    protected void nameValueChanging(String nameValueToBe) {
        this.checkForInvalidName(nameValueToBe);
        this.checkForNameCollision(this.m_parent, nameValueToBe);
    }

    protected void nameValueChanged(String value) {
        PropertyReference[] propertyReferences = this.getExternalPropertyReferences(HowMuch.INSTANCE_AND_ALL_DESCENDANTS);
        int i = 0;
        while (i < propertyReferences.length) {
            propertyReferences[i].getProperty().getOwner().markKeepKeyDirty();
            ++i;
        }
    }

    public void propertyCreated(Property property) {
        this.markKeepKeyDirty();
    }

    protected void propertyChanging(Property property, Object value) {
        if (property == this.name) {
            this.nameValueChanging((String)value);
        }
    }

    protected void propertyChanged(Property property, Object value) {
        if (property == this.name) {
            this.nameValueChanged((String)value);
        }
    }

    public final void propertyChanging(PropertyEvent propertyEvent) {
        if (this.isReleased()) {
            throw new RuntimeException(String.valueOf(Messages.getString("property_change_attempted_on_released_element__")) + propertyEvent.getProperty());
        }
        this.propertyChanging(propertyEvent.getProperty(), propertyEvent.getValue());
    }

    public final void propertyChanged(PropertyEvent propertyEvent) {
        if (this.isReleased()) {
            throw new RuntimeException(String.valueOf(Messages.getString("property_changed_on_released_element")) + propertyEvent.getProperty());
        }
        this.propertyChanged(propertyEvent.getProperty(), propertyEvent.getValue());
        if (propertyEvent.getProperty() == this.name) {
            this.getRoot().HACK_nameChanged();
        }
    }

    protected void internalRelease(int pass) {
        this.m_isReleased = true;
        Element[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].internalRelease(pass);
            ++i;
        }
    }

    public final void release() {
        if (!this.m_isReleased) {
            int pass = 0;
            while (pass < 3) {
                this.internalRelease(pass);
                ++pass;
            }
        }
    }

    public boolean isReleased() {
        return this.m_isReleased;
    }

    protected void finalize() throws Throwable {
        if (!this.isReleased()) {
            this.release();
        }
        super.finalize();
    }

    private int indexIn(Element[] array) {
        int i = 0;
        while (i < array.length) {
            if (this == array[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void clearAllReferences(Element[] originals, Element[] replacements, Element[] childrenWithNoReplacements, Vector toBeResolved) {
        Element root = this.getRoot();
        Element[] descendants = root.getDescendants(Element.class, HowMuch.INSTANCE_AND_ALL_DESCENDANTS);
        int i = 0;
        while (i < descendants.length) {
            Element descendant = descendants[i];
            Property[] properties = descendant.getProperties();
            int j = 0;
            while (j < properties.length) {
                Property property = properties[j];
                if (properties[j] instanceof ObjectArrayProperty) {
                    ObjectArrayProperty oap = (ObjectArrayProperty)property;
                    int k = 0;
                    while (k < oap.size()) {
                        Object valueK = oap.get(k);
                        if (valueK instanceof Element) {
                            Element elementK = (Element)valueK;
                            ObjectArrayProperty_Value_Index oap_v_i = null;
                            int index = elementK.indexIn(originals);
                            if (index != -1) {
                                oap_v_i = new ObjectArrayProperty_Value_Index(oap, replacements[index], k);
                            } else {
                                index = elementK.indexIn(childrenWithNoReplacements);
                                if (index != -1) {
                                    oap_v_i = new ObjectArrayProperty_Value_Index(oap, childrenWithNoReplacements[index], k);
                                }
                            }
                            if (oap_v_i != null) {
                                toBeResolved.addElement(oap_v_i);
                                oap.set(k, (Object)null);
                            }
                        }
                        ++k;
                    }
                } else {
                    Object value = properties[j].get();
                    if (value instanceof Element) {
                        Element element = (Element)value;
                        Property_Value p_v = null;
                        int index = element.indexIn(originals);
                        if (index != -1) {
                            p_v = new Property_Value(property, replacements[index]);
                        } else {
                            index = element.indexIn(childrenWithNoReplacements);
                            if (index != -1) {
                                p_v = new Property_Value(property, childrenWithNoReplacements[index]);
                            }
                        }
                        if (p_v != null) {
                            toBeResolved.addElement(p_v);
                            property.set(null);
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private void replace(Element[] originals, Element[] replacements) {
        int i = 0;
        while (i < originals.length) {
            int index;
            Element parent;
            Element original = originals[i];
            Element replacement = replacements[i];
            if (original != null) {
                parent = original.getParent();
                original.setParent(null);
            } else {
                System.err.println(String.valueOf(Messages.getString("WARNING__original_is_null_for_")) + replacement);
                parent = null;
            }
            if (parent != null && (index = parent.indexIn(originals)) != -1) {
                parent = replacements[index];
            }
            replacement.setParent(parent);
            ++i;
        }
    }

    private Element[] getChildrenThatHaveNoReplacements(Element[] originals, Element[] replacements) {
        Vector<Element> vector = new Vector<Element>();
        int i = 0;
        while (i < originals.length) {
            Element original = originals[i];
            Element replacement = replacements[i];
            if (original != null) {
                int j = 0;
                while (j < original.getChildCount()) {
                    Element childJ = original.getChildAt(j);
                    int index = childJ.indexIn(originals);
                    if (index == -1) {
                        vector.addElement(childJ);
                    }
                    ++j;
                }
            }
            ++i;
        }
        Object[] array = new Element[vector.size()];
        vector.copyInto(array);
        return array;
    }

    private void addChildrenThatHaveNoReplacement(Element[] originals, Element[] replacements, Element[] childrenThatHaveNoReplacements) {
        int i = 0;
        while (i < originals.length) {
            Element original = originals[i];
            Element replacement = replacements[i];
            if (original != null) {
                int j = 0;
                while (j < original.getChildCount()) {
                    Element childJ = original.getChildAt(j);
                    int index = childJ.indexIn(originals);
                    if (index == -1) {
                        childJ.setParent(replacement);
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public void replaceWith(Element replacement) {
        Element[] replacements = replacement.getDescendants(Element.class, HowMuch.INSTANCE_AND_ALL_DESCENDANTS);
        Element[] originals = new Element[replacements.length];
        int i = 0;
        while (i < replacements.length) {
            String replacementKey = replacements[i].getKey(replacement);
            originals[i] = this.getDescendantKeyed(replacementKey);
            ++i;
        }
        Element[] childrenThatHaveNoReplacements = this.getChildrenThatHaveNoReplacements(originals, replacements);
        Vector toBeResolved = new Vector();
        this.clearAllReferences(originals, replacements, childrenThatHaveNoReplacements, toBeResolved);
        this.replace(originals, replacements);
        this.addChildrenThatHaveNoReplacement(originals, replacements, childrenThatHaveNoReplacements);
        int i2 = 0;
        while (i2 < toBeResolved.size()) {
            Property_Value p_v = (Property_Value)toBeResolved.elementAt(i2);
            if (p_v instanceof ObjectArrayProperty_Value_Index) {
                ObjectArrayProperty_Value_Index oap_v_i = (ObjectArrayProperty_Value_Index)p_v;
                oap_v_i.getObjectArrayProperty(originals, replacements).set(oap_v_i.getIndex(), oap_v_i.getValue(originals, replacements));
            } else {
                p_v.getProperty(originals, replacements).set(p_v.getValue(originals, replacements));
            }
            ++i2;
        }
    }

    public Class[] getSupportedCoercionClasses() {
        return null;
    }

    public boolean isCoercionSupported() {
        Class[] classes = this.getSupportedCoercionClasses();
        return classes != null && classes.length > 0;
    }

    public Element coerceTo(Class cls) {
        Element coercedElement;
        World world = this.getWorld();
        PropertyReference[] propertyReferences = new PropertyReference[]{};
        String[] keys = new String[]{};
        if (world != null) {
            propertyReferences = world.getPropertyReferencesTo(this, HowMuch.INSTANCE_AND_ALL_DESCENDANTS, false, false);
            keys = new String[propertyReferences.length];
        }
        int i = 0;
        while (i < propertyReferences.length) {
            PropertyReference propertyReference = propertyReferences[i];
            Element reference = propertyReference.getReference();
            keys[i] = reference.getKey(world);
            if (propertyReference instanceof ObjectArrayPropertyReference) {
                ObjectArrayPropertyReference objectArrayPropertyReference = (ObjectArrayPropertyReference)propertyReference;
                ObjectArrayProperty objectArrayProperty = objectArrayPropertyReference.getObjectArrayProperty();
                objectArrayProperty.set(objectArrayPropertyReference.getIndex(), (Object)null);
            } else {
                Property property = propertyReference.getProperty();
                property.set(null);
            }
            ++i;
        }
        try {
            coercedElement = (Element)cls.newInstance();
        }
        catch (IllegalAccessException iae) {
            throw new ExceptionWrapper(iae, cls.toString());
        }
        catch (InstantiationException ie) {
            throw new ExceptionWrapper(ie, cls.toString());
        }
        Element parentValue = this.getParent();
        if (parentValue != null) {
            int indexOfChild = parentValue.getIndexOfChild(this);
            this.setParent(null);
            parentValue.insertChildAt(coercedElement, indexOfChild);
        }
        Element[] children = this.getChildren();
        int i2 = 0;
        while (i2 < children.length) {
            children[i2].setParent(coercedElement);
            ++i2;
        }
        Property[] properties = this.getProperties();
        int i3 = 0;
        while (i3 < properties.length) {
            Property property = properties[i3];
            Property cProperty = coercedElement.getPropertyNamed(property.getName());
            if (cProperty != null) {
                cProperty.set(property.get());
            }
            ++i3;
        }
        i3 = 0;
        while (i3 < propertyReferences.length) {
            PropertyReference propertyReference = propertyReferences[i3];
            String key = keys[i3];
            Element reference = world.getDescendantKeyed(key);
            Property property = propertyReference.getProperty();
            if (property.getOwner() == this) {
                property = coercedElement.getPropertyNamed(property.getName());
            }
            if (property != null) {
                if (propertyReference instanceof ObjectArrayPropertyReference) {
                    ObjectArrayProperty objectArrayProperty = (ObjectArrayProperty)property;
                    objectArrayProperty.set(((ObjectArrayPropertyReference)propertyReference).getIndex(), reference);
                } else {
                    property.set(reference);
                }
            }
            ++i3;
        }
        return coercedElement;
    }

    public Property[] getProperties() {
        if (this.m_propertyArray == null) {
            Class<?> cls = this.getClass();
            Vector<Property> properties = new Vector<Property>();
            Field[] fields = cls.getFields();
            int i = 0;
            while (i < fields.length) {
                Field field = fields[i];
                if (Element.isPropertyField(field)) {
                    try {
                        Property property = (Property)field.get(this);
                        if (property != null) {
                            if (!property.isDeprecated()) {
                                properties.addElement(property);
                            }
                        } else {
                            Element.debugln(String.valueOf(Messages.getString("warning__cannot_find_property_field__")) + field.getName());
                        }
                    }
                    catch (IllegalAccessException iae) {
                        iae.printStackTrace();
                    }
                }
                ++i;
            }
            this.m_propertyArray = new Property[properties.size()];
            properties.copyInto(this.m_propertyArray);
        }
        return this.m_propertyArray;
    }

    public Property getPropertyNamed(String name) {
        Property[] properties = this.getProperties();
        int i = 0;
        while (i < properties.length) {
            Property property = properties[i];
            if (property.getName().equals(name)) {
                return property;
            }
            ++i;
        }
        return null;
    }

    public Property getPropertyNamedIgnoreCase(String name) {
        Property[] properties = this.getProperties();
        int i = 0;
        while (i < properties.length) {
            Property property = properties[i];
            if (property.getName().equalsIgnoreCase(name)) {
                return property;
            }
            ++i;
        }
        return null;
    }

    public Element getParent() {
        return this.m_parent;
    }

    public void setParent(Element parentValue) {
        if (parentValue != this.m_parent) {
            if (this.m_parent != null) {
                this.m_parent.internalRemoveChild(this);
                this.m_parent = null;
            }
            if (parentValue != null) {
                parentValue.addChild(this);
            }
        }
    }

    private void checkAllPropertiesForBadReferences() {
        Property[] properties = this.getProperties();
        int i = 0;
        while (i < properties.length) {
            Property property = properties[i];
            property.checkForBadReferences(property.get());
            ++i;
        }
        i = 0;
        while (i < this.getChildCount()) {
            this.getChildAt(i).checkAllPropertiesForBadReferences();
            ++i;
        }
    }

    protected void internalSetParent(Element parentValue) {
        if (parentValue != null) {
            this.checkForNameCollision(parentValue, this.name.getStringValue());
            if (parentValue == this) {
                throw new RuntimeException(this + " " + Messages.getString("cannot_be_its_own_parent_"));
            }
            if (parentValue.isDescendantOf(this)) {
                throw new RuntimeException(this + " " + Messages.getString("cannot_have_descendant_") + parentValue + " " + Messages.getString("as_its_parent_"));
            }
        }
        Element prevParent = this.m_parent;
        this.m_parent = parentValue;
        try {
            this.checkAllPropertiesForBadReferences();
        }
        catch (RuntimeException re) {
            this.m_parent = prevParent;
            throw re;
        }
    }

    public Element getRoot() {
        if (this.m_parent == null) {
            return this;
        }
        return this.m_parent.getRoot();
    }

    public World getWorld() {
        Element root = this.getRoot();
        if (root instanceof World) {
            return (World)root;
        }
        return null;
    }

    public Sandbox getSandbox() {
        if (this instanceof Sandbox) {
            if (this instanceof World) {
                return (World)this;
            }
            if (this.m_parent instanceof World || this.m_parent instanceof Group) {
                return (Sandbox)this;
            }
        }
        if (this.m_parent == null) {
            return null;
        }
        return this.m_parent.getSandbox();
    }

    public boolean isDescendantOf(Element element) {
        Element parentValue = this.getParent();
        while (parentValue != null) {
            if (parentValue == element) {
                return true;
            }
            parentValue = parentValue.getParent();
        }
        return false;
    }

    public boolean isAncestorOf(Element element) {
        if (element != null) {
            return element.isDescendantOf(this);
        }
        return false;
    }

    private void buildDetailedPath(StringBuffer sb) {
        if (this.m_parent != null) {
            this.m_parent.buildDetailedPath(sb);
        }
        sb.append("\t");
        sb.append(this.name.getStringValue());
        sb.append(" ");
        sb.append(this.getClass());
        sb.append("\n");
    }

    private String getInternalGetKeyExceptionDescription(Element ancestor, Element self, StringBuffer sbKey) {
        StringBuffer sb = new StringBuffer();
        sb.append("Could not find ancestor: ");
        if (ancestor != null) {
            sb.append(ancestor.name.getStringValue());
            sb.append(", class: ");
            sb.append(ancestor.getClass());
        } else {
            sb.append("null");
        }
        sb.append("\nKey: ");
        sb.append(sbKey);
        sb.append("\nDetails: ");
        self.buildDetailedPath(sb);
        return sb.toString();
    }

    private void internalGetKey(Element ancestor, Element self, StringBuffer sb) {
        if (this.m_parent != ancestor && this != ancestor) {
            if (this.m_parent == null && ancestor != null) {
                throw new RuntimeException(this.getInternalGetKeyExceptionDescription(ancestor, self, sb));
            }
            this.m_parent.internalGetKey(ancestor, self, sb);
        }
        if (this != ancestor) {
            sb.append(this.getRepr());
        }
        if (this != self) {
            sb.append('.');
        }
    }

    public String getKey(Element ancestor) {
        StringBuffer sb = new StringBuffer();
        this.internalGetKey(ancestor, this, sb);
        return new String(sb);
    }

    public String getKey() {
        return this.getKey(null);
    }

    public String getTrimmedKey() {
        Element ancestor = this.getSandbox();
        if (ancestor != null) {
            ancestor = ancestor.getParent();
        }
        return this.getKey(ancestor);
    }

    public void addPropertyListenerToAllProperties(PropertyListener propertyListener) {
        Property[] properties = this.getProperties();
        int i = 0;
        while (i < properties.length) {
            Property property = properties[i];
            property.addPropertyListener(propertyListener);
            ++i;
        }
    }

    public void removePropertyListenerFromAllProperties(PropertyListener propertyListener) {
        Property[] properties = this.getProperties();
        int i = 0;
        while (i < properties.length) {
            Property property = properties[i];
            property.removePropertyListener(propertyListener);
            ++i;
        }
    }

    public int getChildCount() {
        return this.m_children.size();
    }

    public Element getChildAt(int index) {
        if (index >= this.m_children.size()) {
            Element.warnln(this + ".getChildAt( " + index + " ) is out of range [0," + this.m_children.size() + ").");
            return null;
        }
        return (Element)this.m_children.elementAt(index);
    }

    public int getIndexOfChild(Element child) {
        return this.m_children.indexOf(child);
    }

    public boolean hasChild(Element child) {
        return this.m_children.contains(child);
    }

    private Element internalGetChildNamed(String nameValue, boolean ignoreCase) {
        if (nameValue != null) {
            if (nameValue.startsWith("__Unnamed") && nameValue.endsWith("__")) {
                Element child = this.getChildAt(Integer.parseInt(nameValue.substring(9, nameValue.length() - 2)));
                if (child != null) {
                    if (child.name.get() == null) {
                        return child;
                    }
                    return null;
                }
                return null;
            }
            int i = 0;
            while (i < this.getChildCount()) {
                boolean found;
                Element child = this.getChildAt(i);
                if (nameValue != null ? (found = ignoreCase ? nameValue.equalsIgnoreCase(child.name.getStringValue()) : nameValue.equals(child.name.getStringValue())) : child.name.getStringValue() == null) {
                    return child;
                }
                ++i;
            }
            return null;
        }
        return null;
    }

    public Element getChildNamed(String nameValue) {
        return this.internalGetChildNamed(nameValue, false);
    }

    public Element getChildNamedIgnoreCase(String nameValue) {
        return this.internalGetChildNamed(nameValue, true);
    }

    private Element internalGetDescendantKeyed(String key, int fromIndex, boolean ignoreCase) {
        if (key.equals("")) {
            return this;
        }
        int toIndex = key.indexOf(46, fromIndex);
        if (toIndex == -1) {
            String childName = key.substring(fromIndex);
            return this.internalGetChildNamed(childName, ignoreCase);
        }
        String childName = key.substring(fromIndex, toIndex);
        Element child = this.internalGetChildNamed(childName, ignoreCase);
        if (child != null) {
            return child.internalGetDescendantKeyed(key, toIndex + 1, ignoreCase);
        }
        return null;
    }

    public Element getDescendantKeyed(String key) {
        return this.internalGetDescendantKeyed(key, 0, false);
    }

    public Element getDescendantKeyedIgnoreCase(String key) {
        return this.internalGetDescendantKeyed(key, 0, true);
    }

    public Element[] getChildren() {
        if (this.m_childArray == null) {
            this.m_childArray = new Element[this.m_children.size()];
            this.m_children.copyInto(this.m_childArray);
        }
        return this.m_childArray;
    }

    public Element[] getChildren(Class cls) {
        Vector v = new Vector();
        int i = 0;
        while (i < this.m_children.size()) {
            Object child = this.m_children.elementAt(i);
            if (cls.isAssignableFrom(child.getClass())) {
                v.addElement(child);
            }
            ++i;
        }
        Object[] array = new Element[v.size()];
        v.copyInto(array);
        return array;
    }

    protected int internalGetElementCount(Class cls, HowMuch howMuch, int count) {
        if (cls.isAssignableFrom(this.getClass())) {
            ++count;
        }
        int i = 0;
        while (i < this.getChildCount()) {
            count = this.getChildAt(i).internalGetElementCount(cls, howMuch, count);
            ++i;
        }
        return count;
    }

    public int getElementCount(Class cls, HowMuch howMuch) {
        return this.internalGetElementCount(cls, howMuch, 0);
    }

    public int getElementCount(Class cls) {
        return this.getElementCount(cls, HowMuch.INSTANCE_AND_ALL_DESCENDANTS);
    }

    public int getElementCount() {
        return this.getElementCount(Element.class);
    }

    public void internalSearch(Criterion criterion, HowMuch howMuch, Vector v) {
        if (criterion.accept(this)) {
            v.addElement(this);
        }
        int i = 0;
        while (i < this.getChildCount()) {
            this.getChildAt(i).internalSearch(criterion, howMuch, v);
            ++i;
        }
    }

    public Element[] search(Criterion criterion, HowMuch howMuch) {
        Vector v = new Vector();
        this.internalSearch(criterion, howMuch, v);
        Object[] array = new Element[v.size()];
        v.copyInto(array);
        return array;
    }

    public Element[] search(Criterion criterion) {
        return this.search(criterion, HowMuch.INSTANCE_AND_ALL_DESCENDANTS);
    }

    public Element[] getDescendants(Class cls, HowMuch howMuch) {
        Element[] elements = this.search(new InstanceOfCriterion(cls), howMuch);
        if (cls == Element.class) {
            return elements;
        }
        Object array = Array.newInstance(cls, elements.length);
        System.arraycopy(elements, 0, array, 0, elements.length);
        return (Element[])array;
    }

    public Element[] getDescendants(Class cls) {
        return this.getDescendants(cls, HowMuch.INSTANCE_AND_ALL_DESCENDANTS);
    }

    public Element[] getDescendants() {
        return this.getDescendants(Element.class);
    }

    public void setPropertyNamed(String name, Object value, HowMuch howMuch) {
        Property property = this.getPropertyNamed(name);
        if (property != null) {
            property.set(value, howMuch);
        } else {
            int i = 0;
            while (i < this.m_children.size()) {
                Element child = this.getChildAt(i);
                child.setPropertyNamed(name, value, howMuch);
                ++i;
            }
        }
    }

    public void setPropertyNamed(String name, Object value) {
        this.setPropertyNamed(name, value, HowMuch.INSTANCE_AND_PARTS);
    }

    private void onChildrenChanging(ChildrenEvent childrenEvent) {
        Enumeration enum0 = this.m_childrenListeners.elements();
        while (enum0.hasMoreElements()) {
            ChildrenListener childrenListener = (ChildrenListener)enum0.nextElement();
            childrenListener.childrenChanging(childrenEvent);
        }
    }

    private void onChildrenChange(ChildrenEvent childrenEvent) {
        this.m_childArray = null;
        this.markKeepKeyDirty();
        Enumeration enum0 = this.m_childrenListeners.elements();
        while (enum0.hasMoreElements()) {
            ChildrenListener childrenListener = (ChildrenListener)enum0.nextElement();
            childrenListener.childrenChanged(childrenEvent);
        }
    }

    private boolean internalRemoveChild(Element child) {
        int oldIndex = this.m_children.indexOf(child);
        if (oldIndex != -1) {
            ChildrenEvent childrenEvent = new ChildrenEvent(this, child, 3, oldIndex, -1);
            this.onChildrenChanging(childrenEvent);
            this.m_children.removeElementAt(oldIndex);
            this.onChildrenChange(childrenEvent);
            return true;
        }
        return false;
    }

    public void insertChildAt(Element child, int index) {
        if (child.getParent() == this) {
            int oldIndex = this.m_children.indexOf(child);
            if (index != oldIndex) {
                ChildrenEvent childrenEvent = new ChildrenEvent(this, child, 2, oldIndex, index);
                this.onChildrenChanging(childrenEvent);
                this.m_children.removeElementAt(oldIndex);
                if (index == -1) {
                    index = this.m_children.size();
                }
                this.m_children.insertElementAt(child, index);
                this.onChildrenChange(childrenEvent);
            }
        } else {
            if (index == -1) {
                index = this.m_children.size();
            }
            if (this.m_children.contains(child)) {
                throw new RuntimeException(child + " " + Messages.getString("is_already_a_child_of_") + this);
            }
            child.internalSetParent(this);
            ChildrenEvent childrenEvent = new ChildrenEvent(this, child, 1, -1, index);
            this.onChildrenChanging(childrenEvent);
            this.m_children.insertElementAt(child, index);
            this.onChildrenChange(childrenEvent);
        }
    }

    public void addChild(Element child) {
        this.insertChildAt(child, -1);
    }

    public void removeChild(Element child) {
        if (this.internalRemoveChild(child)) {
            child.internalSetParent(null);
        } else {
            Element.warnln(String.valueOf(Messages.getString("WARNING__could_not_remove_child_")) + child + Messages.getString("___it_is_not_a_child_of_") + this);
        }
    }

    public void addChildrenListener(ChildrenListener childrenListener) {
        this.m_childrenListeners.addElement(childrenListener);
        this.m_childrenListenerArray = null;
    }

    public void removeChildrenListener(ChildrenListener childrenListener) {
        this.m_childrenListeners.removeElement(childrenListener);
        this.m_childrenListenerArray = null;
    }

    public ChildrenListener[] getChildrenListeners() {
        if (this.m_childrenListenerArray == null) {
            this.m_childrenListenerArray = new ChildrenListener[this.m_childrenListeners.size()];
            this.m_childrenListeners.copyInto(this.m_childrenListenerArray);
        }
        return this.m_childrenListenerArray;
    }

    public void visit(VisitListener visitListener, HowMuch howMuch) {
        visitListener.visited(this);
        if (howMuch.getDescend()) {
            int i = 0;
            while (i < this.getChildCount()) {
                Element child = this.getChildAt(i);
                if (!howMuch.getRespectDescendant() || !child.isFirstClass.booleanValue()) {
                    child.visit(visitListener, howMuch);
                }
                ++i;
            }
        }
    }

    public boolean isReferenceInternalTo(Element whom) {
        return this == whom || this.isDescendantOf(whom);
    }

    public boolean isReferenceExternalFrom(Element whom) {
        return !this.isReferenceInternalTo(whom);
    }

    protected void internalGetExternalPropertyReferences(Element whom, HowMuch howMuch, Vector references) {
        Property[] properties = this.getProperties();
        int i = 0;
        while (i < properties.length) {
            if (properties[i] instanceof ObjectArrayProperty) {
                ObjectArrayProperty objectArrayProperty = (ObjectArrayProperty)properties[i];
                int precedingTotal = 0;
                int j = 0;
                while (j < objectArrayProperty.size()) {
                    Object o = objectArrayProperty.get(j);
                    if (o instanceof Element && ((Element)o).isReferenceExternalFrom(whom)) {
                        references.addElement(new ObjectArrayPropertyReference(objectArrayProperty, null, j, precedingTotal++));
                    }
                    ++j;
                }
            } else {
                Object o = properties[i].get();
                if (o instanceof Element && ((Element)o).isReferenceExternalFrom(whom)) {
                    references.addElement(new PropertyReference(properties[i], null));
                }
            }
            ++i;
        }
        if (howMuch.getDescend()) {
            i = 0;
            while (i < this.getChildCount()) {
                Element child = this.getChildAt(i);
                if (!child.isFirstClass.booleanValue() || !howMuch.getRespectDescendant()) {
                    child.internalGetExternalPropertyReferences(whom, howMuch, references);
                }
                ++i;
            }
        }
    }

    public PropertyReference[] getExternalPropertyReferences(HowMuch howMuch) {
        Vector references = new Vector();
        this.internalGetExternalPropertyReferences(this, howMuch, references);
        Object[] referencesArray = new PropertyReference[references.size()];
        references.copyInto(referencesArray);
        return referencesArray;
    }

    public PropertyReference[] getExternalPropertyReferences() {
        return this.getExternalPropertyReferences(HowMuch.INSTANCE_AND_ALL_DESCENDANTS);
    }

    protected void internalGetPropertyReferencesTo(Element whom, HowMuch howMuch, boolean excludeWhomsParent, boolean excludeWhomAndItsDescendants, Vector references) {
        if (excludeWhomAndItsDescendants && (this == whom || this.isDescendantOf(whom))) {
            return;
        }
        if (this != whom.getParent() || !excludeWhomsParent) {
            Property[] properties = this.getProperties();
            int i = 0;
            while (i < properties.length) {
                if (properties[i] instanceof ObjectArrayProperty) {
                    ObjectArrayProperty objectArrayProperty = (ObjectArrayProperty)properties[i];
                    int precedingTotal = 0;
                    int j = 0;
                    while (j < objectArrayProperty.size()) {
                        Object o = objectArrayProperty.get(j);
                        if (o instanceof Element && ((Element)o).isReferenceInternalTo(whom)) {
                            references.addElement(new ObjectArrayPropertyReference(objectArrayProperty, null, j, precedingTotal++));
                        }
                        ++j;
                    }
                } else {
                    Object o = properties[i].get();
                    if (o instanceof Element && ((Element)o).isReferenceInternalTo(whom)) {
                        references.addElement(new PropertyReference(properties[i], null));
                    }
                }
                ++i;
            }
        }
        if (howMuch.getDescend()) {
            int i = 0;
            while (i < this.getChildCount()) {
                Element child = this.getChildAt(i);
                if (!child.isFirstClass.booleanValue() || !howMuch.getRespectDescendant()) {
                    child.internalGetPropertyReferencesTo(whom, howMuch, excludeWhomsParent, excludeWhomAndItsDescendants, references);
                }
                ++i;
            }
        }
    }

    public PropertyReference[] getPropertyReferencesTo(Element whom, HowMuch howMuch, boolean excludeWhomsParent, boolean excludeWhomAndItsDescendants) {
        Vector references = new Vector();
        this.internalGetPropertyReferencesTo(whom, howMuch, excludeWhomsParent, excludeWhomAndItsDescendants, references);
        Object[] referencesArray = new PropertyReference[references.size()];
        references.copyInto(referencesArray);
        return referencesArray;
    }

    public PropertyReference[] getPropertyReferencesTo(Element whom, HowMuch howMuch, boolean excludeWhomsParent) {
        return this.getPropertyReferencesTo(whom, howMuch, excludeWhomsParent, true);
    }

    public PropertyReference[] getPropertyReferencesTo(Element whom, HowMuch howMuch) {
        return this.getPropertyReferencesTo(whom, howMuch, true);
    }

    public PropertyReference[] getPropertyReferencesTo(Element whom) {
        return this.getPropertyReferencesTo(whom, HowMuch.INSTANCE_AND_ALL_DESCENDANTS);
    }

    public PropertyReference[] getPropertyReferencesToMe(Element fromWhom, HowMuch howMuch, boolean excludeMyParent, boolean excludeMeAndMyDescendants) {
        return fromWhom.getPropertyReferencesTo(this, howMuch, excludeMyParent, excludeMeAndMyDescendants);
    }

    public PropertyReference[] getPropertyReferencesToMe(Element fromWhom, HowMuch howMuch, boolean excludeMyParent) {
        return this.getPropertyReferencesToMe(fromWhom, howMuch, excludeMyParent, true);
    }

    public PropertyReference[] getPropertyReferencesToMe(Element fromWhom, HowMuch howMuch) {
        return this.getPropertyReferencesToMe(fromWhom, howMuch, true);
    }

    public PropertyReference[] getPropertyReferencesToMe(Element fromWhom) {
        return this.getPropertyReferencesToMe(fromWhom, HowMuch.INSTANCE_AND_ALL_DESCENDANTS);
    }

    public PropertyReference[] getPropertyReferencesToMe() {
        return this.getPropertyReferencesToMe(this.getRoot());
    }

    public void removeFromParentsProperties() {
        Element parentValue = this.getParent();
        if (parentValue != null) {
            PropertyReference[] parentReferences = parentValue.getPropertyReferencesTo(this, HowMuch.INSTANCE, false, true);
            int i = 0;
            while (i < parentReferences.length) {
                if (parentReferences[i] instanceof ObjectArrayPropertyReference) {
                    ObjectArrayPropertyReference oapr = (ObjectArrayPropertyReference)parentReferences[i];
                    oapr.getObjectArrayProperty().remove(oapr.getIndex() - oapr.getPrecedingTotal());
                } else {
                    parentReferences[i].getProperty().set(null);
                }
                ++i;
            }
        }
    }

    public void removeFromParent() {
        Element root = this.getRoot();
        PropertyReference[] externalReferences = root.getPropertyReferencesTo(this, HowMuch.INSTANCE_AND_ALL_DESCENDANTS, true, true);
        if (externalReferences.length > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append("ExternalReferenceException:\n");
            int i = 0;
            while (i < externalReferences.length) {
                sb.append(externalReferences[i]);
                sb.append("\n");
                ++i;
            }
            throw new RuntimeException(sb.toString());
        }
        this.removeFromParentsProperties();
        this.setParent(null);
    }

    public void HACK_removeFromParentWithoutCheckingForExternalReferences() {
        this.removeFromParentsProperties();
        this.setParent(null);
    }

    public boolean isAssignableToOneOf(Class[] classes) {
        if (classes != null) {
            Class<?> cls = this.getClass();
            int i = 0;
            while (i < classes.length) {
                if (classes[i].isAssignableFrom(cls)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private CopyFactory createCopyFactory(Class[] classesToShare, HowMuch howMuch, Element internalReferenceRoot) {
        return new CopyFactory(this, internalReferenceRoot, classesToShare, howMuch);
    }

    public CopyFactory createCopyFactory(Class[] classesToShare, HowMuch howMuch) {
        return this.createCopyFactory(classesToShare, HowMuch.INSTANCE_AND_ALL_DESCENDANTS, this);
    }

    public CopyFactory createCopyFactory(Class[] classesToShare) {
        return this.createCopyFactory(classesToShare, HowMuch.INSTANCE_AND_ALL_DESCENDANTS);
    }

    public CopyFactory createCopyFactory() {
        return this.createCopyFactory(null);
    }

    public Element HACK_createCopy(String name, Element parent, int index, Class[] classesToShare, Element parentToBe) {
        CopyFactory copyFactory = this.createCopyFactory(classesToShare);
        try {
            Element dst = copyFactory.manufactureCopy(this.getRoot(), null, null, parentToBe);
            dst.name.set(name);
            if (parent != null) {
                parent.insertChildAt(dst, index);
            }
            return dst;
        }
        catch (UnresolvablePropertyReferencesException upre) {
            upre.printStackTrace();
            throw new ExceptionWrapper(upre, "UnresolvablePropertyReferencesException");
        }
    }

    public Element createCopyNamed(String name, Class[] classesToShare) {
        CopyFactory copyFactory = this.createCopyFactory(classesToShare);
        try {
            Element dst = copyFactory.manufactureCopy(this.getRoot());
            dst.name.set(name);
            return dst;
        }
        catch (UnresolvablePropertyReferencesException upre) {
            upre.printStackTrace();
            throw new ExceptionWrapper(upre, "UnresolvablePropertyReferencesException");
        }
    }

    public Element createCopyNamed(String name) {
        return this.createCopyNamed(name, null);
    }

    protected void internalCopyOver(Element dst, boolean isTopLevel, Dictionary childCopyFactoryToParentMap) {
        Element[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            Element child = children[i];
            String childName = child.name.getStringValue();
            Element dstChild = null;
            if (childName == null || childName.equals("__ita__")) {
                Element[] itas = dst.getChildren(IndexedTriangleArray.class);
                if (itas.length > 0) {
                    dstChild = itas[0];
                }
            } else {
                dstChild = dst.getChildNamedIgnoreCase(childName);
            }
            if (dstChild != null) {
                child.internalCopyOver(dstChild, false, childCopyFactoryToParentMap);
            } else {
                CopyFactory childCopyFactory = child.createCopyFactory(null, HowMuch.INSTANCE_AND_ALL_DESCENDANTS, this);
                childCopyFactoryToParentMap.put(childCopyFactory, dst);
            }
            ++i;
        }
        Property[] properties = this.getProperties();
        int i2 = 0;
        while (i2 < properties.length) {
            Property dstProperty;
            Object value;
            String propertyName;
            Property property = properties[i2];
            if (!(isTopLevel && ((propertyName = property.getName()).equals("name") || propertyName.equals("vehicle") || propertyName.equals("localTransformation")) || property instanceof ObjectArrayProperty && !(property instanceof VertexArrayProperty) || (value = property.get()) instanceof Element || (dstProperty = dst.getPropertyNamed(property.getName())) == null)) {
                dstProperty.set(value);
            }
            ++i2;
        }
    }

    protected void HACK_copyOverTextureMapReferences(Element dst, Dictionary srcTextureMapToDstTextureMapMap) {
        Element[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            Element child = children[i];
            Element dstChild = dst.getChildNamedIgnoreCase(child.name.getStringValue());
            if (dstChild != null) {
                child.HACK_copyOverTextureMapReferences(dstChild, srcTextureMapToDstTextureMapMap);
            }
            ++i;
        }
    }

    public void copyOver(Element dst) {
        Hashtable childCopyFactoryToParentMap = new Hashtable();
        this.internalCopyOver(dst, true, childCopyFactoryToParentMap);
        Enumeration enum0 = ((Dictionary)childCopyFactoryToParentMap).keys();
        while (enum0.hasMoreElements()) {
            CopyFactory childCopyFactory = (CopyFactory)enum0.nextElement();
            Element parent = (Element)((Dictionary)childCopyFactoryToParentMap).get(childCopyFactory);
            try {
                Element child = childCopyFactory.manufactureCopy(this.getRoot(), parent, null, parent);
                child.setParent(parent);
            }
            catch (UnresolvablePropertyReferencesException upre) {
                throw new ExceptionWrapper(upre, "UnresolvablePropertyReferencesException");
            }
        }
        if (this instanceof Sandbox && dst instanceof Sandbox) {
            TextureMap[] srcTMs = (TextureMap[])((Sandbox)this).textureMaps.getArrayValue();
            TextureMap[] dstTMs = (TextureMap[])((Sandbox)dst).textureMaps.getArrayValue();
            Hashtable<TextureMap, TextureMap> srcTextureMapToDstTextureMapMap = new Hashtable<TextureMap, TextureMap>();
            int i = 0;
            while (i < srcTMs.length) {
                TextureMap srcTM = srcTMs[i];
                int j = 0;
                while (j < srcTMs.length) {
                    TextureMap dstTM = dstTMs[i];
                    if (srcTM.name.getStringValue().equals(dstTM.name.getStringValue())) {
                        ((Dictionary)srcTextureMapToDstTextureMapMap).put(srcTM, dstTM);
                        break;
                    }
                    ++j;
                }
                ++i;
            }
            this.HACK_copyOverTextureMapReferences(dst, srcTextureMapToDstTextureMapMap);
        }
    }

    protected void loadCompleted() {
        int i = 0;
        while (i < this.getChildCount()) {
            this.getChildAt(i).loadCompleted();
            ++i;
        }
    }

    protected static Element load(DocumentBuilder builder, DirectoryTreeLoader loader, Vector referencesToBeResolved, ProgressObserver progressObserver) throws IOException, ProgressCancelException {
        String currentDirectory = loader.getCurrentDirectory();
        try {
            InputStream inputStream = loader.readFile(XML_FILENAME);
            InputStreamReader reader = new InputStreamReader(inputStream, "UTF-8");
            InputSource is = new InputSource(reader);
            Document document = builder.parse(is);
            org.w3c.dom.Element elementNode = document.getDocumentElement();
            elementNode.normalize();
            String classname = elementNode.getAttribute("class");
            double version = Double.parseDouble(elementNode.getAttribute("version"));
            String nameValue = elementNode.getAttribute("name");
            try {
                Class<?> cls = Class.forName(classname);
                Element element = (Element)cls.newInstance();
                try {
                    element.m_xmlFileKeepKey = loader.getKeepKey(XML_FILENAME);
                }
                catch (KeepFileNotSupportedException kfnse) {
                    element.m_xmlFileKeepKey = null;
                }
                if (nameValue.length() > 0) {
                    element.name.set(nameValue);
                }
                NodeList propertyNodeList = elementNode.getElementsByTagName("property");
                int i = 0;
                while (i < propertyNodeList.getLength()) {
                    org.w3c.dom.Element propertyNode = (org.w3c.dom.Element)propertyNodeList.item(i);
                    String propertyName = propertyNode.getAttribute("name").trim();
                    Property property = element.getPropertyNamed(propertyName);
                    if (property != null) {
                        property.decode(propertyNode, loader, referencesToBeResolved, version);
                    } else {
                        Element.warnln(String.valueOf(classname) + " has no property: " + propertyName);
                    }
                    ++i;
                }
                ++s_loadProgress;
                if (progressObserver != null) {
                    progressObserver.progressUpdate(s_loadProgress, element.name.getStringValue());
                }
                NodeList childNodeList = elementNode.getElementsByTagName("child");
                int i2 = 0;
                while (i2 < childNodeList.getLength()) {
                    org.w3c.dom.Element childNode = (org.w3c.dom.Element)childNodeList.item(i2);
                    String filename = childNode.getAttribute("filename").trim();
                    loader.setCurrentDirectory(filename);
                    Element child = Element.load(builder, loader, referencesToBeResolved, progressObserver);
                    String childName = child.name.getStringValue();
                    if (childName != null && element.getChildNamed(childName) != null) {
                        child = null;
                        System.err.println(element + " " + Messages.getString("already_has_child_named_") + childName + Messages.getString("___skipping_"));
                    }
                    if (child != null) {
                        element.addChild(child);
                    }
                    loader.setCurrentDirectory(currentDirectory);
                    ++i2;
                }
                return element;
            }
            catch (ClassNotFoundException cnfe) {
                throw new ExceptionWrapper(cnfe, "ClassNotFoundException: " + classname);
            }
            catch (InstantiationException ie) {
                throw new ExceptionWrapper(ie, "InstantiationException: " + classname);
            }
            catch (IllegalAccessException iae) {
                throw new ExceptionWrapper(iae, "IllegalAccessException: " + classname);
            }
        }
        catch (SAXException saxe) {
            throw new ExceptionWrapper(saxe, "org.xml.sax.SAXException");
        }
    }

    public static Element load(DirectoryTreeLoader loader, Element externalRoot, ProgressObserver progressObserver) throws IOException, ProgressCancelException, UnresolvablePropertyReferencesException {
        Element element;
        Vector referencesToBeResolved = new Vector();
        Vector<PropertyReference> referencesLeftUnresolved = new Vector<PropertyReference>();
        try {
            s_isLoading = true;
            int elementCount = -1;
            try {
                BufferedReader br = new BufferedReader(new InputStreamReader(new BufferedInputStream(loader.readFile("elementCountHint.txt"))));
                elementCount = Integer.parseInt(br.readLine().replaceAll("\\D", ""));
                loader.closeCurrentFile();
            }
            catch (FileNotFoundException br) {
                // empty catch block
            }
            s_loadProgress = 0;
            if (progressObserver != null) {
                progressObserver.progressBegin(elementCount);
            }
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                element = Element.load(builder, loader, referencesToBeResolved, progressObserver);
                DefaultReferenceResolver referenceResolver = new DefaultReferenceResolver(element, externalRoot);
                Enumeration enum0 = referencesToBeResolved.elements();
                while (enum0.hasMoreElements()) {
                    PropertyReference propertyReference = (PropertyReference)enum0.nextElement();
                    try {
                        propertyReference.resolve(referenceResolver);
                    }
                    catch (UnresolvableReferenceException ure) {
                        referencesLeftUnresolved.add(propertyReference);
                    }
                    catch (Throwable t) {
                        System.err.println(propertyReference);
                        t.printStackTrace();
                    }
                }
            }
            catch (ParserConfigurationException pce) {
                throw new ExceptionWrapper(pce, "loader: " + loader + "; externalRoot: " + externalRoot);
            }
        }
        finally {
            if (progressObserver != null) {
                progressObserver.progressEnd();
            }
            s_isLoading = false;
        }
        if (referencesLeftUnresolved.size() == 0) {
            element.loadCompleted();
            return element;
        }
        Object[] propertyReferences = new PropertyReference[referencesLeftUnresolved.size()];
        referencesLeftUnresolved.copyInto(propertyReferences);
        throw new UnresolvablePropertyReferencesException((PropertyReference[])propertyReferences, element, "loader: " + loader + "; externalRoot: " + externalRoot);
    }

    public static Element load(File file, Element externalRoot, ProgressObserver progressObserver) throws IOException, ProgressCancelException, UnresolvablePropertyReferencesException {
        DirectoryTreeLoader loader = null;
        if (file.isDirectory()) {
            loader = new FileSystemTreeLoader();
        } else {
            String pathname = file.getAbsolutePath();
            if (pathname.endsWith(".a2w") || pathname.endsWith(".a2c") || pathname.endsWith(".zip")) {
                loader = new ZipFileTreeLoader();
            } else {
                throw new IllegalArgumentException(file + " " + Messages.getString("must_be_a_directory_or_end_in___a2w_____a2c___or___zip__"));
            }
        }
        loader.open(file);
        Element element = null;
        try {
            element = Element.load(loader, externalRoot, progressObserver);
        }
        finally {
            loader.close();
        }
        return element;
    }

    public static Element load(URL url, Element externalRoot, ProgressObserver progressObserver) throws IOException, ProgressCancelException, UnresolvablePropertyReferencesException {
        ZipTreeLoader loader = new ZipTreeLoader();
        loader.open(url);
        Element element = null;
        try {
            element = Element.load(loader, externalRoot, progressObserver);
        }
        finally {
            loader.close();
        }
        return element;
    }

    public static Element load(InputStream is, Element externalRoot, ProgressObserver progressObserver) throws IOException, ProgressCancelException, UnresolvablePropertyReferencesException {
        ZipTreeLoader loader = new ZipTreeLoader();
        loader.open(is);
        Element element = null;
        try {
            element = Element.load(loader, externalRoot, progressObserver);
        }
        finally {
            loader.close();
        }
        return element;
    }

    public static Element load(InputStream is, Element externalRoot) throws IOException, UnresolvablePropertyReferencesException {
        try {
            return Element.load(is, externalRoot, null);
        }
        catch (ProgressCancelException pce) {
            throw new Error();
        }
    }

    public static Element load(File file, Element externalRoot) throws IOException, UnresolvablePropertyReferencesException {
        try {
            return Element.load(file, externalRoot, null);
        }
        catch (ProgressCancelException pce) {
            throw new Error();
        }
    }

    public static Element load(URL url, Element externalRoot) throws IOException, UnresolvablePropertyReferencesException {
        try {
            return Element.load(url, externalRoot, null);
        }
        catch (ProgressCancelException pce) {
            throw new Error();
        }
    }

    private void writeXMLDocument(Document xmlDocument, DirectoryTreeStorer storer, String filename) throws IOException {
        OutputStream os = storer.createFile(filename, true);
        Encoder.write(xmlDocument, os);
        storer.closeCurrentFile();
    }

    protected int internalStore(DocumentBuilder builder, DirectoryTreeStorer storer, ProgressObserver progressObserver, HowMuch howMuch, ReferenceGenerator referenceGenerator, int count) throws IOException, ProgressCancelException {
        Object xmlFileKeepKey;
        ++count;
        if (progressObserver != null) {
            progressObserver.progressUpdate(count, this.getKey());
        }
        try {
            xmlFileKeepKey = storer.getKeepKey(XML_FILENAME);
        }
        catch (KeepFileNotSupportedException kfnse) {
            xmlFileKeepKey = null;
        }
        if (this.m_xmlFileKeepKey == null || !this.m_xmlFileKeepKey.equals(xmlFileKeepKey)) {
            Document document = builder.newDocument();
            org.w3c.dom.Element elementNode = document.createElement("element");
            elementNode.setAttribute("class", this.getClass().getName());
            elementNode.setAttribute("version", Double.toString(2.001));
            document.appendChild(elementNode);
            int i = 0;
            while (i < this.getChildCount()) {
                org.w3c.dom.Element childNode = document.createElement("child");
                childNode.setAttribute("filename", this.getChildAt(i).getRepr(i));
                elementNode.appendChild(childNode);
                ++i;
            }
            Property[] properties = this.getProperties();
            int i2 = 0;
            while (i2 < properties.length) {
                String propertyName = properties[i2].getName();
                if (propertyName.equals("name")) {
                    String nameValue = this.name.getStringValue();
                    if (nameValue != null) {
                        elementNode.setAttribute("name", nameValue);
                    }
                } else {
                    org.w3c.dom.Element propertyNode = document.createElement("property");
                    propertyNode.setAttribute("name", properties[i2].getName());
                    properties[i2].encode(document, propertyNode, storer, referenceGenerator);
                    elementNode.appendChild(propertyNode);
                }
                ++i2;
            }
            document.getDocumentElement().normalize();
            this.writeXMLDocument(document, storer, XML_FILENAME);
            try {
                this.m_xmlFileKeepKey = storer.getKeepKey(XML_FILENAME);
            }
            catch (KeepFileNotSupportedException kfnse) {
                this.m_xmlFileKeepKey = null;
            }
        } else {
            try {
                storer.keepFile(XML_FILENAME);
                Property[] properties = this.getProperties();
                int i = 0;
                while (i < properties.length) {
                    if (properties[i].get() != null) {
                        properties[i].keepAnyAssociatedFiles(storer);
                    }
                    ++i;
                }
            }
            catch (KeepFileNotSupportedException kfnse) {
                kfnse.printStackTrace();
            }
            catch (KeepFileDoesNotExistException kfdne) {
                kfdne.printStackTrace();
            }
        }
        String thisDirectory = storer.getCurrentDirectory();
        int i = 0;
        while (i < this.getChildCount()) {
            Element child = this.getChildAt(i);
            String name = child.getRepr(i);
            storer.createDirectory(name);
            storer.setCurrentDirectory(name);
            count = child.internalStore(builder, storer, progressObserver, howMuch, referenceGenerator, count);
            storer.setCurrentDirectory(thisDirectory);
            ++i;
        }
        return count;
    }

    public void store(DirectoryTreeStorer storer, ProgressObserver progressObserver, Dictionary filnameToByteArrayMap, HowMuch howMuch, ReferenceGenerator referenceGenerator) throws IOException, ProgressCancelException {
        int elementCount = this.getElementCount(Element.class, howMuch);
        if (progressObserver != null) {
            progressObserver.progressBegin(elementCount);
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new BufferedOutputStream(storer.createFile("elementCountHint.txt", true))));
        writer.write(Integer.toString(elementCount));
        writer.newLine();
        writer.flush();
        storer.closeCurrentFile();
        if (filnameToByteArrayMap != null && filnameToByteArrayMap.size() > 0) {
            Enumeration enum0 = filnameToByteArrayMap.keys();
            while (enum0.hasMoreElements()) {
                String filename = (String)enum0.nextElement();
                byte[] byteArray = (byte[])filnameToByteArrayMap.get(filename);
                OutputStream os = storer.createFile(filename, false);
                os.write(byteArray);
                os.flush();
                storer.closeCurrentFile();
            }
        }
        try {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                int storeCount = this.internalStore(builder, storer, progressObserver, howMuch, referenceGenerator, 0);
                if (elementCount != storeCount) {
                    Element.warnln(String.valueOf(Messages.getString("WARNING__elementCount_")) + elementCount + " " + Messages.getString("not_equal_storeCount_") + storeCount);
                }
            }
            catch (ParserConfigurationException pce) {
                pce.printStackTrace();
                if (progressObserver != null) {
                    progressObserver.progressEnd();
                }
            }
        }
        finally {
            if (progressObserver != null) {
                progressObserver.progressEnd();
            }
        }
    }

    public void store(DirectoryTreeStorer storer, ProgressObserver progressObserver, Dictionary filnameToByteArrayMap, HowMuch howMuch) throws IOException, ProgressCancelException {
        this.store(storer, progressObserver, filnameToByteArrayMap, howMuch, new DefaultReferenceGenerator(this));
    }

    public void store(DirectoryTreeStorer storer, ProgressObserver progressObserver, Dictionary filnameToByteArrayMap) throws IOException, ProgressCancelException {
        this.store(storer, progressObserver, filnameToByteArrayMap, HowMuch.INSTANCE_AND_ALL_DESCENDANTS);
    }

    public void store(DirectoryTreeStorer storer, ProgressObserver progressObserver) throws IOException, ProgressCancelException {
        this.store(storer, progressObserver, null);
    }

    public void store(DirectoryTreeStorer storer) throws IOException {
        try {
            this.store(storer, null);
        }
        catch (ProgressCancelException pce) {
            throw new Error();
        }
    }

    public void store(File file, ProgressObserver progressObserver, Dictionary filnameToByteArrayMap) throws IOException, ProgressCancelException {
        String pathname;
        DirectoryTreeStorer storer = file.isDirectory() ? new FileSystemTreeStorer() : ((pathname = file.getAbsolutePath()).endsWith(".a2w") || pathname.endsWith(".a2c") || pathname.endsWith(".zip") ? (pathname.endsWith(".a2c") ? new ZipTreeStorer() : new ZipFileTreeStorer()) : new FileSystemTreeStorer());
        storer.open(file);
        try {
            this.store(storer, progressObserver, filnameToByteArrayMap);
        }
        finally {
            storer.close();
        }
    }

    public void store(File file, ProgressObserver progressObserver) throws IOException, ProgressCancelException {
        this.store(file, progressObserver, null);
    }

    public void store(File file) throws IOException {
        try {
            this.store(file, null);
        }
        catch (ProgressCancelException pce) {
            throw new Error();
        }
    }

    public void store(String filename, ProgressObserver progressObserver) throws IOException, ProgressCancelException {
        this.store(new File(filename), progressObserver);
    }

    public void store(String filename) throws IOException {
        try {
            this.store(filename, null);
        }
        catch (ProgressCancelException pce) {
            throw new Error();
        }
    }

    private String getUnnamedRepr(int childIndex) {
        return "__Unnamed" + childIndex + "__";
    }

    public String getRepr(int childIndex) {
        String nameValue = this.name.getStringValue();
        if (nameValue == null || nameValue.length() == 0) {
            nameValue = this.getUnnamedRepr(childIndex);
        }
        return nameValue;
    }

    public String getRepr() {
        String nameValue = (String)this.name.get();
        if (nameValue == null) {
            int childIndex = this.m_parent != null ? this.m_parent.getIndexOfChild(this) : 0;
            nameValue = this.getUnnamedRepr(childIndex);
        }
        return nameValue;
    }

    protected void started(World world, double time) {
        Element[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].started(world, time);
            ++i;
        }
    }

    protected void stopped(World world, double time) {
        Element[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].stopped(world, time);
            ++i;
        }
    }

    public static void warn(Object o) {
        edu.cmu.cs.stage3.alice.scenegraph.Element.warn(o);
    }

    public static void warnln(Object o) {
        edu.cmu.cs.stage3.alice.scenegraph.Element.warnln(o);
    }

    public static void warnln() {
        edu.cmu.cs.stage3.alice.scenegraph.Element.warnln();
    }

    public static void debug(Object o) {
        System.err.print(o);
    }

    public static void debugln(Object o) {
        System.err.println(o);
    }

    public static Class getValueClassForPropertyNamed(Class elementClass, String propertyName) {
        Element element = (Element)s_classToElementCache.get(elementClass);
        if (element == null) {
            try {
                element = (Element)elementClass.newInstance();
                s_classToElementCache.put(elementClass, element);
            }
            catch (InstantiationException ie) {
                return null;
            }
            catch (IllegalAccessException iae) {
                return null;
            }
        }
        Property property = element.getPropertyNamed(propertyName);
        return property.getValueClass();
    }

    public boolean isAccessibleFrom(Element e) {
        return true;
    }

    protected void internalAddExpressionIfAssignableTo(Expression expression, Class cls, Vector v) {
        if (expression != null && cls.isAssignableFrom(expression.getValueClass())) {
            v.addElement(expression);
        }
    }

    protected void internalFindAccessibleExpressions(Class cls, Vector v) {
        if (this.m_parent != null) {
            this.m_parent.internalFindAccessibleExpressions(cls, v);
        }
    }

    public Expression[] findAccessibleExpressions(Class cls) {
        Vector v = new Vector();
        this.internalFindAccessibleExpressions(cls, v);
        Vector newVect = new Vector(new LinkedHashSet(v));
        Object[] array = new Expression[newVect.size()];
        newVect.copyInto(array);
        return array;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.getKey() + "]";
    }

    private class ObjectArrayProperty_Value_Index
    extends Property_Value {
        private int m_index;

        public ObjectArrayProperty_Value_Index(ObjectArrayProperty objectArrayProperty, Element value, int index) {
            super(objectArrayProperty, value);
            this.m_index = index;
        }

        public ObjectArrayProperty getObjectArrayProperty(Element[] originals, Element[] replacements) {
            return (ObjectArrayProperty)this.getProperty(originals, replacements);
        }

        public int getIndex() {
            return this.m_index;
        }

        @Override
        public String toString() {
            return String.valueOf(super.toString()) + " " + this.m_index;
        }
    }

    private class Property_Value {
        private Property m_property;
        private Element m_value;

        public Property_Value(Property property, Element value) {
            this.m_property = property;
            this.m_value = value;
        }

        public Property getProperty(Element[] originals, Element[] replacements) {
            Element propertyOwner = this.m_property.getOwner();
            int index = propertyOwner.indexIn(originals);
            if (index != -1) {
                return replacements[index].getPropertyNamed(this.m_property.getName());
            }
            return this.m_property;
        }

        public Element getValue(Element[] originals, Element[] replacements) {
            int index;
            if (this.m_value instanceof Element && (index = this.m_value.indexIn(originals)) != -1) {
                return replacements[index];
            }
            return this.m_value;
        }

        public String toString() {
            return this.m_property + " " + this.m_value;
        }
    }
}

