/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.core;

import edu.cmu.cs.stage3.alice.core.ReferenceFrame;
import edu.cmu.cs.stage3.alice.scenegraph.Appearance;
import edu.cmu.cs.stage3.alice.scenegraph.ShadingStyle;
import edu.cmu.cs.stage3.alice.scenegraph.Visual;

public abstract class Decorator {
    protected Visual m_sgVisual = null;
    protected Appearance m_sgAppearance = null;
    private boolean m_isDirty = true;

    protected abstract ReferenceFrame getReferenceFrame();

    public void markDirty() {
        this.setIsDirty(true);
    }

    public void setIsDirty(boolean isDirty) {
        this.m_isDirty = isDirty;
        if (isDirty) {
            this.updateIfShowing();
        }
    }

    public boolean isDirty() {
        return this.m_isDirty;
    }

    protected void update() {
        ReferenceFrame referenceFrame = this.getReferenceFrame();
        if (referenceFrame != null) {
            if (this.m_sgAppearance == null) {
                this.m_sgAppearance = new Appearance();
                this.m_sgAppearance.setShadingStyle(ShadingStyle.NONE);
                this.m_sgAppearance.setBonus(referenceFrame);
            }
            if (this.m_sgVisual == null) {
                this.m_sgVisual = new Visual();
                this.m_sgVisual.setFrontFacingAppearance(this.m_sgAppearance);
                this.m_sgVisual.setIsShowing(false);
                this.m_sgVisual.setBonus(referenceFrame);
            }
            this.m_sgVisual.setParent(referenceFrame.getSceneGraphContainer());
        }
    }

    protected void updateIfShowing() {
        if (this.isShowing()) {
            this.update();
        }
    }

    public void internalRelease(int pass) {
        switch (pass) {
            case 1: {
                if (this.m_sgVisual == null) break;
                this.m_sgVisual.setFrontFacingAppearance(null);
                this.m_sgVisual.setGeometry(null);
                this.m_sgVisual.setParent(null);
                break;
            }
            case 2: {
                if (this.m_sgVisual != null) {
                    this.m_sgVisual.release();
                    this.m_sgVisual = null;
                }
                if (this.m_sgAppearance == null) break;
                this.m_sgAppearance.release();
                this.m_sgAppearance = null;
            }
        }
    }

    public boolean isShowing() {
        if (this.m_sgVisual == null) {
            return false;
        }
        return this.m_sgVisual.getIsShowing();
    }

    public void setIsShowing(boolean value) {
        if (value) {
            this.update();
            this.showRightNow();
        } else {
            this.hideRightNow();
        }
    }

    public void setIsShowing(Boolean value) {
        this.setIsShowing(value != null && value != false);
    }

    protected void showRightNow() {
        if (this.m_sgVisual != null) {
            this.m_sgVisual.setIsShowing(true);
        }
    }

    protected void hideRightNow() {
        if (this.m_sgVisual != null) {
            this.m_sgVisual.setIsShowing(false);
        }
    }
}

