/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.viewcontroller;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.JAlice;
import edu.cmu.cs.stage3.alice.authoringtool.util.Configuration;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIElement;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.GroupingPanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.Releasable;
import edu.cmu.cs.stage3.alice.authoringtool.util.SetPropertyImmediatelyFactory;
import edu.cmu.cs.stage3.alice.core.Variable;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyListener;
import edu.cmu.cs.stage3.alice.core.event.PropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.PropertyListener;
import edu.cmu.cs.stage3.alice.core.property.ObjectArrayProperty;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class VariablesViewController
extends GroupingPanel
implements GUIElement,
Releasable {
    protected ObjectArrayProperty variables;
    protected RefreshListener refreshListener = new RefreshListener();
    protected boolean sleeping = false;
    protected Configuration authoringToolConfig = Configuration.getLocalConfiguration(JAlice.class.getPackage());

    public VariablesViewController() {
        this.setOpaque(false);
        this.setLayout(new BoxLayout(this, 0));
        this.setBorder(null);
    }

    public void set(ObjectArrayProperty variables) {
        this.clean();
        this.variables = variables;
        if (!this.sleeping) {
            this.startListening();
        }
        this.refreshGUI();
    }

    @Override
    public void goToSleep() {
        if (!this.sleeping) {
            this.stopListening();
            this.sleeping = true;
        }
    }

    @Override
    public void wakeUp() {
        if (this.sleeping) {
            this.startListening();
            this.sleeping = false;
        }
    }

    @Override
    public void die() {
        this.clean();
    }

    @Override
    public void clean() {
        this.stopListening();
        this.removeAll();
        this.variables = null;
    }

    @Override
    public void release() {
        GUIFactory.releaseGUI(this);
    }

    public void refreshGUI() {
        this.removeAll();
        Object[] vars = this.variables.getArrayValue();
        int i = 0;
        while (i < vars.length) {
            Variable variable = (Variable)vars[i];
            if (variable != null) {
                JComponent gui = null;
                if (gui == null) {
                    SetPropertyImmediatelyFactory setImmediatelyFactory = new SetPropertyImmediatelyFactory(variable.value);
                    gui = GUIFactory.getPropertyViewController(variable.value, true, true, false, setImmediatelyFactory);
                }
                this.add(gui);
                if ("true".equalsIgnoreCase((String)AuthoringToolResources.getMiscItem("javaLikeSyntax")) && i < vars.length - 1) {
                    this.add(new JLabel(", "));
                }
            }
            ++i;
        }
    }

    protected void startListening() {
        if (this.variables != null) {
            this.variables.addObjectArrayPropertyListener(this.refreshListener);
            Object[] vars = this.variables.getArrayValue();
            int i = 0;
            while (i < vars.length) {
                if (vars[i] != null) {
                    ((Variable)vars[i]).name.addPropertyListener(this.refreshListener);
                }
                ++i;
            }
        }
    }

    protected void stopListening() {
        if (this.variables != null) {
            this.variables.removeObjectArrayPropertyListener(this.refreshListener);
            Object[] vars = this.variables.getArrayValue();
            int i = 0;
            while (i < vars.length) {
                if (vars[i] != null) {
                    ((Variable)vars[i]).name.removePropertyListener(this.refreshListener);
                }
                ++i;
            }
        }
    }

    class RefreshListener
    implements ObjectArrayPropertyListener,
    PropertyListener {
        RefreshListener() {
        }

        @Override
        public void objectArrayPropertyChanging(ObjectArrayPropertyEvent ev) {
        }

        @Override
        public void objectArrayPropertyChanged(ObjectArrayPropertyEvent ev) {
            Variable variable;
            if (ev.getChangeType() == 1) {
                Variable variable2 = (Variable)ev.getItem();
                if (variable2 != null) {
                    variable2.name.addPropertyListener(this);
                }
            } else if (ev.getChangeType() == 3 && (variable = (Variable)ev.getItem()) != null) {
                variable.name.removePropertyListener(this);
            }
            VariablesViewController.this.refreshGUI();
        }

        @Override
        public void propertyChanging(PropertyEvent ev) {
        }

        @Override
        public void propertyChanged(PropertyEvent ev) {
            VariablesViewController.this.refreshGUI();
        }
    }
}

