/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.viewcontroller;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.util.ExpandablePanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIFactory;
import edu.cmu.cs.stage3.alice.core.TextureMap;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyListener;
import edu.cmu.cs.stage3.alice.core.property.ObjectArrayProperty;
import edu.cmu.cs.stage3.lang.Messages;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class TextureMapsPanel
extends ExpandablePanel {
    protected ObjectArrayProperty textureMaps;
    protected JPanel contentPanel = new JPanel();
    protected HashMap textureMapGuiCache = new HashMap();
    protected JButton importTextureMapButton = new JButton(Messages.getString("import_texture_map"));
    protected AuthoringTool authoringTool;
    protected RefreshListener refreshListener = new RefreshListener();

    public TextureMapsPanel(AuthoringTool authoringTool) {
        this.authoringTool = authoringTool;
        this.guiInit();
    }

    private void guiInit() {
        this.setTitle(Messages.getString("Texture_Maps"));
        this.contentPanel.setLayout(new GridBagLayout());
        this.setContent(this.contentPanel);
        this.importTextureMapButton.setBackground(new Color(240, 240, 255));
        this.importTextureMapButton.setMargin(new Insets(2, 4, 2, 4));
        this.importTextureMapButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                TextureMapsPanel.this.authoringTool.setImportFileFilter("Image Files");
                TextureMapsPanel.this.authoringTool.importElement(null, TextureMapsPanel.this.textureMaps.getOwner());
            }
        });
        this.setOpaque(false);
        this.contentPanel.setOpaque(false);
        this.importTextureMapButton.setToolTipText("<html><font face=arial size=-1>" + Messages.getString("Load_an_Image_File_into_this_World__p__p_Objects_use_image_files_as_textures__p_You_can_change_an_object_s_texture_by_setting_its__b_skin__b__property_") + "</font></html>");
    }

    public void setTextureMaps(ObjectArrayProperty textureMaps) {
        if (this.textureMaps != null) {
            this.textureMaps.removeObjectArrayPropertyListener(this.refreshListener);
        }
        this.textureMaps = textureMaps;
        if (textureMaps != null) {
            textureMaps.addObjectArrayPropertyListener(this.refreshListener);
        }
        this.refreshGUI();
    }

    public void refreshGUI() {
        this.contentPanel.removeAll();
        if (this.textureMaps != null) {
            int count = 0;
            int i = 0;
            while (i < this.textureMaps.size()) {
                TextureMap textureMap = (TextureMap)this.textureMaps.get(i);
                JComponent gui = (JComponent)this.textureMapGuiCache.get(textureMap);
                if (gui == null) {
                    gui = GUIFactory.getGUI(textureMap);
                    this.textureMapGuiCache.put(textureMap, gui);
                }
                if (gui != null) {
                    this.contentPanel.add((Component)gui, new GridBagConstraints(0, count++, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
                } else {
                    AuthoringTool.showErrorDialog(String.valueOf(Messages.getString("Unable_to_create_gui_for_textureMap__")) + textureMap, null);
                }
                ++i;
            }
            this.contentPanel.add((Component)this.importTextureMapButton, new GridBagConstraints(0, count++, 1, 1, 1.0, 0.0, 17, 0, new Insets(4, 2, 4, 2), 0, 0));
            Component glue = Box.createGlue();
            this.contentPanel.add(glue, new GridBagConstraints(0, count++, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        }
        this.revalidate();
        this.repaint();
    }

    protected class RefreshListener
    implements ObjectArrayPropertyListener {
        protected RefreshListener() {
        }

        @Override
        public void objectArrayPropertyChanging(ObjectArrayPropertyEvent ev) {
        }

        @Override
        public void objectArrayPropertyChanged(ObjectArrayPropertyEvent ev) {
            TextureMapsPanel.this.refreshGUI();
        }
    }
}

