/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.viewcontroller;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIElement;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.Releasable;
import edu.cmu.cs.stage3.alice.authoringtool.viewcontroller.ElementDnDPanel;
import edu.cmu.cs.stage3.alice.core.Sound;
import edu.cmu.cs.stage3.media.DataSource;
import edu.cmu.cs.stage3.media.Player;
import edu.cmu.cs.stage3.media.event.DataSourceEvent;
import edu.cmu.cs.stage3.media.event.DataSourceListener;
import edu.cmu.cs.stage3.media.event.PlayerEvent;
import edu.cmu.cs.stage3.media.event.PlayerListener;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SoundViewController
extends JPanel
implements GUIElement,
Releasable {
    private Sound m_sound;
    private Player m_player;
    private SoundPlayStopToggleButton m_soundPlayStopToggleButton = new SoundPlayStopToggleButton();
    private SoundDurationLabel m_soundDurationLabel = new SoundDurationLabel();
    private ElementDnDPanel m_soundDnDPanel;
    private DataSourceListener m_dataSourceListener = new DataSourceListener(){

        @Override
        public void durationUpdated(DataSourceEvent e) {
            SoundViewController.this.m_soundDurationLabel.updateComponent();
        }
    };
    private PlayerListener m_playerListener = new PlayerListener(){

        @Override
        public void stateChanged(PlayerEvent e) {
            SoundViewController.this.m_soundPlayStopToggleButton.updateComponent();
        }

        @Override
        public void endReached(PlayerEvent e) {
        }
    };

    public SoundViewController() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.m_soundPlayStopToggleButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 4, 0, 0), 0, 0));
        this.add((Component)this.m_soundDurationLabel, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 4, 0, 4), 0, 0));
        this.setOpaque(false);
    }

    public void setSound(Sound sound) {
        DataSource dataSourceValue;
        if (this.m_sound != null) {
            dataSourceValue = sound.dataSource.getDataSourceValue();
            if (dataSourceValue != null) {
                dataSourceValue.removeDataSourceListener(this.m_dataSourceListener);
            }
            if (this.m_player != null) {
                this.m_player.stop();
                this.m_player.removePlayerListener(this.m_playerListener);
                this.m_player = null;
            }
        }
        this.m_sound = sound;
        if (sound != null) {
            this.m_soundDnDPanel = GUIFactory.getElementDnDPanel(sound);
            this.add((Component)this.m_soundDnDPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            dataSourceValue = sound.dataSource.getDataSourceValue();
            if (dataSourceValue != null) {
                dataSourceValue.addDataSourceListener(this.m_dataSourceListener);
                dataSourceValue.waitForRealizedPlayerCount(1, 0L);
            }
            this.m_soundDurationLabel.updateComponent();
        }
    }

    protected void startListening() {
    }

    protected void stopListening() {
    }

    @Override
    public void goToSleep() {
        this.stopListening();
        if (this.m_soundDnDPanel != null) {
            this.m_soundDnDPanel.goToSleep();
        }
    }

    @Override
    public void wakeUp() {
        this.startListening();
        if (this.m_soundDnDPanel != null) {
            this.m_soundDnDPanel.wakeUp();
        }
    }

    @Override
    public void clean() {
        this.stopSound();
        this.stopListening();
        if (this.m_soundDnDPanel != null) {
            this.remove(this.m_soundDnDPanel);
            this.m_soundDnDPanel = null;
        }
    }

    @Override
    public void die() {
        this.clean();
    }

    @Override
    public void release() {
        GUIFactory.releaseGUI(this);
        if (this.m_player != null) {
            this.m_player.setIsAvailable(true);
            this.m_player = null;
        }
    }

    public double getSoundDuration() {
        double t = Double.NaN;
        DataSource dataSourceValue = this.m_sound.dataSource.getDataSourceValue();
        if (dataSourceValue != null) {
            t = dataSourceValue.getDuration(true);
        }
        return t;
    }

    public void playSound() {
        DataSource dataSourceValue;
        if (this.m_player == null && this.m_sound != null && (dataSourceValue = this.m_sound.dataSource.getDataSourceValue()) != null) {
            this.m_player = dataSourceValue.acquirePlayer();
            this.m_player.addPlayerListener(this.m_playerListener);
        }
        if (this.m_player != null) {
            this.m_player.startFromBeginning();
        }
    }

    public void stopSound() {
        if (this.m_player != null) {
            this.m_player.stop();
        }
    }

    public int getSoundState() {
        if (this.m_player != null) {
            return this.m_player.getState();
        }
        return 0;
    }

    protected class SoundDurationLabel
    extends JLabel {
        protected SoundDurationLabel() {
        }

        public void updateComponent() {
            this.setText(AuthoringToolResources.formatTime(SoundViewController.this.getSoundDuration()));
        }
    }

    protected class SoundPlayStopToggleButton
    extends JButton {
        protected ImageIcon playIcon;
        protected ImageIcon stopIcon;
        protected ActionListener buttonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (SoundViewController.this.m_sound != null) {
                    if (SoundViewController.this.getSoundState() == 600) {
                        SoundViewController.this.stopSound();
                    } else {
                        SoundViewController.this.playSound();
                    }
                }
            }
        };

        public SoundPlayStopToggleButton() {
            this.playIcon = AuthoringToolResources.getIconForValue("playSound");
            this.stopIcon = AuthoringToolResources.getIconForValue("stopSound");
            this.addActionListener(this.buttonListener);
            this.setOpaque(false);
            this.setBorder(null);
            this.setContentAreaFilled(false);
            this.setFocusPainted(false);
            this.setIcon(this.playIcon);
        }

        public void updateComponent() {
            if (SoundViewController.this.getSoundState() == 600) {
                this.setIcon(this.stopIcon);
            } else {
                this.setIcon(this.playIcon);
            }
        }
    }
}

