/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.viewcontroller;

import edu.cmu.cs.stage3.alice.authoringtool.util.GUIFactory;
import edu.cmu.cs.stage3.alice.core.Media;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyListener;
import edu.cmu.cs.stage3.alice.core.media.SoundMarker;
import edu.cmu.cs.stage3.lang.Messages;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class SoundMarkersPanel
extends JPanel {
    protected Media sound = null;
    protected HashMap soundMarkersGuiCache = new HashMap();
    protected JButton dropMarkerButton = new JButton(Messages.getString("Drop_Marker"));
    protected RefreshListener refreshListener = new RefreshListener();

    public SoundMarkersPanel() {
        this.guiInit();
    }

    private void guiInit() {
        this.setLayout(new GridBagLayout());
        this.dropMarkerButton.setBackground(new Color(240, 240, 255));
        this.dropMarkerButton.setMargin(new Insets(2, 4, 2, 4));
        this.dropMarkerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
            }
        });
    }

    public void refreshGUI() {
        this.removeAll();
        if (this.sound != null && this.sound.markers != null) {
            int count = 0;
            int i = 0;
            while (i < this.sound.markers.size()) {
                SoundMarker marker = (SoundMarker)this.sound.markers.get(i);
                JComponent gui = (JComponent)this.soundMarkersGuiCache.get(marker);
                if (gui == null) {
                    gui = GUIFactory.getGUI(marker);
                    this.soundMarkersGuiCache.put(marker, gui);
                }
                if (gui != null) {
                    this.add((Component)gui, new GridBagConstraints(0, count++, 1, 1, 1.0, 0.0, 17, 0, new Insets(2, 2, 2, 2), 0, 0));
                } else {
                    System.err.println(String.valueOf(Messages.getString("Unable_to_create_gui_for_marker__")) + marker);
                }
                ++i;
            }
            this.add((Component)this.dropMarkerButton, new GridBagConstraints(0, count++, 1, 1, 1.0, 0.0, 17, 0, new Insets(4, 2, 4, 2), 0, 0));
            Component glue = Box.createGlue();
            this.add(glue, new GridBagConstraints(0, count++, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        }
        this.revalidate();
        this.repaint();
    }

    protected class RefreshListener
    implements ObjectArrayPropertyListener {
        protected RefreshListener() {
        }

        @Override
        public void objectArrayPropertyChanging(ObjectArrayPropertyEvent ev) {
        }

        @Override
        public void objectArrayPropertyChanged(ObjectArrayPropertyEvent ev) {
            SoundMarkersPanel.this.refreshGUI();
        }
    }
}

