/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.viewcontroller;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.TransferableFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.CustomMouseAdapter;
import edu.cmu.cs.stage3.alice.authoringtool.util.DnDGroupingPanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.ElementPopupUtilities;
import edu.cmu.cs.stage3.alice.authoringtool.util.FormatTokenizer;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIEffects;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIElement;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.GroupingPanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.SetPropertyImmediatelyFactory;
import edu.cmu.cs.stage3.alice.core.event.PropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.PropertyListener;
import edu.cmu.cs.stage3.alice.core.response.Print;
import edu.cmu.cs.stage3.lang.Messages;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ResponsePrintViewController
extends DnDGroupingPanel
implements GUIElement {
    protected Print printStatement;
    protected JPanel subPanel = new GroupingPanel();
    protected JLabel printPrefixLabel = new JLabel(Messages.getString("Print__"));
    protected JLabel printSuffixLabel = new JLabel("");
    protected HashMap guiMap = new HashMap();
    protected MouseListener mouseListener = new MouseListener();
    protected PropertyListener commentedListener = new PropertyListener(){

        @Override
        public void propertyChanging(PropertyEvent ev) {
        }

        @Override
        public void propertyChanged(PropertyEvent ev) {
            if (ev.getValue().equals(Boolean.TRUE)) {
                ResponsePrintViewController.this.setEnabled(false);
            } else {
                ResponsePrintViewController.this.setEnabled(true);
            }
            ResponsePrintViewController.this.revalidate();
            ResponsePrintViewController.this.repaint();
        }
    };
    protected PropertyListener updateListener = new PropertyListener(){

        @Override
        public void propertyChanging(PropertyEvent ev) {
        }

        @Override
        public void propertyChanged(PropertyEvent ev) {
            ResponsePrintViewController.this.refreshGUI();
        }
    };
    protected boolean sleeping = false;

    public ResponsePrintViewController() {
        this.setBorder(BorderFactory.createEmptyBorder(1, 2, 3, 2));
        this.subPanel.setLayout(new GridBagLayout());
        this.subPanel.setOpaque(false);
        this.subPanel.setBorder(null);
        this.addMouseListener(this.mouseListener);
        this.grip.addMouseListener(this.mouseListener);
        this.subPanel.addMouseListener(this.mouseListener);
    }

    public Print get() {
        return this.printStatement;
    }

    public void set(Print printStatement) {
        super.reset();
        this.stopListening();
        this.printStatement = printStatement;
        if (this.printStatement != null) {
            this.setTransferable(TransferableFactory.createTransferable(printStatement));
            this.setBackground(AuthoringToolResources.getColor("Print"));
            this.add((Component)this.subPanel, "Center");
            this.addDragSourceComponent(this.subPanel);
            this.startListening();
        }
        this.refreshGUI();
    }

    protected void startListening() {
        if (this.printStatement != null) {
            this.printStatement.isCommentedOut.addPropertyListener(this.commentedListener);
            this.printStatement.text.addPropertyListener(this.updateListener);
            this.printStatement.object.addPropertyListener(this.updateListener);
        }
    }

    protected void stopListening() {
        if (this.printStatement != null) {
            this.printStatement.isCommentedOut.removePropertyListener(this.commentedListener);
            this.printStatement.text.removePropertyListener(this.updateListener);
            this.printStatement.object.removePropertyListener(this.updateListener);
        }
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        Component[] children = this.subPanel.getComponents();
        int i = 0;
        while (i < children.length) {
            children[i].setEnabled(b);
            ++i;
        }
    }

    @Override
    public void paintForeground(Graphics g) {
        super.paintForeground(g);
        if (this.printStatement.isCommentedOut.booleanValue()) {
            GUIEffects.paintDisabledEffect(g, this.getBounds());
        }
    }

    @Override
    public void goToSleep() {
        this.stopListening();
        this.sleeping = true;
    }

    @Override
    public void wakeUp() {
        this.startListening();
        this.sleeping = false;
    }

    @Override
    public void clean() {
        this.stopListening();
        this.printStatement = null;
        this.setTransferable(null);
        this.removeAll();
    }

    @Override
    public void die() {
        this.clean();
    }

    @Override
    public void release() {
        super.release();
        GUIFactory.releaseGUI(this);
    }

    public void refreshGUI() {
        this.subPanel.removeAll();
        if (this.printStatement != null) {
            String format = AuthoringToolResources.getFormat(this.printStatement.getClass());
            FormatTokenizer formatTokenizer = new FormatTokenizer(format);
            if (formatTokenizer.hasMoreTokens()) {
                this.printPrefixLabel.setText(formatTokenizer.nextToken());
            } else {
                this.printPrefixLabel.setText("");
            }
            String token = null;
            while (formatTokenizer.hasMoreTokens()) {
                token = formatTokenizer.nextToken();
            }
            if (!(token == null || token.startsWith("<") && token.endsWith(">"))) {
                this.printSuffixLabel.setText(token);
            } else {
                this.printSuffixLabel.setText("");
            }
            int i = 0;
            if (this.printStatement.text.get() == null) {
                boolean omitName = AuthoringToolResources.shouldGUIOmitPropertyName(this.printStatement.object);
                JComponent objectPropertyGui = GUIFactory.getPropertyViewController(this.printStatement.object, true, true, omitName, new SetPropertyImmediatelyFactory(this.printStatement.object));
                this.subPanel.add((Component)this.printPrefixLabel, new GridBagConstraints(i++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.subPanel.add((Component)objectPropertyGui, new GridBagConstraints(i++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.subPanel.add((Component)this.printSuffixLabel, new GridBagConstraints(i++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            } else if (this.printStatement.object.get() == null) {
                boolean omitName = AuthoringToolResources.shouldGUIOmitPropertyName(this.printStatement.text);
                JComponent textPropertyGui = GUIFactory.getPropertyViewController(this.printStatement.text, true, true, omitName, new SetPropertyImmediatelyFactory(this.printStatement.text));
                this.subPanel.add((Component)this.printPrefixLabel, new GridBagConstraints(i++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.subPanel.add((Component)textPropertyGui, new GridBagConstraints(i++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.subPanel.add((Component)this.printSuffixLabel, new GridBagConstraints(i++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            } else {
                boolean omitName = AuthoringToolResources.shouldGUIOmitPropertyName(this.printStatement.text);
                JComponent textPropertyGui = GUIFactory.getPropertyViewController(this.printStatement.text, true, true, omitName, new SetPropertyImmediatelyFactory(this.printStatement.text));
                omitName = AuthoringToolResources.shouldGUIOmitPropertyName(this.printStatement.text);
                JComponent objectPropertyGui = GUIFactory.getPropertyViewController(this.printStatement.object, true, true, omitName, new SetPropertyImmediatelyFactory(this.printStatement.object));
                this.subPanel.add((Component)this.printPrefixLabel, new GridBagConstraints(i++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.subPanel.add((Component)textPropertyGui, new GridBagConstraints(i++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 2), 0, 0));
                this.subPanel.add((Component)objectPropertyGui, new GridBagConstraints(i++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
                this.subPanel.add((Component)this.printSuffixLabel, new GridBagConstraints(i++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            }
            this.subPanel.add(Box.createGlue(), new GridBagConstraints(i++, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        }
        this.revalidate();
        this.repaint();
    }

    class MouseListener
    extends CustomMouseAdapter {
        MouseListener() {
        }

        @Override
        public void popupResponse(MouseEvent ev) {
            Vector structure = ElementPopupUtilities.getDefaultStructure(ResponsePrintViewController.this.printStatement);
            if (structure != null && !structure.isEmpty()) {
                ElementPopupUtilities.createAndShowElementPopupMenu(ResponsePrintViewController.this.printStatement, structure, ResponsePrintViewController.this, ev.getX(), ev.getY());
            }
        }
    }
}

