/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.viewcontroller;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.util.ExpandablePanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIFactory;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.ObjectArrayPropertyListener;
import edu.cmu.cs.stage3.alice.core.property.ObjectArrayProperty;
import edu.cmu.cs.stage3.lang.Messages;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ObjectArrayPropertyPanel
extends ExpandablePanel {
    protected ObjectArrayProperty objectArrayProperty;
    protected JPanel contentPanel = new JPanel();
    protected AuthoringTool authoringTool;
    protected RefreshListener refreshListener = new RefreshListener();

    public ObjectArrayPropertyPanel(String title, AuthoringTool authoringTool) {
        this.authoringTool = authoringTool;
        this.guiInit(title);
    }

    private void guiInit(String title) {
        this.setTitle(title);
        this.contentPanel.setLayout(new GridBagLayout());
        this.setContent(this.contentPanel);
        this.setOpaque(false);
        this.contentPanel.setOpaque(false);
    }

    public void setObjectArrayProperty(ObjectArrayProperty objectArrayProperty) {
        if (this.objectArrayProperty != null) {
            this.objectArrayProperty.removeObjectArrayPropertyListener(this.refreshListener);
        }
        this.objectArrayProperty = objectArrayProperty;
        if (objectArrayProperty != null) {
            objectArrayProperty.addObjectArrayPropertyListener(this.refreshListener);
        }
        this.refreshGUI();
    }

    public void refreshGUI() {
        this.contentPanel.removeAll();
        if (this.objectArrayProperty != null) {
            int count = 0;
            int i = 0;
            while (i < this.objectArrayProperty.size()) {
                Object object = this.objectArrayProperty.get(i);
                JComponent gui = GUIFactory.getGUI(object);
                if (gui != null) {
                    this.contentPanel.add((Component)gui, new GridBagConstraints(0, count++, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 2, 0, 2), 0, 0));
                } else {
                    AuthoringTool.showErrorDialog(String.valueOf(Messages.getString("Unable_to_create_gui_for_object__")) + object, null);
                }
                ++i;
            }
            Component glue = Box.createGlue();
            this.contentPanel.add(glue, new GridBagConstraints(0, count++, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 2, 2, 2), 0, 0));
        }
        this.revalidate();
        this.repaint();
    }

    protected class RefreshListener
    implements ObjectArrayPropertyListener {
        protected RefreshListener() {
        }

        @Override
        public void objectArrayPropertyChanging(ObjectArrayPropertyEvent ev) {
        }

        @Override
        public void objectArrayPropertyChanged(ObjectArrayPropertyEvent ev) {
            ObjectArrayPropertyPanel.this.refreshGUI();
        }
    }
}

