/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.viewcontroller;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.util.PopupItemFactory;
import edu.cmu.cs.stage3.alice.authoringtool.viewcontroller.TextFieldEditablePropertyViewController;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.lang.Messages;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;

public class NumberPropertyViewController
extends TextFieldEditablePropertyViewController {
    protected JLabel numberLabel = new JLabel();

    public void set(Property property, boolean includeDefaults, boolean allowExpressions, boolean omitPropertyName, PopupItemFactory factory) {
        super.set(property, includeDefaults, allowExpressions, true, omitPropertyName, factory);
        this.allowEasyEditWithClick = false;
        this.refreshGUI();
    }

    @Override
    protected void setValueFromString(String valueString) {
        Double value = AuthoringToolResources.parseDouble(valueString);
        if (value != null) {
            ((Runnable)this.factory.createItem(value)).run();
            String propertyKey = "edu.cmu.cs.stage3.alice.authoringtool.userRepr." + this.property.getName();
            this.property.getOwner().data.put(propertyKey, valueString);
        } else {
            AuthoringTool.showErrorDialog(String.valueOf(Messages.getString("I_don_t_understand_this_number__")) + valueString, null, false);
        }
    }

    @Override
    protected Component getNativeComponent() {
        return this.numberLabel;
    }

    @Override
    protected MouseListener getMouseListener() {
        return new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent ev) {
                if (ev.getX() >= 0 && ev.getX() < ev.getComponent().getWidth() && ev.getY() >= 0 && ev.getY() < ev.getComponent().getHeight() && NumberPropertyViewController.this.isEnabled()) {
                    NumberPropertyViewController.this.popupButton.doClick();
                }
            }
        };
    }

    @Override
    protected Class getNativeClass() {
        return Number.class;
    }

    @Override
    protected void updateNativeComponent() {
        this.numberLabel.setText(AuthoringToolResources.getReprForValue(this.property.get(), this.property, this.property.getOwner().data));
    }

    @Override
    protected void refreshGUI() {
        if (this.isAncestorOf(this.textField)) {
            this.remove(this.textField);
        }
        super.refreshGUI();
    }
}

