/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.viewcontroller;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.dialog.FontPanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIElement;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.Releasable;
import edu.cmu.cs.stage3.alice.core.Element;
import edu.cmu.cs.stage3.alice.core.Expression;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.Text3D;
import edu.cmu.cs.stage3.alice.core.event.PropertyEvent;
import edu.cmu.cs.stage3.alice.core.event.PropertyListener;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.swing.DialogManager;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;

public class FontPropertyViewController
extends JButton
implements GUIElement,
Releasable {
    protected Property property;
    protected boolean omitPropertyName;
    protected PropertyListener propertyListener = new PropertyListener(){

        @Override
        public void propertyChanging(PropertyEvent ev) {
        }

        @Override
        public void propertyChanged(PropertyEvent ev) {
            FontPropertyViewController.this.refreshGUI();
        }
    };

    public FontPropertyViewController() {
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (FontPropertyViewController.this.property != null) {
                    Font font;
                    FontPanel fontPanel;
                    boolean isFor3DText = FontPropertyViewController.this.property.getOwner() instanceof Text3D;
                    String sampleText = null;
                    if (isFor3DText) {
                        sampleText = ((Text3D)FontPropertyViewController.this.property.getOwner()).text.getStringValue();
                    }
                    Font currentFont = null;
                    if (FontPropertyViewController.this.property.getValue() instanceof Font) {
                        currentFont = (Font)FontPropertyViewController.this.property.getValue();
                    }
                    if (DialogManager.showConfirmDialog(fontPanel = new FontPanel(currentFont, !isFor3DText, true, sampleText), Messages.getString("Choose_a_Font"), 2, -1) == 0 && (font = fontPanel.getChosenFont()) != null) {
                        FontPropertyViewController.this.property.set(font);
                    }
                }
            }
        });
    }

    public void set(Property property, boolean omitPropertyName) {
        this.clean();
        this.property = property;
        this.omitPropertyName = omitPropertyName;
        this.setBackground(AuthoringToolResources.getColor("propertyViewControllerBackground"));
        this.setMargin(new Insets(0, 4, 0, 4));
        this.startListening();
        this.refreshGUI();
    }

    @Override
    public void goToSleep() {
        this.stopListening();
    }

    @Override
    public void wakeUp() {
        this.startListening();
    }

    @Override
    public void clean() {
        this.stopListening();
    }

    @Override
    public void die() {
        this.stopListening();
    }

    @Override
    public void release() {
        GUIFactory.releaseGUI(this);
    }

    public void startListening() {
        if (this.property != null) {
            this.property.addPropertyListener(this.propertyListener);
        }
    }

    public void stopListening() {
        if (this.property != null) {
            this.property.removePropertyListener(this.propertyListener);
        }
    }

    protected void refreshGUI() {
        Object value = this.property.get();
        StringBuffer repr = new StringBuffer();
        if (!this.omitPropertyName) {
            repr.append(String.valueOf(AuthoringToolResources.getReprForValue(this.property)) + " = ");
        }
        if (value instanceof Expression) {
            repr.append(AuthoringToolResources.getNameInContext((Element)value, this.property.getOwner()));
        } else if (value == null) {
            repr.append(Messages.getString("_None_"));
        } else if (value instanceof Font) {
            Font font = (Font)value;
            repr.append(font.getFontName());
            if (!(this.property.getOwner() instanceof Text3D)) {
                repr.append(", " + font.getSize());
            }
        } else {
            throw new RuntimeException(String.valueOf(Messages.getString("Bad_value__")) + value);
        }
        this.setText(repr.toString());
        this.revalidate();
        this.repaint();
    }
}

