/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.viewcontroller;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.util.PopupItemFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.PopupMenuUtilities;
import edu.cmu.cs.stage3.alice.authoringtool.viewcontroller.PropertyViewController;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.util.Enumerable;
import java.awt.Component;
import javax.swing.JLabel;

public class EnumerablePropertyViewController
extends PropertyViewController {
    protected JLabel enumerableLabel = new JLabel();
    protected Class valueClass;

    public void set(Property property, boolean allowExpressions, boolean omitPropertyName, PopupItemFactory factory) {
        super.set(property, true, allowExpressions, false, omitPropertyName, factory);
        this.valueClass = PopupMenuUtilities.getDesiredValueClass(property);
        if (!Enumerable.class.isAssignableFrom(this.valueClass)) {
            throw new IllegalArgumentException(String.valueOf(Messages.getString("valueClass_of_property_")) + property + " " + Messages.getString("is_not_an_Enumerable__instead__") + this.valueClass);
        }
        this.setPopupEnabled(true);
        this.refreshGUI();
    }

    @Override
    protected Component getNativeComponent() {
        return this.enumerableLabel;
    }

    @Override
    protected Class getNativeClass() {
        return Enumerable.class;
    }

    @Override
    protected void updateNativeComponent() {
        String text = AuthoringToolResources.getReprForValue(this.property.get(), this.property);
        this.enumerableLabel.setText(text);
    }
}

