/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.viewcontroller;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.TransferableFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.DnDGroupingPanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.ElementPrototype;
import edu.cmu.cs.stage3.alice.authoringtool.util.FormatTokenizer;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIElement;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.GroupingPanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.Releasable;
import edu.cmu.cs.stage3.alice.core.Question;
import edu.cmu.cs.stage3.alice.core.Response;
import edu.cmu.cs.stage3.alice.core.question.userdefined.CallToUserDefinedQuestion;
import edu.cmu.cs.stage3.alice.core.response.CallToUserDefinedResponse;
import edu.cmu.cs.stage3.lang.Messages;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ElementPrototypeDnDPanel
extends DnDGroupingPanel
implements GUIElement,
Releasable {
    protected static TilePool tilePool = new TilePool();
    protected ElementPrototype elementPrototype;
    protected JPanel subPanel = new GroupingPanel();
    protected String elementName;
    protected GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0);

    public ElementPrototypeDnDPanel() {
        this.subPanel.setLayout(new GridBagLayout());
        this.subPanel.setOpaque(false);
        this.subPanel.setBorder(null);
        this.add((Component)this.subPanel, "Center");
        this.addDragSourceComponent(this.subPanel);
    }

    public void set(ElementPrototype elementPrototype) {
        this.elementPrototype = elementPrototype;
        this.setTransferable(TransferableFactory.createTransferable(elementPrototype));
        if (CallToUserDefinedResponse.class.isAssignableFrom(elementPrototype.getElementClass())) {
            this.setBackground(AuthoringToolResources.getColor("userDefinedResponse"));
        } else if (Response.class.isAssignableFrom(elementPrototype.getElementClass())) {
            this.setBackground(AuthoringToolResources.getColor("response"));
        } else if (CallToUserDefinedQuestion.class.isAssignableFrom(elementPrototype.getElementClass())) {
            this.setBackground(AuthoringToolResources.getColor("userDefinedQuestion"));
        } else if (Question.class.isAssignableFrom(elementPrototype.getElementClass())) {
            this.setBackground(AuthoringToolResources.getColor("question"));
        } else if (edu.cmu.cs.stage3.alice.core.question.userdefined.Component.class.isAssignableFrom(elementPrototype.getElementClass())) {
            this.setBackground(AuthoringToolResources.getColor("userDefinedQuestionComponent"));
        } else {
            this.setBackground(AuthoringToolResources.getColor("elementPrototypeDnDPanel"));
        }
        this.elementName = AuthoringToolResources.getReprForValue(elementPrototype.getElementClass());
        this.refreshGUI();
    }

    @Override
    public void goToSleep() {
    }

    @Override
    public void wakeUp() {
    }

    @Override
    public void clean() {
        this.elementPrototype = null;
        this.setTransferable(null);
        this.refreshGUI();
    }

    @Override
    public void die() {
        this.clean();
        this.subPanel.removeAll();
        this.removeAll();
    }

    @Override
    public void release() {
        GUIFactory.releaseGUI(this);
    }

    /*
     * Unable to fully structure code
     */
    public void refreshGUI() {
        block7: {
            components = this.subPanel.getComponents();
            i = 0;
            while (i < components.length) {
                if (components[i] instanceof Tile) {
                    this.removeDragSourceComponent(components[i]);
                    ElementPrototypeDnDPanel.tilePool.releaseTile(((Tile)components[i]).getText(), (Tile)components[i]);
                }
                ++i;
            }
            this.subPanel.removeAll();
            if (this.elementPrototype == null) break block7;
            propertyValues = this.elementPrototype.getKnownPropertyValues();
            keys = new Vector<String>();
            propertyMap = new HashMap<String, Object>();
            i = 0;
            while (i < propertyValues.length) {
                keys.add(propertyValues[i].getString());
                propertyMap.put(propertyValues[i].getString(), propertyValues[i].getObject());
                ++i;
            }
            this.constraints.gridx = 0;
            format = AuthoringToolResources.getFormat(this.elementPrototype.getElementClass());
            tokenizer = new FormatTokenizer(format);
            while (tokenizer.hasMoreTokens()) {
                token = tokenizer.nextToken();
                if (token.startsWith("<<<") && token.endsWith(">>>")) {
                    propertyName = token.substring(token.lastIndexOf("<") + 1, token.indexOf(">"));
                    if (keys.contains(propertyName)) {
                        this.addTile(AuthoringToolResources.getReprForValue(propertyMap.get(propertyName), false), true);
                        ++this.constraints.gridx;
                        keys.remove(propertyName);
                        continue;
                    }
                    AuthoringTool.showErrorDialog(String.valueOf(Messages.getString("no_value_available_for_")) + token, null);
                    this.addTile(token, true);
                    ++this.constraints.gridx;
                    continue;
                }
                if (token.startsWith("<<") && token.endsWith(">>")) continue;
                if (!token.startsWith("<") || !token.endsWith(">")) ** GOTO lbl46
                token = token.substring(token.lastIndexOf("<") + 1, token.indexOf(">"));
                this.addTile(token, true);
                ++this.constraints.gridx;
                continue;
lbl-1000:
                // 1 sources

                {
                    token = new StringBuffer(token).replace(token.indexOf("&lt;"), token.indexOf("&lt;") + 4, "<").toString();
lbl46:
                    // 2 sources

                    ** while (token.indexOf((String)"&lt;") > -1)
                }
lbl47:
                // 1 sources

                this.addTile(token, false);
                ++this.constraints.gridx;
            }
        }
        this.revalidate();
        this.repaint();
    }

    public void addTile(String text, boolean opaque) {
        Tile tile = tilePool.getTile(text);
        tile.setOpaque(opaque);
        tile.setBorderEnabled(opaque);
        this.subPanel.add((Component)tile, this.constraints);
        this.addDragSourceComponent(tile);
    }

    public static class Tile
    extends GroupingPanel {
        protected String text;

        public Tile(String text) {
            this.text = text;
            this.setLayout(new BorderLayout());
            this.setBackground(AuthoringToolResources.getColor("prototypeParameter"));
            JLabel tileLabel = new JLabel(text);
            tileLabel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
            this.add((Component)tileLabel, "Center");
        }

        public String getText() {
            return this.text;
        }

        public void setBorderEnabled(boolean enabled) {
            if (enabled) {
                this.setBorder(this.border);
            } else {
                this.setBorder(null);
            }
        }

        @Override
        public void release() {
        }
    }

    static class TilePool {
        protected HashMap tileListMap = new HashMap();

        TilePool() {
        }

        public Tile getTile(String text) {
            LinkedList tileList = (LinkedList)this.tileListMap.get(text);
            if (tileList != null && !tileList.isEmpty()) {
                return (Tile)tileList.removeFirst();
            }
            Tile tilePanel = new Tile(text);
            return tilePanel;
        }

        public void releaseTile(String text, Tile tile) {
            LinkedList<Tile> tileList = (LinkedList<Tile>)this.tileListMap.get(text);
            if (tileList == null) {
                tileList = new LinkedList<Tile>();
                this.tileListMap.put(text, tileList);
            }
            tileList.addFirst(tile);
        }
    }
}

