/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.viewcontroller;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.datatransfer.TransferableFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.DnDGroupingPanel;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIElement;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.Releasable;
import edu.cmu.cs.stage3.alice.authoringtool.viewcontroller.ElementNamePropertyViewController;
import edu.cmu.cs.stage3.alice.core.Element;
import java.awt.Component;
import javax.swing.JLabel;

public class ElementDnDPanel
extends DnDGroupingPanel
implements GUIElement,
Releasable {
    protected Element element;
    protected ElementNamePropertyViewController nameViewController;
    protected JLabel iconLabel = new JLabel();

    public ElementDnDPanel() {
        this.setBackground(AuthoringToolResources.getColor("elementDnDPanel"));
        this.iconLabel.setOpaque(false);
    }

    public void set(Element element) {
        this.clean();
        this.element = element;
        this.nameViewController = GUIFactory.getElementNamePropertyViewController(element);
        this.nameViewController.setBorder(null);
        this.nameViewController.setOpaque(false);
        this.add((Component)this.nameViewController, "Center");
        this.addDragSourceComponent(this.nameViewController);
        this.setTransferable(TransferableFactory.createTransferable(element));
    }

    public void editName() {
        this.nameViewController.editValue();
    }

    protected void startListening() {
        if (this.nameViewController != null) {
            this.nameViewController.startListening();
        }
    }

    protected void stopListening() {
        if (this.nameViewController != null) {
            this.nameViewController.stopListening();
        }
    }

    @Override
    public void goToSleep() {
        this.stopListening();
    }

    @Override
    public void wakeUp() {
        this.startListening();
    }

    @Override
    public void clean() {
        this.removeDragSourceComponent(this.nameViewController);
        this.setTransferable(null);
        if (this.nameViewController != null) {
            this.remove(this.nameViewController);
        }
        this.nameViewController = null;
    }

    @Override
    public void die() {
        this.clean();
    }

    @Override
    public void release() {
        GUIFactory.releaseGUI(this);
    }
}

