/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.viewcontroller;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.util.GUIFactory;
import edu.cmu.cs.stage3.alice.authoringtool.util.PopupItemFactory;
import edu.cmu.cs.stage3.alice.authoringtool.viewcontroller.PropertyViewController;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.scenegraph.Color;
import java.awt.Component;
import java.text.DecimalFormat;
import javax.swing.Box;

public class ColorPropertyViewController
extends PropertyViewController {
    protected Component strut = Box.createHorizontalStrut(16);

    public void set(Property property, boolean allowExpressions, boolean omitPropertyName, PopupItemFactory factory) {
        super.set(property, true, allowExpressions, true, omitPropertyName, factory);
        this.setPopupEnabled(true);
        this.refreshGUI();
    }

    protected String getHTMLColorString(Color color) {
        String r = Integer.toHexString((int)(color.getRed() * 255.0f));
        String g = Integer.toHexString((int)(color.getGreen() * 255.0f));
        String b = Integer.toHexString((int)(color.getBlue() * 255.0f));
        if (r.length() == 1) {
            r = "0" + r;
        }
        if (g.length() == 1) {
            g = "0" + g;
        }
        if (b.length() == 1) {
            b = "0" + b;
        }
        return new String("#" + r + g + b);
    }

    protected String getReadableColorString(Color color) {
        DecimalFormat numberFormatter = new DecimalFormat();
        String toReturn = new String("(");
        toReturn = String.valueOf(toReturn) + numberFormatter.format(color.getRed());
        toReturn = String.valueOf(toReturn) + ", ";
        toReturn = String.valueOf(toReturn) + numberFormatter.format(color.getGreen());
        toReturn = String.valueOf(toReturn) + ", ";
        toReturn = String.valueOf(toReturn) + numberFormatter.format(color.getBlue());
        toReturn = String.valueOf(toReturn) + ")";
        return toReturn;
    }

    @Override
    public void getHTML(StringBuffer toWriteTo) {
        if (this.property.get() instanceof Color) {
            Color color = (Color)this.property.get();
            String colorString = this.getHTMLColorString(color);
            String colorName = AuthoringToolResources.getName(color);
            if (colorName == null) {
                colorName = this.getReadableColorString(color);
            }
            toWriteTo.append("<span style=\"background-color:" + colorString + "\"><font color=" + colorString + "\">" + colorName + "</font></span>");
        } else {
            int i = 0;
            while (i < this.getComponentCount()) {
                toWriteTo.append(GUIFactory.getHTMLStringForComponent(this.getComponent(i)));
                ++i;
            }
        }
    }

    @Override
    protected Component getNativeComponent() {
        return this.strut;
    }

    @Override
    protected Class getNativeClass() {
        return Color.class;
    }

    @Override
    protected void updateNativeComponent() {
        this.setBackground(((Color)this.property.getValue()).createAWTColor());
    }

    @Override
    protected void refreshGUI() {
        this.setBackground(AuthoringToolResources.getColor("propertyViewControllerBackground"));
        super.refreshGUI();
    }
}

