/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.viewcontroller;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.util.PopupItemFactory;
import edu.cmu.cs.stage3.alice.authoringtool.viewcontroller.PropertyViewController;
import edu.cmu.cs.stage3.alice.core.Property;
import edu.cmu.cs.stage3.alice.core.question.And;
import edu.cmu.cs.stage3.alice.core.question.Not;
import edu.cmu.cs.stage3.alice.core.question.Or;
import edu.cmu.cs.stage3.alice.core.question.userdefined.IfElse;
import edu.cmu.cs.stage3.alice.core.response.IfElseInOrder;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;

public class BooleanPropertyViewController
extends PropertyViewController {
    protected JCheckBox checkBox = new JCheckBox();
    protected JLabel booleanLabel = new JLabel();
    protected Color originalForegroundColor = this.booleanLabel.getForeground();

    public BooleanPropertyViewController() {
        this.checkBox.setOpaque(false);
        this.checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                ((Runnable)BooleanPropertyViewController.this.factory.createItem(BooleanPropertyViewController.this.checkBox.isSelected() ? Boolean.TRUE : Boolean.FALSE)).run();
            }
        });
    }

    public void set(Property property, boolean includeDefaults, boolean allowExpressions, boolean omitPropertyName, PopupItemFactory factory) {
        super.set(property, includeDefaults, allowExpressions, false, omitPropertyName, factory);
        if (omitPropertyName) {
            this.add(Box.createHorizontalStrut(8), "West");
        }
        this.refreshGUI();
    }

    @Override
    public void setEditingEnabled(boolean editingEnabled) {
        super.setEditingEnabled(editingEnabled);
        this.checkBox.setEnabled(editingEnabled);
    }

    @Override
    protected Component getNativeComponent() {
        return this.booleanLabel;
    }

    @Override
    protected Class getNativeClass() {
        return Boolean.class;
    }

    @Override
    protected void updateNativeComponent() {
        if (!(this.property.getOwner() instanceof IfElseInOrder || this.property.getOwner() instanceof IfElse || this.property.getOwner() instanceof And || this.property.getOwner() instanceof Or || this.property.getOwner() instanceof Not)) {
            this.booleanLabel.setForeground(this.originalForegroundColor);
        }
        this.booleanLabel.setText(AuthoringToolResources.getReprForValue(this.property.getValue(), this.property, this.property.getOwner().data));
    }
}

