/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringToolResources;
import edu.cmu.cs.stage3.alice.authoringtool.util.CheckForValidityCallback;
import edu.cmu.cs.stage3.alice.core.Model;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.util.StringTypePair;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class TypeChooser
extends JPanel {
    private Class type;
    private ButtonGroup buttonGroup;
    private HashMap typeMap = new HashMap();
    private HashSet changeListeners = new HashSet();
    private JRadioButton numberButton = new JRadioButton(Messages.getString("Number"));
    private JRadioButton booleanButton = new JRadioButton(Messages.getString("Boolean"));
    private JRadioButton objectButton = new JRadioButton(Messages.getString("Object"));
    private JRadioButton otherButton = new JRadioButton(Messages.getString("Other___"));
    private JComboBox otherCombo = new JComboBox();
    private CheckForValidityCallback okButtonCallback;

    public TypeChooser(CheckForValidityCallback okButtonCallback) {
        this.otherCombo.setEditable(false);
        this.okButtonCallback = okButtonCallback;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.gridx = 0;
        this.add((Component)this.numberButton, gbc);
        this.add((Component)this.booleanButton, gbc);
        this.add((Component)this.objectButton, gbc);
        this.add((Component)this.otherButton, gbc);
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        this.add((Component)this.otherCombo, gbc);
        this.buttonGroup = new ButtonGroup();
        this.buttonGroup.add(this.numberButton);
        this.buttonGroup.add(this.booleanButton);
        this.buttonGroup.add(this.objectButton);
        this.buttonGroup.add(this.otherButton);
        ActionListener radioListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                if (ev.getSource() == TypeChooser.this.numberButton) {
                    TypeChooser.this.type = Number.class;
                    TypeChooser.this.otherCombo.setEnabled(false);
                    TypeChooser.this.fireStateChanged(TypeChooser.this.numberButton);
                    TypeChooser.this.checkTypeValidity();
                } else if (ev.getSource() == TypeChooser.this.booleanButton) {
                    TypeChooser.this.type = Boolean.class;
                    TypeChooser.this.otherCombo.setEnabled(false);
                    TypeChooser.this.fireStateChanged(TypeChooser.this.booleanButton);
                    TypeChooser.this.checkTypeValidity();
                } else if (ev.getSource() == TypeChooser.this.objectButton) {
                    TypeChooser.this.type = Model.class;
                    TypeChooser.this.otherCombo.setEnabled(false);
                    TypeChooser.this.fireStateChanged(TypeChooser.this.objectButton);
                    TypeChooser.this.checkTypeValidity();
                } else if (ev.getSource() == TypeChooser.this.otherButton) {
                    TypeChooser.this.otherCombo.setEnabled(true);
                    TypeChooser.this.parseOtherType();
                }
            }
        };
        this.numberButton.addActionListener(radioListener);
        this.booleanButton.addActionListener(radioListener);
        this.objectButton.addActionListener(radioListener);
        this.otherButton.addActionListener(radioListener);
        this.otherCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                TypeChooser.this.parseOtherType();
            }
        });
        StringTypePair[] defaultVariableTypes = AuthoringToolResources.getDefaultVariableTypes();
        int i = 0;
        while (i < defaultVariableTypes.length) {
            this.typeMap.put(defaultVariableTypes[i].getString().trim(), defaultVariableTypes[i].getType());
            this.otherCombo.addItem(new makeObj(defaultVariableTypes[i].getString()));
            ++i;
        }
        ((JTextField)this.otherCombo.getEditor().getEditorComponent()).getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent ev) {
                TypeChooser.this.parseOtherType();
            }

            @Override
            public void insertUpdate(DocumentEvent ev) {
                TypeChooser.this.parseOtherType();
            }

            @Override
            public void removeUpdate(DocumentEvent ev) {
                TypeChooser.this.parseOtherType();
            }
        });
        this.numberButton.setSelected(true);
        this.type = Number.class;
        this.otherCombo.setEnabled(false);
    }

    protected void parseOtherType() {
        makeObj typeString = (makeObj)this.otherCombo.getSelectedItem();
        Class<?> newType = (Class<?>)this.typeMap.get(typeString.getItem());
        if (newType == null) {
            try {
                newType = Class.forName(typeString.getItem());
            }
            catch (ClassNotFoundException e) {
                newType = null;
            }
        }
        if (newType == null) {
            this.otherCombo.getEditor().getEditorComponent().setForeground(Color.red);
        } else {
            this.otherCombo.getEditor().getEditorComponent().setForeground(Color.black);
        }
        if (this.type != newType) {
            this.type = newType;
            this.fireStateChanged(this.otherCombo);
        }
        this.checkTypeValidity();
    }

    private void checkTypeValidity() {
        this.okButtonCallback.setValidity(this, this.type != null);
    }

    public Class getType() {
        if (this.otherButton.isSelected()) {
            this.parseOtherType();
        }
        return this.type;
    }

    public void addCurrentTypeToList() {
        makeObj typeString;
        if (this.otherButton.isSelected() && this.type != null && !this.typeMap.containsKey((typeString = (makeObj)this.otherCombo.getSelectedItem()).getItem())) {
            this.otherCombo.addItem(typeString.getItem());
            this.typeMap.put(typeString.getItem(), this.type);
        }
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeListeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeListeners.remove(listener);
    }

    protected void fireStateChanged(Object source) {
        ChangeEvent ev = new ChangeEvent(source);
        Iterator iter = this.changeListeners.iterator();
        while (iter.hasNext()) {
            ((ChangeListener)iter.next()).stateChanged(ev);
        }
    }

    private class makeObj {
        public String s;

        public makeObj(String item) {
            this.s = item;
        }

        public String getItem() {
            return this.s;
        }

        public String toString() {
            return Messages.getString(this.s.replace(" ", "_"));
        }
    }
}

