/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.JAlice;
import edu.cmu.cs.stage3.lang.Messages;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.Window;

public class SplashScreen
extends Frame {
    protected Image image;
    protected Dimension size;
    protected Window splashWindow;

    public SplashScreen(Image image) {
        this.image = image;
        MediaTracker tracker = new MediaTracker(this);
        tracker.addImage(image, 0);
        try {
            tracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.size = new Dimension(image.getWidth(this), image.getHeight(this));
        if (this.size.width < 1 || this.size.height < 1) {
            this.size = new Dimension(256, 256);
        }
        this.splashWindow = new Window(this){

            @Override
            public void paint(Graphics g) {
                g.drawImage(SplashScreen.this.image, 0, 0, this);
                g.setColor(Color.white);
                g.setFont(new Font("Dialog", 1, 12));
                String versionString = String.valueOf(Messages.getString("version__")) + JAlice.getVersion();
                int stringWidth = g.getFontMetrics().stringWidth(versionString);
                g.drawString(versionString, SplashScreen.this.size.width - 10 - stringWidth, SplashScreen.this.size.height - 6);
                g.drawString(Messages.getString("Loading___"), 10, SplashScreen.this.size.height - 6);
            }
        };
        this.splashWindow.setSize(this.size);
        this.setSize(this.size);
    }

    public void showSplash() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int x = (screenSize.width - this.size.width) / 2;
        int y = (screenSize.height - this.size.height) / 2;
        this.splashWindow.setLocation(x, y);
        this.setLocation(x, y);
        this.splashWindow.setVisible(true);
    }

    public void hideSplash() {
        this.splashWindow.dispose();
    }
}

