/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.util.OneShotScheduler;
import edu.cmu.cs.stage3.alice.core.Sandbox;
import edu.cmu.cs.stage3.alice.scripting.Code;
import edu.cmu.cs.stage3.alice.scripting.CompileType;
import edu.cmu.cs.stage3.lang.Messages;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyObject;

public class ScriptComboWidget
extends JPanel {
    protected Sandbox sandbox;
    protected OneShotScheduler oneShotScheduler = new OneShotScheduler();
    public final AbstractAction runAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent ev) {
            ScriptComboWidget.this.runScript();
        }
    };
    private JComboBox comboBox = new JComboBox();
    private JButton runButton = new JButton(this.runAction);

    public ScriptComboWidget() {
        this.actionInit();
        this.guiInit();
    }

    private void actionInit() {
        this.runAction.putValue("ActionCommandKey", "go");
        this.runAction.putValue("Name", Messages.getString("Go"));
        this.runAction.putValue("ShortDescription", Messages.getString("Execute_the_given_script"));
    }

    public void setSandbox(Sandbox sandbox) {
        this.sandbox = sandbox;
    }

    public void runScript() {
        Object item = this.comboBox.getEditor().getItem();
        if (item instanceof String) {
            String script = ((String)item).trim();
            if (script.length() != 0) {
                try {
                    Code code = this.sandbox.compile(script, "<Run Line>", CompileType.EXEC_SINGLE);
                    this.sandbox.exec(code);
                    int i = 0;
                    while (i < this.comboBox.getItemCount()) {
                        if (script.equals(this.comboBox.getItemAt(i))) {
                            this.comboBox.removeItemAt(i);
                            break;
                        }
                        ++i;
                    }
                    this.comboBox.insertItemAt(script, 0);
                    this.comboBox.setSelectedItem(script);
                }
                catch (PyException e) {
                    Py.printException((Throwable)e, null, (PyObject)AuthoringTool.getPyStdErr());
                }
                catch (Throwable t) {
                    AuthoringTool.showErrorDialog(Messages.getString("Error_running_jython_code_"), t);
                }
            }
        } else {
            this.comboBox.removeItem(item);
        }
    }

    private void guiInit() {
        this.setLayout(new BorderLayout());
        this.comboBox.setEditable(true);
        this.comboBox.getEditor().addActionListener(this.runAction);
        this.add((Component)this.comboBox, "Center");
        this.add((Component)this.runButton, "East");
    }
}

