/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.MainUndoRedoStack;
import edu.cmu.cs.stage3.alice.authoringtool.util.RenderTargetManipulatorMode;
import edu.cmu.cs.stage3.alice.authoringtool.util.SizeUndoableRedoable;
import edu.cmu.cs.stage3.alice.core.Scheduler;
import edu.cmu.cs.stage3.alice.core.Transformable;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.PickInfo;
import edu.cmu.cs.stage3.lang.Messages;
import edu.cmu.cs.stage3.swing.DialogManager;
import java.awt.event.MouseEvent;
import javax.vecmath.Vector3d;

public class ResizeMode
extends RenderTargetManipulatorMode {
    protected Transformable pickedTransformable;
    protected MainUndoRedoStack undoRedoStack;
    protected Scheduler scheduler;
    protected Vector3d oldSize;

    public ResizeMode(MainUndoRedoStack undoRedoStack, Scheduler scheduler) {
        this.undoRedoStack = undoRedoStack;
        this.scheduler = scheduler;
    }

    @Override
    public boolean requiresPickedObject() {
        return true;
    }

    @Override
    public boolean hideCursorOnDrag() {
        return true;
    }

    @Override
    public void mousePressed(MouseEvent ev, Transformable pickedTransformable, PickInfo pickInfo) {
        this.pickedTransformable = pickedTransformable;
        if (pickedTransformable != null) {
            this.oldSize = pickedTransformable.getSize();
        }
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
        if (this.pickedTransformable != null && this.undoRedoStack != null) {
            if (!ev.isPopupTrigger()) {
                this.undoRedoStack.push(new SizeUndoableRedoable(this.pickedTransformable, this.oldSize, this.pickedTransformable.getSize(), this.scheduler));
            }
            if (this.pickedTransformable.poses.size() > 0) {
                DialogManager.showMessageDialog(Messages.getString("Warning__resizing_objects_with_poses_may_make_those_poses_unusable_"), Messages.getString("Pose_warning"), 2);
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent ev, int dx, int dy) {
        if (this.pickedTransformable != null && dy != 0) {
            double divisor = ev.isShiftDown() ? 1000.0 : 100.0;
            double scaleFactor = 1.0 - (double)dy / divisor;
            this.pickedTransformable.resizeRightNow(scaleFactor);
        }
    }
}

