/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.AuthoringTool;
import edu.cmu.cs.stage3.alice.authoringtool.util.Configuration;
import edu.cmu.cs.stage3.alice.authoringtool.util.PointOfViewUndoableRedoable;
import edu.cmu.cs.stage3.alice.authoringtool.util.RenderTargetPickManipulator;
import edu.cmu.cs.stage3.alice.authoringtool.util.UndoRedoStack;
import edu.cmu.cs.stage3.alice.core.Scheduler;
import edu.cmu.cs.stage3.alice.scenegraph.Camera;
import edu.cmu.cs.stage3.alice.scenegraph.Scene;
import edu.cmu.cs.stage3.alice.scenegraph.Transformable;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.OnscreenRenderTarget;
import edu.cmu.cs.stage3.math.MathUtilities;
import edu.cmu.cs.stage3.math.Matrix44;
import java.awt.event.MouseEvent;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;

public class RenderTargetOrbitManipulator
extends RenderTargetPickManipulator {
    protected Transformable helper = new Transformable();
    protected Camera sgCamera = null;
    protected edu.cmu.cs.stage3.alice.core.Transformable eCameraTransformable = null;
    protected Transformable sgCameraTransformable = null;
    protected Scene sgScene = null;
    protected Transformable sgIdentity = new Transformable();
    protected Vector3d tempVec = new Vector3d();
    protected Vector4d tempVec4 = new Vector4d();
    protected Matrix44 oldTransformation;
    protected double orbitRotationFactor;
    protected double orbitZoomFactor;
    protected double sizeFactor;
    protected boolean clippingPlaneAdjustmentEnabled = false;
    protected UndoRedoStack undoRedoStack;
    protected Scheduler scheduler;
    private Configuration orbitConfig = Configuration.getLocalConfiguration(RenderTargetOrbitManipulator.class.getPackage());

    public RenderTargetOrbitManipulator(OnscreenRenderTarget renderTarget, UndoRedoStack undoRedoStack, Scheduler scheduler) {
        super(renderTarget);
        this.undoRedoStack = undoRedoStack;
        this.scheduler = scheduler;
        this.helper.setName("helper");
        this.configInit();
    }

    public void setClippingPlaneAdjustmentEnabled(boolean enabled) {
        this.clippingPlaneAdjustmentEnabled = enabled;
    }

    private void configInit() {
        if (this.orbitConfig.getValue("renderTargetOrbitManipulator.orbitRotationFactor") == null) {
            this.orbitConfig.setValue("renderTargetOrbitManipulator.orbitRotationFactor", Double.toString(0.02));
        }
        if (this.orbitConfig.getValue("renderTargetOrbitManipulator.orbitZoomFactor") == null) {
            this.orbitConfig.setValue("renderTargetOrbitManipulator.orbitZoomFactor", Double.toString(0.05));
        }
    }

    @Override
    public void mousePressed(MouseEvent ev) {
        if (this.enabled) {
            super.mousePressed(ev);
            this.orbitRotationFactor = Double.parseDouble(this.orbitConfig.getValue("renderTargetOrbitManipulator.orbitRotationFactor"));
            this.orbitZoomFactor = Double.parseDouble(this.orbitConfig.getValue("renderTargetOrbitManipulator.orbitZoomFactor"));
            if (this.sgPickedTransformable == null && this.objectsOfInterest.size() == 1) {
                this.ePickedTransformable = (edu.cmu.cs.stage3.alice.core.Transformable)this.objectsOfInterest.iterator().next();
                this.sgPickedTransformable = this.ePickedTransformable.getSceneGraphTransformable();
                AuthoringTool.getHack().getUndoRedoStack().setIsListening(false);
                this.mouseIsDown = true;
            }
            if (this.sgPickedTransformable != null) {
                this.sizeFactor = Math.max(0.1, this.ePickedTransformable.getBoundingSphere().getRadius());
                this.sgCamera = this.renderTarget.getCameras()[0];
                this.sgCameraTransformable = (Transformable)this.sgCamera.getParent();
                this.eCameraTransformable = (edu.cmu.cs.stage3.alice.core.Transformable)this.sgCameraTransformable.getBonus();
                this.sgScene = (Scene)this.sgCamera.getRoot();
                this.oldTransformation = new Matrix44(this.sgCameraTransformable.getLocalTransformation());
                this.helper.setParent(this.sgScene);
                this.sgIdentity.setParent(this.sgScene);
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
        if (this.mouseIsDown && this.eCameraTransformable != null) {
            this.undoRedoStack.push(new PointOfViewUndoableRedoable(this.eCameraTransformable, this.oldTransformation, new Matrix44(this.sgCameraTransformable.getLocalTransformation()), this.scheduler));
        }
        super.mouseReleased(ev);
    }

    @Override
    public void mouseDragged(MouseEvent ev) {
        if (this.enabled) {
            super.mouseDragged(ev);
            if (this.mouseIsDown && this.sgPickedTransformable != null) {
                if (this.clippingPlaneAdjustmentEnabled) {
                    double objectRadius = this.ePickedTransformable.getBoundingSphere().getRadius();
                    double objectDist = this.sgPickedTransformable.getPosition(this.sgCameraTransformable).getLength();
                    double farDist = Math.max(objectDist * 3.0, objectDist + objectRadius);
                    double nearDist = Math.max((objectDist - objectRadius) * 0.01, 1.0E-4);
                    this.sgCamera.setFarClippingPlaneDistance(farDist);
                }
                boolean controlDown = ev.isControlDown();
                boolean shiftDown = ev.isShiftDown();
                this.tempVec.x = 0.0;
                this.tempVec.y = 0.0;
                this.tempVec.z = 0.0;
                this.helper.setPosition(this.tempVec, this.sgPickedTransformable);
                this.helper.pointAt(this.sgCameraTransformable, null, MathUtilities.getYAxis(), null);
                this.helper.standUp(this.sgScene);
                this.sgCameraTransformable.pointAt(this.helper, null, MathUtilities.getYAxis(), null);
                if (controlDown) {
                    // empty if block
                }
                if (shiftDown) {
                    this.sgCameraTransformable.rotate(MathUtilities.getYAxis(), (double)this.dx * this.orbitRotationFactor, this.helper);
                    this.sgCameraTransformable.rotate(MathUtilities.getXAxis(), (double)(-this.dy) * this.orbitRotationFactor, this.helper);
                } else {
                    this.sgCameraTransformable.translate(MathUtilities.multiply(MathUtilities.getZAxis(), (double)this.dy * this.orbitZoomFactor * this.sizeFactor), this.sgCameraTransformable);
                    this.sgCameraTransformable.rotate(MathUtilities.getYAxis(), (double)this.dx * this.orbitRotationFactor, this.helper);
                }
                if (this.eCameraTransformable != null) {
                    this.eCameraTransformable.localTransformation.set(this.sgCameraTransformable.getLocalTransformation());
                }
            }
        }
    }
}

