/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.cs.stage3.alice.authoringtool.util;

import edu.cmu.cs.stage3.alice.authoringtool.util.RenderTargetManipulatorMode;
import edu.cmu.cs.stage3.alice.authoringtool.util.RenderTargetPickManipulator;
import edu.cmu.cs.stage3.alice.scenegraph.renderer.OnscreenRenderTarget;
import java.awt.Cursor;
import java.awt.event.MouseEvent;

public class RenderTargetMultiManipulator
extends RenderTargetPickManipulator {
    protected RenderTargetManipulatorMode mode;

    public RenderTargetMultiManipulator(OnscreenRenderTarget renderTarget) {
        super(renderTarget);
        this.setPopupEnabled(true);
    }

    public RenderTargetManipulatorMode getMode() {
        return this.mode;
    }

    public void setMode(RenderTargetManipulatorMode mode) {
        this.mode = mode;
        if (mode != null) {
            this.setHideCursorOnDrag(mode.hideCursorOnDrag());
            if (this.renderTarget.getAWTComponent() != null) {
                if (mode.getPreferredCursor() != null) {
                    this.renderTarget.getAWTComponent().setCursor(mode.getPreferredCursor());
                } else {
                    this.renderTarget.getAWTComponent().setCursor(Cursor.getDefaultCursor());
                }
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent ev) {
        if (this.enabled) {
            super.mousePressed(ev);
            if (this.mode != null) {
                if (this.mode.requiresPickedObject() && this.ePickedTransformable != null && !this.ePickedTransformable.doEventsStopAscending() && this.ascendTreeEnabled) {
                    this.abortAction();
                } else if (this.mode.requiresPickedObject() && this.ePickedTransformable == null) {
                    this.abortAction();
                } else {
                    this.mode.setRenderTarget(this.renderTarget);
                    this.mode.mousePressed(ev, this.ePickedTransformable, this.pickInfo);
                }
            } else {
                this.abortAction();
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent ev) {
        if (this.enabled && !this.isActionAborted()) {
            this.mode.setRenderTarget(this.renderTarget);
            this.mode.mouseReleased(ev);
        }
        super.mouseReleased(ev);
    }

    @Override
    public void mouseDragged(MouseEvent ev) {
        if (this.enabled && !this.isActionAborted()) {
            super.mouseDragged(ev);
            if (this.mouseIsDown) {
                this.mode.setRenderTarget(this.renderTarget);
                this.mode.mouseDragged(ev, this.dx, this.dy);
            }
        }
    }
}

